/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.common.capability.provider.StaminaProvider;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.common.network.SyncStaminaMessage;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;

public class Stamina {
    private static final int COOL_TIME = 30;
    private int maxStamina = 2000;
    private boolean infinite = false;
    private int stamina = this.getMaxStamina();
    private boolean exhausted = false;
    private int coolTime = 0;

    public static Stamina get(Player player) {
        LazyOptional optional = player.getCapability(StaminaProvider.STAMINA_CAPABILITY);
        if (!optional.isPresent()) {
            return null;
        }
        return (Stamina)optional.orElseThrow(IllegalStateException::new);
    }

    public int getStamina() {
        return this.stamina;
    }

    public int getMaxStamina() {
        return this.maxStamina;
    }

    public void setStamina(int stamina) {
        this.stamina = stamina;
    }

    public void consume(int amount, Player player) {
        if (this.exhausted || this.infinite) {
            return;
        }
        if (((Boolean)ParCoolConfig.CONFIG_CLIENT.useHungerBarInsteadOfStamina.get()).booleanValue()) {
            player.m_36399_((float)amount / 1000.0f);
        } else {
            this.stamina -= amount;
        }
        this.coolTime = 30;
        if (this.stamina <= 0) {
            this.stamina = 0;
            this.exhausted = true;
        }
    }

    public void recover(int amount) {
        if (this.coolTime > 0) {
            return;
        }
        this.stamina += amount;
        if (this.stamina >= this.getMaxStamina()) {
            this.stamina = this.getMaxStamina();
            this.exhausted = false;
        }
    }

    public boolean isExhausted() {
        return this.exhausted;
    }

    public void onTick(ActionInfo info) {
        this.infinite = info.isStaminaInfinite();
        this.maxStamina = info.getMaxStamina();
        if (this.coolTime > 0) {
            --this.coolTime;
        }
        if (this.coolTime == 0) {
            this.recover(this.getMaxStamina() / 60);
        }
    }

    public void synchronize(SyncStaminaMessage message) {
        this.exhausted = message.isExhausted();
        this.stamina = message.getStamina();
    }

    public int getRecoveryCoolTime() {
        return this.coolTime;
    }
}

