/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.alrex.parcool.common.network.ResetFallDistanceMessage;
import com.alrex.parcool.utilities.VectorUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class WallJump
extends Action {
    private boolean jump = false;

    public boolean justJumped() {
        return this.jump;
    }

    @Override
    public void onTick(Player player, Parkourability parkourability, Stamina stamina) {
        this.jump = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private Vec3 getJumpDirection(Player player) {
        Vec3 value;
        Vec3 wall = WorldUtil.getWall((LivingEntity)player);
        if (wall == null) {
            return null;
        }
        Vec3 lookVec = player.m_20154_();
        Vec3 vec = new Vec3(lookVec.m_7096_(), 0.0, lookVec.m_7094_()).m_82541_();
        if (wall.m_82526_(vec) > 0.0) {
            if (((Boolean)ParCoolConfig.CONFIG_CLIENT.disableWallJumpTowardWall.get()).booleanValue()) {
                return null;
            }
            double dot = vec.m_82548_().m_82526_(wall);
            value = vec.m_82549_(wall.m_82490_(2.0 * dot / wall.m_82553_()));
        } else {
            value = vec;
        }
        return value.m_82541_().m_82549_(wall.m_82490_(-0.7));
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean canWallJump(Player player, Parkourability parkourability, Stamina stamina) {
        return !stamina.isExhausted() && parkourability.getPermission().canWallJump() && !player.m_20096_() && !player.m_20072_() && !player.m_21255_() && !player.m_150110_().f_35935_ && !parkourability.getClingToCliff().isCling() && parkourability.getClingToCliff().getNotClingTick() > 3 && KeyRecorder.keyJumpState.isPressed() && !parkourability.getCrawl().isCrawling() && parkourability.getAdditionalProperties().getNotLandingTick() > 5 && WorldUtil.getWall((LivingEntity)player) != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, Stamina stamina) {
        if (player.m_7578_() && this.canWallJump(player, parkourability, stamina)) {
            Vec3 jumpDirection = this.getJumpDirection(player);
            if (jumpDirection == null) {
                return;
            }
            if (((Boolean)ParCoolConfig.CONFIG_CLIENT.autoTurningWallJump.get()).booleanValue()) {
                player.m_146922_((float)VectorUtil.toYawDegree(jumpDirection));
            }
            Vec3 direction = new Vec3(jumpDirection.m_7096_(), 1.4, jumpDirection.m_7094_()).m_82490_(0.3);
            Vec3 motion = player.m_20184_();
            stamina.consume(parkourability.getActionInfo().getStaminaConsumptionWallJump(), player);
            player.m_20334_(motion.m_7096_() + direction.m_7096_(), motion.m_7098_() > direction.m_7098_() ? motion.f_82480_ + direction.m_7098_() : direction.m_7098_(), motion.m_7094_() + direction.m_7094_());
            this.jump = true;
            ResetFallDistanceMessage.sync(player);
        }
    }

    @Override
    public void onRender(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
    }

    @Override
    public void saveState(ByteBuffer buffer) {
    }

    @Override
    public void restoreState(ByteBuffer buffer) {
    }
}

