/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.TapAnimator;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.alrex.parcool.utilities.BufferUtil;
import java.nio.ByteBuffer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class Tap
extends Action {
    private boolean start = false;
    private boolean tapping = false;
    private int tappingTick = 0;

    public boolean isTapping() {
        return this.tapping;
    }

    @Override
    public void onTick(Player player, Parkourability parkourability, Stamina stamina) {
        this.tappingTick = this.tapping ? ++this.tappingTick : 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, Stamina stamina) {
        Animation animation;
        if ((this.tapping && this.tappingTick <= 1 || this.start) && (animation = Animation.get(player)) != null) {
            animation.setAnimator(new TapAnimator());
        }
        if (this.start) {
            this.start = false;
            this.tapping = true;
        }
        if (player.m_7578_()) {
            if (this.tapping) {
                player.m_20256_(player.m_20184_().m_82490_(0.01));
            }
            if (this.tappingTick >= this.getMaxTappingTick()) {
                this.tapping = false;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
    }

    @Override
    public void restoreState(ByteBuffer buffer) {
        this.start = BufferUtil.getBoolean(buffer);
        this.tapping = BufferUtil.getBoolean(buffer);
    }

    @Override
    public void saveState(ByteBuffer buffer) {
        BufferUtil.wrap(buffer).putBoolean(this.start).putBoolean(this.tapping);
    }

    public void startTap(Player player) {
        this.start = true;
    }

    public int getMaxTappingTick() {
        return 8;
    }
}

