/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.HorizontalWallRunAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.VectorUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class HorizontalWallRun
extends Action {
    private boolean wallRunning = false;
    private int wallRunningTick = 0;
    private int coolTime = 0;
    private static final int Max_Running_Tick = 14;
    private boolean wallIsRightward = false;

    public boolean isWallRunning() {
        return this.wallRunning;
    }

    public boolean isWallRightSide() {
        return this.wallIsRightward;
    }

    @Override
    public void onTick(Player player, Parkourability parkourability, Stamina stamina) {
        if (this.wallRunning) {
            ++this.wallRunningTick;
            Vec3 movement = player.m_20184_();
            player.m_20334_(movement.m_7096_(), 0.0, movement.m_7094_());
        } else {
            this.wallRunningTick = 0;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, Stamina stamina) {
        Animation animation;
        if (player.m_7578_()) {
            if (this.coolTime > 0) {
                --this.coolTime;
            }
            boolean oldRunning = this.wallRunning;
            this.wallRunning = false;
            if (!oldRunning && parkourability.getPermission().canHorizontalWallRun() && parkourability.getFastRun().canActWithRunning(player) && !parkourability.getWallJump().justJumped() && !parkourability.getCrawl().isCrawling() && KeyBindings.getKeyHorizontalWallRun().m_90857_() && Math.abs(player.m_20184_().m_7098_()) < 0.3 && this.coolTime == 0 && !player.m_20096_() && parkourability.getAdditionalProperties().getNotLandingTick() > 5 && !stamina.isExhausted() || oldRunning && parkourability.getPermission().canHorizontalWallRun() && !parkourability.getWallJump().justJumped() && !parkourability.getCrawl().isCrawling() && KeyBindings.getKeyHorizontalWallRun().m_90857_() && !player.m_20096_()) {
                Vec3 dividedVec;
                Vec3 wallDirection = WorldUtil.getWall((LivingEntity)player);
                Vec3 direction = VectorUtil.fromYawDegree(player.f_20883_);
                direction = new Vec3(direction.m_7096_(), 0.0, direction.m_7094_()).m_82541_();
                if (wallDirection != null && Math.abs((dividedVec = new Vec3((wallDirection = wallDirection.m_82541_()).m_7096_() * direction.m_7096_() + wallDirection.m_7094_() * direction.m_7094_(), 0.0, -wallDirection.m_7096_() * direction.m_7094_() + wallDirection.m_7094_() * direction.m_7096_()).m_82541_()).m_7094_()) > 0.9) {
                    this.wallIsRightward = dividedVec.m_7094_() > 0.0;
                    this.wallRunning = true;
                }
            }
            if (oldRunning != this.wallRunning && !this.wallRunning) {
                this.coolTime = 10;
            }
            if (this.wallRunningTick > 14) {
                this.wallRunning = false;
                this.coolTime = 10;
            }
        }
        if (this.wallRunning && this.wallRunningTick <= 3 && (animation = Animation.get(player)) != null) {
            animation.setAnimator(new HorizontalWallRunAnimator());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
    }

    @Override
    public void restoreState(ByteBuffer buffer) {
        this.wallRunning = BufferUtil.getBoolean(buffer);
        this.wallIsRightward = BufferUtil.getBoolean(buffer);
    }

    @Override
    public void saveState(ByteBuffer buffer) {
        BufferUtil.wrap(buffer).putBoolean(this.wallRunning).putBoolean(this.wallIsRightward);
    }
}

