/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.FlippingAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.alrex.parcool.utilities.BufferUtil;
import java.nio.ByteBuffer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class Flipping
extends Action {
    private FlippingDirection direction = null;
    private int flippingTick = 0;
    private boolean flipping = false;

    public boolean isFlipping() {
        return this.flipping;
    }

    public FlippingDirection getDirection() {
        return this.direction;
    }

    @Override
    public void onTick(Player player, Parkourability parkourability, Stamina stamina) {
        this.flippingTick = this.flipping ? ++this.flippingTick : 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, Stamina stamina) {
        Animation animation;
        if (player.m_7578_()) {
            if (!this.flipping && parkourability.getPermission().canFlipping() && parkourability.getAdditionalProperties().getNotLandingTick() <= 1 && KeyBindings.getKeyRight().m_90857_() && KeyRecorder.keyRight.getTickKeyDown() < 3 && KeyBindings.getKeyLeft().m_90857_() && KeyRecorder.keyLeft.getTickKeyDown() < 3) {
                player.m_6135_();
                this.startFlipping(player, parkourability, stamina);
            }
            if (player.m_20096_() && this.flippingTick > 2) {
                this.stopFlipping(player);
            }
        }
        if (this.flipping && this.flippingTick <= 1 && (animation = Animation.get(player)) != null) {
            animation.setAnimator(new FlippingAnimator(player.m_146909_()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void startFlipping(Player player, Parkourability parkourability, Stamina stamina) {
        this.flipping = true;
        this.flippingTick = 0;
        this.direction = KeyBindings.getKeyBack().m_90857_() ? FlippingDirection.Back : FlippingDirection.Front;
        this.synchronizeExplicitly(player);
        stamina.consume(parkourability.getActionInfo().getStaminaConsumptionFlipping(), player);
    }

    private void stopFlipping(Player player) {
        this.synchronizeExplicitly(player);
        this.flipping = false;
        this.flippingTick = 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
    }

    @Override
    public void restoreState(ByteBuffer buffer) {
        this.flipping = BufferUtil.getBoolean(buffer);
        this.direction = FlippingDirection.getFromCode(buffer.getInt());
    }

    @Override
    public void saveState(ByteBuffer buffer) {
        BufferUtil.wrap(buffer).putBoolean(this.flipping).unwrap().putInt(this.direction == null ? -1 : this.direction.getCode());
    }

    public static enum FlippingDirection {
        Front,
        Back;


        public int getCode() {
            switch (this) {
                case Front: {
                    return 0;
                }
                case Back: {
                    return 1;
                }
            }
            return -1;
        }

        public static FlippingDirection getFromCode(int code) {
            switch (code) {
                case 0: {
                    return Front;
                }
                case 1: {
                    return Back;
                }
            }
            return null;
        }
    }
}

