/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.impl.CrawlAnimator;
import com.alrex.parcool.client.animation.impl.SlidingAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.EntityUtil;
import com.alrex.parcool.utilities.VectorUtil;
import java.nio.ByteBuffer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class Crawl
extends Action {
    private int slidingTick = 0;
    private Vec3 slidingVec = null;
    private boolean crawling = false;
    private boolean sliding = false;

    @Override
    public void onTick(Player player, Parkourability parkourability, Stamina stamina) {
        this.slidingTick = this.sliding ? ++this.slidingTick : 0;
        if (this.sliding || this.crawling) {
            player.m_6858_(false);
            player.m_20124_(Pose.SWIMMING);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, Stamina stamina) {
        Animation animation;
        if (player.m_7578_()) {
            if (!(!parkourability.getPermission().canCrawl() || this.crawling || !KeyRecorder.keyCrawlState.isPressed() || parkourability.getRoll().isRolling() || parkourability.getTap().isTapping() || player.m_20072_() || !player.m_20096_() && ((Boolean)ParCoolConfig.CONFIG_CLIENT.disableCrawlInAir.get()).booleanValue())) {
                if (parkourability.getFastRun().getDashTick(parkourability.getAdditionalProperties()) > 5) {
                    this.sliding = true;
                    Vec3 lookVec = player.m_20154_();
                    this.slidingVec = new Vec3(lookVec.m_7096_(), 0.0, lookVec.m_7094_()).m_82541_();
                } else {
                    this.sliding = false;
                    this.slidingVec = null;
                }
                this.crawling = true;
            }
            if (this.slidingVec == null) {
                this.sliding = false;
            }
            if (this.sliding && player.m_20096_()) {
                Vec3 vec = this.slidingVec.m_82490_(0.2);
                EntityUtil.addVelocity((Entity)player, vec);
            }
            if (this.slidingTick >= parkourability.getActionInfo().getMaxSlidingTick()) {
                this.sliding = false;
                this.slidingTick = 0;
                this.crawling = true;
                this.slidingVec = null;
            }
            if (this.crawling && !KeyBindings.getKeyCrawl().m_90857_()) {
                this.crawling = false;
                this.sliding = false;
                this.slidingVec = null;
            }
            if (!this.crawling) {
                this.sliding = false;
            }
        }
        if ((this.sliding || this.crawling) && (animation = Animation.get(player)) != null && !animation.hasAnimator()) {
            if (this.sliding) {
                animation.setAnimator(new SlidingAnimator());
            } else {
                animation.setAnimator(new CrawlAnimator());
            }
        }
    }

    @Override
    public void onRender(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
        if (this.slidingVec == null || !this.sliding) {
            return;
        }
        player.m_146922_((float)VectorUtil.toYawDegree(this.slidingVec));
    }

    @Override
    public void restoreState(ByteBuffer buffer) {
        this.crawling = BufferUtil.getBoolean(buffer);
        this.sliding = BufferUtil.getBoolean(buffer);
    }

    @Override
    public void saveState(ByteBuffer buffer) {
        BufferUtil.wrap(buffer).putBoolean(this.crawling).putBoolean(this.sliding);
    }

    public boolean isCrawling() {
        return this.crawling;
    }

    public boolean isSliding() {
        return this.sliding;
    }
}

