/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.alrex.parcool.utilities.BufferUtil;
import java.nio.ByteBuffer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class Breakfall
extends Action {
    private boolean ready = false;
    private int readyTick = 0;
    private int readyCoolTick = 0;

    public boolean isReady() {
        return this.ready;
    }

    public int getReadyTick() {
        return this.readyTick;
    }

    @Override
    public void onTick(Player player, Parkourability parkourability, Stamina stamina) {
        this.readyTick = this.ready ? ++this.readyTick : 0;
    }

    public void startBreakfall(Player player, Parkourability parkourability, Stamina stamina) {
        this.ready = false;
        this.readyTick = 0;
        this.synchronizeExplicitly(player);
        stamina.consume(parkourability.getActionInfo().getStaminaConsumptionBreakfall(), player);
        if (KeyBindings.getKeyForward().m_90857_()) {
            parkourability.getRoll().startRoll(player);
        } else {
            parkourability.getTap().startTap(player);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, Stamina stamina) {
        if (player.m_7578_()) {
            this.ready = parkourability.getPermission().canBreakfall() && KeyBindings.getKeyBreakfall().m_90857_() && !stamina.isExhausted() && !parkourability.getCrawl().isCrawling() && !player.m_20072_() && (!player.m_20096_() || parkourability.getAdditionalProperties().getLandingTick() < 3);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
    }

    @Override
    public void restoreState(ByteBuffer buffer) {
        this.ready = BufferUtil.getBoolean(buffer);
    }

    @Override
    public void saveState(ByteBuffer buffer) {
        BufferUtil.wrap(buffer).putBoolean(this.ready);
    }
}

