/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action;

import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.alrex.parcool.common.network.SyncActionStateMessage;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class ActionProcessor {
    public final ByteBuffer bufferOfPostState = ByteBuffer.allocate(128);
    public final ByteBuffer bufferOfPreState = ByteBuffer.allocate(128);

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTickInClient(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        Animation animation = Animation.get(player);
        if (animation == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get(player);
        if (parkourability == null) {
            return;
        }
        animation.tick(player, parkourability);
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        Parkourability parkourability = Parkourability.get(player);
        Stamina stamina = Stamina.get(player);
        if (parkourability == null || stamina == null) {
            return;
        }
        List<Action> actions = parkourability.getList();
        stamina.onTick(parkourability.getActionInfo());
        boolean needSync = event.side == LogicalSide.CLIENT && player.m_7578_();
        SyncActionStateMessage.Builder builder = SyncActionStateMessage.Builder.main();
        block0: for (Action action : actions) {
            if (needSync) {
                this.bufferOfPreState.clear();
                action.saveState(this.bufferOfPreState);
                this.bufferOfPreState.flip();
            }
            action.onTick(player, parkourability, stamina);
            if (event.side == LogicalSide.CLIENT) {
                action.onClientTick(player, parkourability, stamina);
            }
            if (!needSync) continue;
            this.bufferOfPostState.clear();
            action.saveState(this.bufferOfPostState);
            this.bufferOfPostState.flip();
            while (this.bufferOfPreState.hasRemaining()) {
                if (this.bufferOfPostState.get() == this.bufferOfPreState.get()) continue;
                this.bufferOfPostState.rewind();
                builder.append(action, this.bufferOfPostState);
                continue block0;
            }
        }
        if (needSync) {
            SyncActionStateMessage.sync(player, builder);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        List<Action> actions = parkourability.getList();
        for (Action action : actions) {
            action.onRender(event, (Player)player, parkourability);
        }
        Animation animation = Animation.get((Player)player);
        if (animation == null) {
            return;
        }
        animation.onRenderTick(event);
    }
}

