/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.input;

import com.alrex.parcool.client.input.KeyBindings;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class KeyRecorder {
    public static final KeyState keyForward = new KeyState();
    public static final KeyState keyBack = new KeyState();
    public static final KeyState keyRight = new KeyState();
    public static final KeyState keyLeft = new KeyState();
    public static final KeyState keyJumpState = new KeyState();
    public static final KeyState keySprintState = new KeyState();
    public static final KeyState keyCrawlState = new KeyState();
    public static final KeyState keyOpenSettingsState = new KeyState();
    public static final KeyState keyFastRunning = new KeyState();
    public static final KeyState keyDodge = new KeyState();
    public static final KeyState keyBreakfall = new KeyState();

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        KeyRecorder.record(KeyBindings.getKeyForward(), keyForward);
        KeyRecorder.record(KeyBindings.getKeyBack(), keyBack);
        KeyRecorder.record(KeyBindings.getKeyRight(), keyRight);
        KeyRecorder.record(KeyBindings.getKeyLeft(), keyLeft);
        KeyRecorder.record(KeyBindings.getKeyJump(), keyJumpState);
        KeyRecorder.record(KeyBindings.getKeySprint(), keySprintState);
        KeyRecorder.record(KeyBindings.getKeyCrawl(), keyCrawlState);
        KeyRecorder.record(KeyBindings.getKeyActivateParCool(), keyOpenSettingsState);
        KeyRecorder.record(KeyBindings.getKeyFastRunning(), keyFastRunning);
        KeyRecorder.record(KeyBindings.getKeyDodge(), keyDodge);
        KeyRecorder.record(KeyBindings.getKeyBreakfall(), keyBreakfall);
    }

    private static void record(KeyMapping keyBinding, KeyState state) {
        state.pressed = keyBinding.m_90857_() && state.tickKeyDown == 0;
        boolean bl = state.doubleTapped = keyBinding.m_90857_() && 0 < state.tickNotKeyDown && state.tickNotKeyDown <= 2;
        if (keyBinding.m_90857_()) {
            ++state.tickKeyDown;
            state.tickNotKeyDown = 0;
        } else {
            state.tickKeyDown = 0;
            ++state.tickNotKeyDown;
        }
    }

    public static class KeyState {
        private boolean pressed = false;
        private boolean doubleTapped = false;
        private int tickKeyDown = 0;
        private int tickNotKeyDown = 0;

        public boolean isPressed() {
            return this.pressed;
        }

        public boolean isDoubleTapped() {
            return this.doubleTapped;
        }

        public int getTickKeyDown() {
            return this.tickKeyDown;
        }

        public int getTickNotKeyDown() {
            return this.tickNotKeyDown;
        }
    }
}

