/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.hud.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.hud.AbstractHUD;
import com.alrex.parcool.client.hud.Position;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;

@OnlyIn(value=Dist.CLIENT)
public class StaminaHUD
extends AbstractHUD {
    public static final ResourceLocation STAMINA = new ResourceLocation("parcool", "textures/gui/stamina_bar.png");
    private float shadowScale = 1.0f;

    public StaminaHUD(Position pos) {
        super(pos);
    }

    @Override
    public void render(ForgeIngameGui gui, PoseStack stack, float partialTicks, int width, int height) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_7500_()) {
            return;
        }
        Stamina stamina = Stamina.get((Player)player);
        Parkourability parkourability = Parkourability.get((Player)player);
        if (stamina == null || parkourability == null) {
            return;
        }
        if (((Boolean)ParCoolConfig.CONFIG_CLIENT.infiniteStamina.get()).booleanValue() && parkourability.getActionInfo().isStaminaInfinite()) {
            return;
        }
        int renderGage = (int)(new Date().getTime() / 500L % 3L);
        int boxWidth = 91;
        int boxHeight = 17;
        Tuple<Integer, Integer> pos = this.position.calculate(91, 17, width, height);
        float staminaScale = (float)stamina.getStamina() / (float)stamina.getMaxStamina();
        float dodgeCoolTimeScale = (float)(parkourability.getActionInfo().getDodgeCoolTick() - parkourability.getDodge().getCoolTime()) / (float)parkourability.getActionInfo().getDodgeCoolTick();
        if (staminaScale < 0.0f) {
            staminaScale = 0.0f;
        }
        if (staminaScale > 1.0f) {
            staminaScale = 1.0f;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)STAMINA);
        AbstractHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)0.0f, (int)92, (int)16, (int)128, (int)128);
        if (!stamina.isExhausted()) {
            AbstractHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)102.0f, (int)((int)Math.ceil(92.0f * dodgeCoolTimeScale)), (int)16, (int)128, (int)128);
            AbstractHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)85.0f, (int)(Math.round(16.0f + 69.0f * this.shadowScale) + 1), (int)12, (int)128, (int)128);
            AbstractHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)(17 * (renderGage + 1)), (int)(Math.round(16.0f + 69.0f * staminaScale) + 1), (int)12, (int)128, (int)128);
        } else {
            AbstractHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)68.0f, (int)(Math.round(16.0f + 69.0f * staminaScale) + 1), (int)16, (int)128, (int)128);
        }
        this.shadowScale = staminaScale - (staminaScale - this.shadowScale) / 1.1f;
    }
}

