/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui.widget;

import com.alrex.parcool.client.gui.widget.Widget;
import com.alrex.parcool.utilities.ColorUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;

public class ListView
extends Widget {
    private final int menuLineHeight;
    private List<String> items;
    private Consumer<Integer> listener;

    public ListView(int x, int y, int width, int height, List<String> items) {
        super(x, y, width, height);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.menuLineHeight = 9 + 1;
        this.listener = null;
        this.items = items;
    }

    public ListView(List<String> items) {
        super(0, 0, 0, 0);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.menuLineHeight = 9 + 1;
        this.listener = null;
        this.items = items;
    }

    @Override
    public void render(PoseStack stack, Font fontRenderer, int mouseX, int mouseY, float partial) {
        for (int i = 0; i < this.items.size(); ++i) {
            String item = this.items.get(i);
            fontRenderer.m_92883_(stack, item, (float)this.x, (float)(this.y + this.menuLineHeight * i), ColorUtil.getColorCodeFromARGB(0, 0, 0, 0));
        }
    }

    public void onClick(int type, double mouseX, double mouseY) {
        if (type == 0) {
            Window window = Minecraft.m_91087_().m_91268_();
            for (int i = 0; i < this.items.size(); ++i) {
                int itemY = this.y + this.menuLineHeight * i;
                if (!((double)itemY < mouseY) || !(mouseY < (double)(itemY + this.menuLineHeight)) || !((double)this.x < mouseX) || !(mouseX < (double)(this.x + this.width)) || this.listener == null) continue;
                this.listener.accept(i);
            }
        }
    }

    public void setListener(Consumer<Integer> listener) {
        this.listener = listener;
    }
}

