/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui.guidebook;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.client.gui.guidebook.Book;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.StringUtils;

public class BookDecoder {
    private static final String PATH = "/assets/parcool/book/parcool_guide_content_%s.txt";
    private static final String[] sequenceCode = new String[]{"{reset}", "{black}", "{white}", "{yellow}", "{blue}", "{green}", "{red}", "{purple}", "{obfuscate}", "{B}", "{-}", "{_}", "{I}"};
    private static final String[] escapedSequences = new String[]{"\u00a7r", "\u00a70", "\u00a7f", "\u00a7e", "\u00a79", "\u00a7a", "\u00a7c", "\u00a75", "\u00a7k", "\u00a7l", "\u00a7m", "\u00a7n", "\u00a7o"};
    private static BookDecoder instance = null;
    private final Map<String, Book> bookCache = new HashMap<String, Book>();

    public static BookDecoder getInstance() {
        if (instance == null) {
            instance = new BookDecoder();
        }
        return instance;
    }

    public Book getBook() {
        return this.getBook(Minecraft.m_91087_().m_91102_().m_118983_().getCode());
    }

    public Book getBook(String langCode) {
        Book book = this.bookCache.get(langCode);
        if (book != null) {
            return book;
        }
        book = this.loadBook(langCode);
        this.bookCache.put(langCode, book);
        return book;
    }

    private String decodeDecoration(String text) {
        return StringUtils.replaceEach((String)text, (String[])sequenceCode, (String[])escapedSequences);
    }

    private Book loadBook(String langCode) {
        InputStream stream = ParCool.class.getResourceAsStream(String.format(PATH, langCode));
        if (stream == null) {
            stream = ParCool.class.getResourceAsStream(String.format(PATH, "en_us"));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        ArrayList<Book.Page> pages = new ArrayList<Book.Page>();
        Iterator iterator = reader.lines().iterator();
        Pattern division = Pattern.compile("===+");
        block0: while (iterator.hasNext()) {
            String title = (String)iterator.next();
            iterator.next();
            ArrayList<String> content = new ArrayList<String>();
            while (true) {
                String line;
                if (division.matcher(line = (String)iterator.next()).matches()) {
                    pages.add(new Book.Page(this.decodeDecoration(title), content.stream().map(this::decodeDecoration).collect(Collectors.toList())));
                    continue block0;
                }
                content.add(line);
            }
        }
        return new Book(pages);
    }
}

