/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool;

import com.alrex.parcool.client.hud.Position;
import net.minecraftforge.common.ForgeConfigSpec;

public class ParCoolConfig {
    private static final ForgeConfigSpec.Builder C_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder S_BUILDER = new ForgeConfigSpec.Builder();
    public static final Client CONFIG_CLIENT = new Client(C_BUILDER);
    public static final Server CONFIG_SERVER = new Server(S_BUILDER);
    public static final ForgeConfigSpec CLIENT_SPEC = C_BUILDER.build();
    public static final ForgeConfigSpec SERVER_SPEC = S_BUILDER.build();

    public static class Client {
        public final ForgeConfigSpec.BooleanValue canCatLeap;
        public final ForgeConfigSpec.BooleanValue canCrawl;
        public final ForgeConfigSpec.BooleanValue canDodge;
        public final ForgeConfigSpec.BooleanValue canFastRunning;
        public final ForgeConfigSpec.BooleanValue canFrontDodgeByDoubleTap;
        public final ForgeConfigSpec.BooleanValue canClingToCliff;
        public final ForgeConfigSpec.BooleanValue canRoll;
        public final ForgeConfigSpec.BooleanValue canVault;
        public final ForgeConfigSpec.BooleanValue canWallJump;
        public final ForgeConfigSpec.BooleanValue canDive;
        public final ForgeConfigSpec.BooleanValue canFlipping;
        public final ForgeConfigSpec.BooleanValue canBreakfall;
        public final ForgeConfigSpec.BooleanValue canWallSlide;
        public final ForgeConfigSpec.BooleanValue canHorizontalWallRun;
        public final ForgeConfigSpec.BooleanValue infiniteStamina;
        public final ForgeConfigSpec.BooleanValue autoTurningWallJump;
        public final ForgeConfigSpec.BooleanValue disableWallJumpTowardWall;
        public final ForgeConfigSpec.BooleanValue disableCameraRolling;
        public final ForgeConfigSpec.BooleanValue disableCameraFlipping;
        public final ForgeConfigSpec.BooleanValue disableCrawlInAir;
        public final ForgeConfigSpec.BooleanValue enableRollWhenCreative;
        public final ForgeConfigSpec.BooleanValue disableDoubleTappingForDodge;
        public final ForgeConfigSpec.BooleanValue substituteSprintForFastRun;
        public final ForgeConfigSpec.BooleanValue replaceSprintWithFastRun;
        public final ForgeConfigSpec.DoubleValue fastRunningModifier;
        public final ForgeConfigSpec.BooleanValue parCoolActivation;
        public final ForgeConfigSpec.BooleanValue continueSprintWhenColliding;
        public final ForgeConfigSpec.BooleanValue hideStaminaHUD;
        public final ForgeConfigSpec.BooleanValue useLightHUD;
        public final ForgeConfigSpec.BooleanValue vaultNeedKeyPressed;
        public final ForgeConfigSpec.EnumValue<Position.Horizontal> alignHorizontalStaminaHUD;
        public final ForgeConfigSpec.EnumValue<Position.Vertical> alignVerticalStaminaHUD;
        public final ForgeConfigSpec.IntValue marginHorizontalStaminaHUD;
        public final ForgeConfigSpec.IntValue marginVerticalStaminaHUD;
        public final ForgeConfigSpec.IntValue offsetVerticalLightStaminaHUD;
        public final ForgeConfigSpec.IntValue staminaMax;
        public final ForgeConfigSpec.IntValue staminaConsumptionBreakfall;
        public final ForgeConfigSpec.IntValue staminaConsumptionCatLeap;
        public final ForgeConfigSpec.IntValue staminaConsumptionClingToCliff;
        public final ForgeConfigSpec.IntValue staminaConsumptionClimbUp;
        public final ForgeConfigSpec.IntValue staminaConsumptionDodge;
        public final ForgeConfigSpec.IntValue staminaConsumptionFastRun;
        public final ForgeConfigSpec.IntValue staminaConsumptionFlipping;
        public final ForgeConfigSpec.IntValue staminaConsumptionVault;
        public final ForgeConfigSpec.IntValue staminaConsumptionWallJump;
        public final ForgeConfigSpec.BooleanValue useHungerBarInsteadOfStamina;

        Client(ForgeConfigSpec.Builder builder) {
            builder.push("Possibility of Actions");
            this.canCatLeap = builder.define("canCatLeap", true);
            this.canCrawl = builder.define("canCrawl", true);
            this.canFrontDodgeByDoubleTap = builder.comment("Possibility to Frontward-Dodge By double tapping a button").define("canFrontDodgeByDoubleTapping", true);
            this.canDodge = builder.define("canDodge", true);
            this.canFastRunning = builder.define("canFastRunning", true);
            this.canClingToCliff = builder.define("canClingToCliff", true);
            this.canRoll = builder.define("canRoll", true);
            this.canVault = builder.define("canVault", true);
            this.canWallJump = builder.define("canWallJump", true);
            this.canDive = builder.define("canDive", true);
            this.canFlipping = builder.define("canFlipping", true);
            this.canBreakfall = builder.define("canBreakFall", true);
            this.canWallSlide = builder.define("canWallSlide", true);
            this.canHorizontalWallRun = builder.define("canHorizontalWallRun", true);
            builder.pop();
            builder.push("Modifier Values");
            this.fastRunningModifier = builder.comment("FastRun Speed Modifier").defineInRange("fastRunModifier", 3.0, 0.001, 4.5);
            builder.pop();
            builder.push("Stamina HUD Configuration");
            this.hideStaminaHUD = builder.comment("hide stamina HUD when Stamina is infinite").define("hideS_HUD", false);
            this.useLightHUD = builder.comment("use Light Stamina HUD").define("useLightHUD", false);
            this.alignHorizontalStaminaHUD = builder.comment("horizontal alignment").defineEnum("align_H_S_HUD", (Enum)Position.Horizontal.Right);
            this.alignVerticalStaminaHUD = builder.comment("vertical alignment").defineEnum("align_V_S_HUD", (Enum)Position.Vertical.Bottom);
            this.marginHorizontalStaminaHUD = builder.comment("horizontal margin").defineInRange("margin_H_S_HUD", 3, 0, 100);
            this.marginVerticalStaminaHUD = builder.comment("vertical margin").defineInRange("margin_V_S_HUD", 3, 0, 100);
            this.offsetVerticalLightStaminaHUD = builder.comment("vertical offset of light stamina HUD").defineInRange("offset_V_LS_HUD", 0, -50, 50);
            builder.pop();
            builder.push("Other Configuration");
            this.autoTurningWallJump = builder.comment("Auto turning forward when WallJump").define("autoTurningWallJump", false);
            this.disableWallJumpTowardWall = builder.comment("Disable WallJump toward a wall").define("disableWallJumpTowardWall", false);
            this.disableCameraRolling = builder.comment("Disable Roll rotation of camera").define("disableCameraRotationRolling", false);
            this.disableCameraFlipping = builder.comment("Disable Flipping rotation of camera").define("disableCameraRotationFlipping", false);
            this.disableDoubleTappingForDodge = builder.comment("Disable Double-Tapping For Dodge. Please Use Dodge Key instead").define("disableDoubleTapping", false);
            this.disableCrawlInAir = builder.comment("Disable Crawl in air (experimental)").define("disableCrawlInAir", true);
            this.enableRollWhenCreative = builder.comment("Enable Roll While player is in creative mode (experimental)").define("enableRollCreative", false);
            this.vaultNeedKeyPressed = builder.comment("Make Vault Need Vault Key Pressed").define("vaultNeedKeyPressed", false);
            this.replaceSprintWithFastRun = builder.comment("enable players to do actions needing Fast-Running by sprint").define("replaceSprintWithFastRun", true);
            this.substituteSprintForFastRun = builder.comment("Substitute a sprint of vanilla for the FastRunning").define("substituteSprint", false);
            this.continueSprintWhenColliding = builder.comment("Continue sprint when even player collides blocks").define("continueSprintWhenColliding", true);
            this.infiniteStamina = builder.comment("Infinite Stamina(this needs a permission from server, even if it is on single player's game)\nPlease check 'parcool-server.toml' in 'serverconfig' directory").define("infiniteStamina", false);
            builder.pop();
            builder.comment("Stamina Section may be affected by Server config").push("Stamina");
            this.useHungerBarInsteadOfStamina = builder.comment("ParCool consume hanger value instead of stamina").define("useHangerInstead", false);
            this.staminaMax = builder.defineInRange("MaxValueOfStamina", 2000, 300, 10000);
            builder.push("Consumption");
            this.staminaConsumptionBreakfall = builder.defineInRange("Breakfall", 100, 0, 10000);
            this.staminaConsumptionCatLeap = builder.defineInRange("CatLeap", 150, 0, 10000);
            this.staminaConsumptionClingToCliff = builder.defineInRange("ClingToCliff", 2, 0, 10000);
            this.staminaConsumptionClimbUp = builder.defineInRange("ClimbUp", 150, 0, 10000);
            this.staminaConsumptionDodge = builder.defineInRange("Dodge", 80, 0, 10000);
            this.staminaConsumptionFastRun = builder.defineInRange("FastRunning", 2, 0, 10000);
            this.staminaConsumptionFlipping = builder.defineInRange("Flipping", 80, 0, 10000);
            this.staminaConsumptionVault = builder.defineInRange("Vault", 50, 0, 10000);
            this.staminaConsumptionWallJump = builder.defineInRange("WallJump", 120, 0, 10000);
            builder.pop();
            builder.comment("About ParCool").push("ParCool");
            this.parCoolActivation = builder.comment("ParCool is Active").define("ParCool_Activation", true);
            builder.pop();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue allowInfiniteStamina;
        public final ForgeConfigSpec.BooleanValue allowCatLeap;
        public final ForgeConfigSpec.BooleanValue allowCrawl;
        public final ForgeConfigSpec.BooleanValue allowDodge;
        public final ForgeConfigSpec.BooleanValue allowFastRunning;
        public final ForgeConfigSpec.BooleanValue allowClingToCliff;
        public final ForgeConfigSpec.BooleanValue allowRoll;
        public final ForgeConfigSpec.BooleanValue allowVault;
        public final ForgeConfigSpec.BooleanValue allowWallJump;
        public final ForgeConfigSpec.BooleanValue allowBreakfall;
        public final ForgeConfigSpec.BooleanValue allowFlipping;
        public final ForgeConfigSpec.BooleanValue allowWallSlide;
        public final ForgeConfigSpec.BooleanValue allowHorizontalWallRun;
        public final ForgeConfigSpec.IntValue staminaMax;
        public final ForgeConfigSpec.IntValue staminaConsumptionBreakfall;
        public final ForgeConfigSpec.IntValue staminaConsumptionCatLeap;
        public final ForgeConfigSpec.IntValue staminaConsumptionClingToCliff;
        public final ForgeConfigSpec.IntValue staminaConsumptionClimbUp;
        public final ForgeConfigSpec.IntValue staminaConsumptionDodge;
        public final ForgeConfigSpec.IntValue staminaConsumptionFastRun;
        public final ForgeConfigSpec.IntValue staminaConsumptionFlipping;
        public final ForgeConfigSpec.IntValue staminaConsumptionVault;
        public final ForgeConfigSpec.IntValue staminaConsumptionWallJump;

        Server(ForgeConfigSpec.Builder builder) {
            builder.push("Action Permissions");
            this.allowCatLeap = builder.define("allowCatLeap", true);
            this.allowCrawl = builder.define("allowCrawl", true);
            this.allowDodge = builder.define("allowDodge", true);
            this.allowFastRunning = builder.define("allowFastRunning", true);
            this.allowClingToCliff = builder.define("allowClingToCliff", true);
            this.allowRoll = builder.define("allowRoll", true);
            this.allowVault = builder.define("allowVault", true);
            this.allowWallJump = builder.define("allowWallJump", true);
            this.allowBreakfall = builder.define("allowBreakfall", true);
            this.allowFlipping = builder.define("allowFlipping", true);
            this.allowWallSlide = builder.define("allowWallSlide", true);
            this.allowHorizontalWallRun = builder.define("allowHorizontalWallRun", true);
            builder.pop();
            builder.push("Stamina");
            this.staminaMax = builder.defineInRange("Max Value of Stamina", 2000, 300, 10000);
            this.allowInfiniteStamina = builder.comment("allow Infinite Stamina").define("infiniteStamina", true);
            builder.push("Consumption");
            this.staminaConsumptionBreakfall = builder.defineInRange("Breakfall", 100, 0, 10000);
            this.staminaConsumptionCatLeap = builder.defineInRange("CatLeap", 150, 0, 10000);
            this.staminaConsumptionClingToCliff = builder.defineInRange("ClingToCliff", 2, 0, 10000);
            this.staminaConsumptionClimbUp = builder.defineInRange("ClimbUp", 150, 0, 10000);
            this.staminaConsumptionDodge = builder.defineInRange("Dodge", 80, 0, 10000);
            this.staminaConsumptionFastRun = builder.defineInRange("FastRunning", 2, 0, 10000);
            this.staminaConsumptionFlipping = builder.defineInRange("Flipping", 80, 0, 10000);
            this.staminaConsumptionVault = builder.defineInRange("Vault", 50, 0, 10000);
            this.staminaConsumptionWallJump = builder.defineInRange("WallJump", 120, 0, 10000);
            builder.pop();
        }
    }
}

