/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.client;

import cofh.core.CoFHCore;
import cofh.core.util.ProxyUtils;
import cofh.lib.network.packet.IPacketClient;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.helpers.StringHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class IndexedChatPacket
extends PacketBase
implements IPacketClient {
    protected int index;
    protected String message;

    public IndexedChatPacket() {
        super(16, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleClient() {
        ProxyUtils.addIndexedChatMessage((Component)StringHelper.fromJSON(this.message), this.index);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.index);
        buf.m_130070_(this.message);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.index = buf.readInt();
        this.message = buf.m_130136_(Short.MAX_VALUE);
    }

    public static void sendToClient(Component chat, int index, ServerPlayer player) {
        IndexedChatPacket packet = new IndexedChatPacket();
        packet.index = index;
        packet.message = StringHelper.toJSON(chat);
        packet.sendToPlayer(player);
    }
}

