/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.data;

import cofh.core.data.CoreBlockStateProvider;
import cofh.core.data.CoreItemModelProvider;
import cofh.core.data.CoreLootTableProvider;
import cofh.core.data.CoreRecipeProvider;
import cofh.core.data.CoreTagsProvider;
import cofh.lib.loot.TileNBTSync;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="cofh_core")
public class CoreDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        TileNBTSync.setup();
        if (event.includeServer()) {
            CoreDataGen.registerServerProviders(event);
        }
        if (event.includeClient()) {
            CoreDataGen.registerClientProviders(event);
        }
    }

    private static void registerServerProviders(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper exFileHelper = event.getExistingFileHelper();
        CoreTagsProvider.Block blockTags = new CoreTagsProvider.Block(gen, exFileHelper);
        gen.m_123914_((DataProvider)blockTags);
        gen.m_123914_((DataProvider)new CoreTagsProvider.Item(gen, blockTags, exFileHelper));
        gen.m_123914_((DataProvider)new CoreTagsProvider.Fluid(gen, exFileHelper));
        gen.m_123914_((DataProvider)new CoreLootTableProvider(gen));
        gen.m_123914_((DataProvider)new CoreRecipeProvider(gen));
    }

    private static void registerClientProviders(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper exFileHelper = event.getExistingFileHelper();
        gen.m_123914_((DataProvider)new CoreBlockStateProvider(gen, exFileHelper));
        gen.m_123914_((DataProvider)new CoreItemModelProvider(gen, exFileHelper));
    }
}

