/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block.nyi;

import cofh.lib.util.Constants;
import cofh.lib.util.helpers.MathHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class SpecialAirBlock
extends AirBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)3);

    public SpecialAirBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
        builder.m_61104_(new Property[]{AGE});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (blockIn == this && this.shouldDisperse((LevelReader)worldIn, pos, 3)) {
            this.turnIntoAir(state, worldIn, pos);
        }
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        this.m_7458_(state, worldIn, pos, random);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if ((rand.nextInt(4) == 0 || this.shouldDisperse((LevelReader)worldIn, pos, 4)) && this.slightlyDisperse(state, (Level)worldIn, pos)) {
            BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
            for (Direction direction : Constants.DIRECTIONS) {
                blockpos$mutable.m_122159_((Vec3i)pos, direction);
                BlockState blockstate = worldIn.m_8055_((BlockPos)blockpos$mutable);
                if (!blockstate.m_60713_((Block)this) || this.slightlyDisperse(blockstate, (Level)worldIn, (BlockPos)blockpos$mutable)) continue;
                worldIn.m_186460_((BlockPos)blockpos$mutable, (Block)this, Mth.m_14072_((Random)rand, (int)20, (int)40));
            }
        } else {
            worldIn.m_186460_(pos, (Block)this, MathHelper.nextInt(rand, 20, 40));
        }
    }

    protected void turnIntoAir(BlockState state, Level worldIn, BlockPos pos) {
        BlockState newState = worldIn.m_6425_(pos).m_76188_();
        worldIn.m_46597_(pos, newState);
        worldIn.m_46586_(pos, newState.m_60734_(), pos);
    }

    protected boolean shouldDisperse(LevelReader worldIn, BlockPos pos, int neighborsRequired) {
        int i = 0;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Constants.DIRECTIONS) {
            blockpos$mutable.m_122159_((Vec3i)pos, direction);
            if (!worldIn.m_8055_((BlockPos)blockpos$mutable).m_60713_((Block)this) || ++i < neighborsRequired) continue;
            return false;
        }
        return true;
    }

    protected boolean slightlyDisperse(BlockState state, Level worldIn, BlockPos pos) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 1) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            return false;
        }
        this.turnIntoAir(state, worldIn, pos);
        return true;
    }
}

