/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.coldsrunes.items;

import com.coldspell.coldsrunes.ColdsRunes;
import com.coldspell.coldsrunes.init.ModSounds;
import com.coldspell.coldsrunes.util.ConfigurationHandler;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RuneItem
extends Item {
    private static final Random random = new Random();

    public RuneItem() {
        super(new Item.Properties().m_41491_(ColdsRunes.TAB).m_41487_(1));
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> componentList, @NotNull TooltipFlag tooltipFlag) {
        CompoundTag tag = itemStack.m_41784_();
        if (tag.m_128471_("locked")) {
            if (!((Boolean)ConfigurationHandler.SETTINGS.framesOnly.get()).booleanValue()) {
                componentList.add((Component)new TranslatableComponent("runedisc.coldsrunes.use").m_130940_(ChatFormatting.AQUA));
            } else {
                componentList.add((Component)new TranslatableComponent("runedisc.coldsrunes.frameuse").m_130940_(ChatFormatting.AQUA));
            }
            if ((Integer)ConfigurationHandler.SETTINGS.xpCost.get() > 0) {
                componentList.add((Component)new TranslatableComponent("runedisc.coldsrunes.xpcost").m_130940_(ChatFormatting.BLUE));
                componentList.add((Component)new TranslatableComponent(((Integer)ConfigurationHandler.SETTINGS.xpCost.get()).toString()).m_130940_(ChatFormatting.DARK_BLUE));
            }
            if ((Integer)ConfigurationHandler.SETTINGS.runeRange.get() > 0) {
                componentList.add((Component)new TranslatableComponent("runedisc.coldsrunes.range").m_130940_(ChatFormatting.GREEN));
                componentList.add((Component)new TranslatableComponent(((Integer)ConfigurationHandler.SETTINGS.runeRange.get()).toString()).m_130940_(ChatFormatting.DARK_GREEN));
            }
            if (!((Boolean)ConfigurationHandler.SETTINGS.permaLocked.get()).booleanValue()) {
                componentList.add((Component)new TranslatableComponent("runedisc.coldsrunes.crouchlock1").m_130940_(ChatFormatting.GOLD));
            }
        } else if (((Boolean)ConfigurationHandler.SETTINGS.permaLocked.get()).booleanValue()) {
            componentList.add((Component)new TranslatableComponent("runedisc.coldsrunes.crouchlock2").m_130940_(ChatFormatting.GOLD));
        } else {
            componentList.add((Component)new TranslatableComponent("runedisc.coldsrunes.crouchlock1").m_130940_(ChatFormatting.GOLD));
        }
        if (((Boolean)ConfigurationHandler.SETTINGS.soulbound.get()).booleanValue()) {
            if (((Boolean)ConfigurationHandler.SETTINGS.soulboundlockedonly.get()).booleanValue()) {
                if (this.isLocked(tag)) {
                    componentList.add((Component)new TranslatableComponent("runedisc.coldsrunes.soulbound").m_130940_(ChatFormatting.GRAY));
                }
            } else {
                componentList.add((Component)new TranslatableComponent("runedisc.coldsrunes.soulbound").m_130940_(ChatFormatting.GRAY));
            }
        }
        super.m_7373_(itemStack, level, componentList, tooltipFlag);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.f_46443_) {
            ItemStack itemStack = player.m_21205_();
            CompoundTag tag = itemStack.m_41784_();
            if (this.isLocked(tag)) {
                if (!((Boolean)ConfigurationHandler.SETTINGS.framesOnly.get()).booleanValue()) {
                    if (((Boolean)ConfigurationHandler.SETTINGS.permaLocked.get()).booleanValue()) {
                        this.teleportPlayer(itemStack, player);
                    } else if (!player.m_6047_()) {
                        this.teleportPlayer(itemStack, player);
                    } else {
                        this.lockLocation(itemStack, player);
                    }
                }
            } else if (player.m_6047_()) {
                this.lockLocation(itemStack, player);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    public boolean m_7579_(ItemStack itemStack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        CompoundTag tag = itemStack.m_41784_();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (!player.f_19853_.f_46443_ && ((Boolean)ConfigurationHandler.SETTINGS.hitTeleport.get()).booleanValue() && this.isLocked(tag) && this.isInRange(player, tag) && (Integer)ConfigurationHandler.SETTINGS.xpCost.get() > player.f_36079_ && !(target instanceof EnderDragon) && !(target instanceof WitherBoss)) {
                this.teleportLivingEntity(tag, player, target);
            }
        }
        return super.m_7579_(itemStack, target, attacker);
    }

    public void teleportPlayer(ItemStack itemstack, Player player) {
        CompoundTag tag = itemstack.m_41784_();
        Level level = player.f_19853_;
        if (player.f_36079_ >= (Integer)ConfigurationHandler.SETTINGS.xpCost.get()) {
            if (this.isInRange(player, tag)) {
                if (level instanceof ServerLevel && !player.m_20159_() && !player.m_20160_()) {
                    ServerLevel dimension = Objects.requireNonNull(level.m_142572_()).m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dimension"))));
                    if (((Boolean)ConfigurationHandler.SETTINGS.hopDimensions.get()).booleanValue() && player.m_6072_()) {
                        assert (dimension != null);
                        ((ServerPlayer)player).m_8999_(dimension, this.getLockedX(tag) + 0.5, this.getLockedY(tag), this.getLockedZ(tag) + 0.5, this.getLockedYRotation(tag), this.getLockedXRotation(tag));
                        this.teleportSound(player, player.m_142538_());
                        this.applyRuneCosts(player, itemstack);
                    } else if (level == dimension) {
                        ((ServerPlayer)player).m_8999_((ServerLevel)level, this.getLockedX(tag) + 0.5, this.getLockedY(tag), this.getLockedZ(tag) + 0.5, this.getLockedYRotation(tag), this.getLockedXRotation(tag));
                        this.teleportSound(player, player.m_142538_());
                        this.applyRuneCosts(player, itemstack);
                    } else {
                        player.m_6352_((Component)new TranslatableComponent("runedisc.coldsrunes.wrongdimension").m_130940_(ChatFormatting.GRAY), player.m_142081_());
                        this.spark(player);
                    }
                }
            } else {
                player.m_6352_((Component)new TranslatableComponent("runedisc.coldsrunes.norange").m_130940_(ChatFormatting.GRAY), player.m_142081_());
                this.spark(player);
            }
        } else {
            player.m_6352_((Component)new TranslatableComponent("runedisc.coldsrunes.needxp").m_130940_(ChatFormatting.GRAY), player.m_142081_());
            this.spark(player);
        }
    }

    private void teleportLivingEntity(CompoundTag tag, Player player, LivingEntity livingEntity) {
        Level level = player.f_19853_;
        ItemStack itemStack = player.m_21205_();
        ServerLevel dimension = Objects.requireNonNull(level.m_142572_()).m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dimension"))));
        if (!level.f_46443_ && level.m_46472_() == Objects.requireNonNull(dimension).m_46472_() && this.isInRange(player, tag)) {
            livingEntity.m_6021_(this.getLockedX(tag) + 0.5, this.getLockedY(tag), this.getLockedZ(tag) + 0.5);
            this.teleportSound(player, player.m_142538_());
            this.applyRuneCosts(player, itemStack);
        } else {
            this.spark(player);
        }
    }

    private void lockLocation(ItemStack itemStack, Player player) {
        CompoundTag tag = itemStack.m_41784_();
        BlockPos pos = player.m_142538_();
        if (player.f_36079_ >= (Integer)ConfigurationHandler.SETTINGS.lockCost.get()) {
            tag.m_128379_("locked", true);
            tag.m_128347_("x", (double)pos.m_123341_());
            tag.m_128347_("y", (double)(pos.m_123342_() + 1));
            tag.m_128347_("z", (double)pos.m_123343_());
            tag.m_128350_("xrot", player.m_146909_());
            tag.m_128350_("yrot", player.m_146908_());
            tag.m_128359_("dimension", player.f_19853_.m_46472_().m_135782_().toString());
            this.lockSound(player, player.m_142538_());
            player.m_6756_(-((Integer)ConfigurationHandler.SETTINGS.lockCost.get()).intValue());
        } else {
            player.m_6352_((Component)new TranslatableComponent("runedisc.coldsrunes.needxp").m_130940_(ChatFormatting.GRAY), player.m_142081_());
            this.spark(player);
        }
    }

    public boolean isLocked(CompoundTag tag) {
        return tag.m_128471_("locked");
    }

    public double getLockedX(CompoundTag tag) {
        return tag.m_128451_("x");
    }

    public double getLockedY(CompoundTag tag) {
        return tag.m_128451_("y");
    }

    public double getLockedZ(CompoundTag tag) {
        return tag.m_128451_("z");
    }

    public float getLockedXRotation(CompoundTag tag) {
        return tag.m_128451_("xrot");
    }

    public float getLockedYRotation(CompoundTag tag) {
        return tag.m_128451_("yrot");
    }

    public boolean isInRange(Player player, CompoundTag tag) {
        if ((Integer)ConfigurationHandler.SETTINGS.runeRange.get() > 0) {
            return player.m_142538_().m_123331_(new Vec3i(this.getLockedX(tag), this.getLockedY(tag), this.getLockedZ(tag))) <= (double)((Integer)ConfigurationHandler.SETTINGS.runeRange.get() * (Integer)ConfigurationHandler.SETTINGS.runeRange.get());
        }
        return true;
    }

    public void applyRuneCosts(Player player, ItemStack itemStack) {
        if (!player.m_150110_().f_35937_) {
            if ((Integer)ConfigurationHandler.SETTINGS.xpCost.get() > 0) {
                player.m_6756_(-((Integer)ConfigurationHandler.SETTINGS.xpCost.get()).intValue());
            }
            player.m_36335_().m_41524_(itemStack.m_41720_(), (Integer)ConfigurationHandler.SETTINGS.runeCD.get() * 20);
        }
    }

    public void spark(Player player) {
        Level level = player.f_19853_;
        BlockPos pos = player.m_142538_();
        this.failSound(player, player.m_142538_());
        level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(random.nextFloat() / 2.0f), 5.0E-5, (double)(random.nextFloat() / 2.0f));
        level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(random.nextFloat() / 2.0f), 5.0E-5, (double)(random.nextFloat() / 2.0f));
        level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(random.nextFloat() / 2.0f), 5.0E-5, (double)(random.nextFloat() / 2.0f));
        level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(random.nextFloat() / 2.0f), 5.0E-5, (double)(random.nextFloat() / 2.0f));
        level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(random.nextFloat() / 2.0f), 5.0E-5, (double)(random.nextFloat() / 2.0f));
    }

    public void teleportSound(Player player, BlockPos pos) {
        player.f_19853_.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11852_, player.m_5720_(), 1.5f, 1.0f);
    }

    private void failSound(Player player, BlockPos pos) {
        player.f_19853_.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)ModSounds.FIZZLE.get(), player.m_5720_(), 1.0f, 1.0f);
    }

    private void lockSound(Player player, BlockPos pos) {
        player.f_19853_.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12275_, player.m_5720_(), 1.5f, 1.0f);
    }

    public boolean m_5812_(ItemStack itemStack) {
        return this.isLocked(itemStack.m_41784_());
    }

    public boolean m_41475_() {
        return (Boolean)ConfigurationHandler.SETTINGS.fireproof.get();
    }
}

