/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.coldsrunes.events;

import com.coldspell.coldsrunes.init.ModItems;
import com.coldspell.coldsrunes.init.ModParticleTypes;
import com.coldspell.coldsrunes.items.DeathRuneItem;
import com.coldspell.coldsrunes.items.RuneItem;
import com.coldspell.coldsrunes.util.ConfigurationHandler;
import com.coldspell.coldsrunes.util.SoulboundHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="coldsrunes")
public class Events {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void retrievalEvent(LivingDropsEvent event) {
        if (event.getEntity() instanceof Player) {
            SoulboundHandler.getOrCreateSoulboundHandler((Player)event.getEntityLiving()).retainDrops(event.getDrops());
        }
    }

    @SubscribeEvent
    public static void itemTransferEvent(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            Player oldPlayer = event.getOriginal();
            if (SoulboundHandler.hasStoredDrops(oldPlayer)) {
                SoulboundHandler.getOrCreateSoulboundHandler(oldPlayer).transferItems(event.getPlayer());
            } else if (SoulboundHandler.hasStoredDrops(event.getPlayer())) {
                SoulboundHandler.getOrCreateSoulboundHandler(event.getPlayer()).transferItems(event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    public static void itemframeEvent(TickEvent.PlayerTickEvent event) {
        Item runeItem;
        Item item;
        ItemStack itemStack;
        Player player = event.player;
        BlockPos pos = event.player.m_142538_();
        Level level = player.f_19853_;
        if (!level.f_46443_ && ((Boolean)ConfigurationHandler.SETTINGS.frameTeleport.get()).booleanValue()) {
            for (ItemFrame itemFrame : level.m_45976_(ItemFrame.class, new AABB(pos))) {
                DeathRuneItem deathRuneItem;
                itemStack = itemFrame.m_31822_();
                item = itemStack.m_41720_();
                if (item instanceof RuneItem && (runeItem = (RuneItem)item).isLocked(itemStack.m_41784_()) && itemFrame.m_6350_() == Direction.UP) {
                    runeItem.teleportPlayer(itemStack, player);
                }
                if (!((item = itemStack.m_41720_()) instanceof DeathRuneItem) || !(deathRuneItem = (DeathRuneItem)item).isLocked(itemStack.m_41784_()) || itemFrame.m_6350_() != Direction.UP) continue;
                deathRuneItem.teleportPlayer(itemStack, player);
            }
        }
        if (level.f_46443_ && ((Boolean)ConfigurationHandler.SETTINGS.frameTeleport.get()).booleanValue()) {
            for (ItemFrame itemFrame : level.m_45976_(ItemFrame.class, new AABB(pos).m_82400_(20.0))) {
                itemStack = itemFrame.m_31822_();
                item = itemStack.m_41720_();
                if (item instanceof RuneItem && (runeItem = (RuneItem)item).isLocked(itemStack.m_41784_()) && itemFrame.m_6350_() == Direction.UP) {
                    SimpleParticleType particleType = ModParticleTypes.returnRuneParticle(runeItem);
                    if (particleType != null) {
                        level.m_7106_((ParticleOptions)particleType, itemFrame.m_20208_(0.3), itemFrame.m_20187_() + 0.5, itemFrame.m_20262_(0.3), (player.m_21187_().nextDouble() - 0.5) * 1.3, -player.m_21187_().nextDouble(), (player.m_21187_().nextDouble() - 0.5) * 1.3);
                    }
                    if (((Boolean)ConfigurationHandler.SETTINGS.frameInvis.get()).booleanValue()) {
                        itemFrame.m_6842_(true);
                    }
                }
                if (!((item = itemStack.m_41720_()) instanceof DeathRuneItem) || !(runeItem = (DeathRuneItem)item).isLocked(itemStack.m_41784_()) || itemFrame.m_6350_() != Direction.UP) continue;
                if (player.m_21187_().nextInt(6) == 0) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, itemFrame.m_20208_(0.5), itemFrame.m_20187_() + 0.5, itemFrame.m_20262_(0.5), 0.0, 0.0, 0.0);
                }
                if (!((Boolean)ConfigurationHandler.SETTINGS.frameInvis.get()).booleanValue()) continue;
                itemFrame.m_6842_(true);
            }
        }
    }

    @SubscribeEvent
    public static void deathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (((Boolean)ConfigurationHandler.SETTINGS.deathRune.get()).booleanValue()) {
                ItemStack rune = new ItemStack((ItemLike)ModItems.DEATH_RUNE.get());
                DeathRuneItem.lockLocation(rune, player);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)rune);
            }
        }
    }
}

