/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.network;

import com.minecraftserverzone.weaponmaster.setup.capabilities.PlayerStatsProvider;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketSlotDataForAll {
    private int slotNum;
    private UUID uuid;

    public PacketSlotDataForAll(FriendlyByteBuf buf) {
        this.slotNum = buf.readInt();
        this.uuid = buf.m_130259_();
    }

    public PacketSlotDataForAll(int slot, UUID uuid) {
        this.slotNum = slot;
        this.uuid = uuid;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.slotNum);
        buf.m_130077_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.get().setPacketHandled(true);
    }

    public void playerChanged() {
        for (Player sp : Minecraft.m_91087_().f_91073_.m_6907_()) {
            if (!sp.m_142081_().equals(this.uuid)) continue;
            sp.getCapability(PlayerStatsProvider.PLAYER_STATS_CAPABILITY).ifPresent(h -> h.setSelectedSlot(this.slotNum));
        }
    }
}

