/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.network;

import com.minecraftserverzone.weaponmaster.setup.capabilities.PlayerStatsProvider;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketPositionAndRotationDataForAll {
    private int[] positions;
    private int[] rotations;
    private String attachment;
    private String mover;
    private UUID uuid;

    public PacketPositionAndRotationDataForAll(FriendlyByteBuf buf) {
        this.positions = buf.m_130100_();
        this.rotations = buf.m_130100_();
        this.attachment = buf.m_130277_();
        this.mover = buf.m_130277_();
        this.uuid = buf.m_130259_();
    }

    public PacketPositionAndRotationDataForAll(int[] pos, int[] rot, String attachment, String mover, UUID uuid) {
        this.positions = pos;
        this.rotations = rot;
        this.attachment = attachment;
        this.mover = mover;
        this.uuid = uuid;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130089_(this.positions);
        buf.m_130089_(this.rotations);
        buf.m_130070_(this.attachment);
        buf.m_130070_(this.mover);
        buf.m_130077_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.get().setPacketHandled(true);
    }

    public void playerChanged() {
        for (Player sp : Minecraft.m_91087_().f_91073_.m_6907_()) {
            if (!sp.m_142081_().equals(this.uuid)) continue;
            sp.getCapability(PlayerStatsProvider.PLAYER_STATS_CAPABILITY).ifPresent(h -> {
                h.setHotbarSlot1Position(new int[]{this.positions[0], this.positions[1], this.positions[2]});
                h.setHotbarSlot2Position(new int[]{this.positions[3], this.positions[4], this.positions[5]});
                h.setHotbarSlot3Position(new int[]{this.positions[6], this.positions[7], this.positions[8]});
                h.setHotbarSlot4Position(new int[]{this.positions[9], this.positions[10], this.positions[11]});
                h.setHotbarSlot5Position(new int[]{this.positions[12], this.positions[13], this.positions[14]});
                h.setHotbarSlot6Position(new int[]{this.positions[15], this.positions[16], this.positions[17]});
                h.setHotbarSlot7Position(new int[]{this.positions[18], this.positions[19], this.positions[20]});
                h.setHotbarSlot8Position(new int[]{this.positions[21], this.positions[22], this.positions[23]});
                h.setHotbarSlot9Position(new int[]{this.positions[24], this.positions[25], this.positions[26]});
                h.setHotbarSlotShieldPosition(new int[]{this.positions[27], this.positions[28], this.positions[29]});
                h.setHotbarSlotBannerPosition(new int[]{this.positions[30], this.positions[31], this.positions[32]});
                h.setHotbarSlot1Rotation(new int[]{this.rotations[0], this.rotations[1], this.rotations[2]});
                h.setHotbarSlot2Rotation(new int[]{this.rotations[3], this.rotations[4], this.rotations[5]});
                h.setHotbarSlot3Rotation(new int[]{this.rotations[6], this.rotations[7], this.rotations[8]});
                h.setHotbarSlot4Rotation(new int[]{this.rotations[9], this.rotations[10], this.rotations[11]});
                h.setHotbarSlot5Rotation(new int[]{this.rotations[12], this.rotations[13], this.rotations[14]});
                h.setHotbarSlot6Rotation(new int[]{this.rotations[15], this.rotations[16], this.rotations[17]});
                h.setHotbarSlot7Rotation(new int[]{this.rotations[18], this.rotations[19], this.rotations[20]});
                h.setHotbarSlot8Rotation(new int[]{this.rotations[21], this.rotations[22], this.rotations[23]});
                h.setHotbarSlot9Rotation(new int[]{this.rotations[24], this.rotations[25], this.rotations[26]});
                h.setHotbarSlotShieldRotation(new int[]{this.rotations[27], this.rotations[28], this.rotations[29]});
                h.setHotbarSlotBannerRotation(new int[]{this.rotations[30], this.rotations[31], this.rotations[32]});
                h.setSlotAttachments(this.attachment);
                h.setMover(this.mover);
            });
        }
    }
}

