/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.network;

import com.minecraftserverzone.weaponmaster.setup.capabilities.PlayerStatsProvider;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketBLWLDataForAll {
    private String blacklist;
    private String whitelist;
    private UUID uuid;

    public PacketBLWLDataForAll(FriendlyByteBuf buf) {
        this.blacklist = buf.m_130277_();
        this.whitelist = buf.m_130277_();
        this.uuid = buf.m_130259_();
    }

    public PacketBLWLDataForAll(String bl, String wl, UUID uuid) {
        this.blacklist = bl;
        this.whitelist = wl;
        this.uuid = uuid;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.blacklist);
        buf.m_130070_(this.whitelist);
        buf.m_130077_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.get().setPacketHandled(true);
    }

    public void playerChanged() {
        for (Player sp : Minecraft.m_91087_().f_91073_.m_6907_()) {
            if (!sp.m_142081_().equals(this.uuid)) continue;
            sp.getCapability(PlayerStatsProvider.PLAYER_STATS_CAPABILITY).ifPresent(h -> {
                h.setBlacklist(this.blacklist);
                h.setWhitelist(this.whitelist);
            });
        }
    }
}

