/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.configs;

import net.minecraftforge.common.ForgeConfigSpec;

public final class CommonConfig {
    public final ForgeConfigSpec.BooleanValue[] TOGGLE_SLOT_MODEL = new ForgeConfigSpec.BooleanValue[11];
    public final ForgeConfigSpec.BooleanValue CAN_HIDE_ITEMS;
    public final ForgeConfigSpec.BooleanValue CAN_CHANGE_POS_AND_ROT;
    public final ForgeConfigSpec.BooleanValue CAN_CHANGE_ATTACHMENT;
    public final ForgeConfigSpec.BooleanValue FORCE_WHITELIST;
    public final ForgeConfigSpec.BooleanValue FORCE_BLACKLIST;
    public final ForgeConfigSpec.IntValue[] positions = new ForgeConfigSpec.IntValue[33];
    public final ForgeConfigSpec.IntValue[] rotations = new ForgeConfigSpec.IntValue[33];
    public final ForgeConfigSpec.ConfigValue<String> slot_attachment;
    public final ForgeConfigSpec.ConfigValue<String> slotMover;
    public final ForgeConfigSpec.ConfigValue<String> blacklist;
    public final ForgeConfigSpec.ConfigValue<String> whitelist;

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("model_options");
        this.TOGGLE_SLOT_MODEL[0] = builder.comment("Slot 1").translation("weaponmaster.config.toggle1").define("s1", true);
        this.TOGGLE_SLOT_MODEL[1] = builder.comment("Slot 2").translation("weaponmaster.config.toggle2").define("s2", true);
        this.TOGGLE_SLOT_MODEL[2] = builder.comment("Slot 3").translation("weaponmaster.config.toggle3").define("s3", true);
        this.TOGGLE_SLOT_MODEL[3] = builder.comment("Slot 4").translation("weaponmaster.config.toggle4").define("s4", true);
        this.TOGGLE_SLOT_MODEL[4] = builder.comment("Slot 5").translation("weaponmaster.config.toggle5").define("s5", true);
        this.TOGGLE_SLOT_MODEL[5] = builder.comment("Slot 6").translation("weaponmaster.config.toggle6").define("s6", true);
        this.TOGGLE_SLOT_MODEL[6] = builder.comment("Slot 7").translation("weaponmaster.config.toggle7").define("s7", true);
        this.TOGGLE_SLOT_MODEL[7] = builder.comment("Slot 8").translation("weaponmaster.config.toggle8").define("s8", true);
        this.TOGGLE_SLOT_MODEL[8] = builder.comment("Slot 9").translation("weaponmaster.config.toggle9").define("s9", true);
        this.TOGGLE_SLOT_MODEL[9] = builder.comment("Shield").translation("weaponmaster.config.toggle_shield").define("shield", true);
        this.TOGGLE_SLOT_MODEL[10] = builder.comment("Banner").translation("weaponmaster.config.toggle_banner").define("banner", true);
        this.CAN_HIDE_ITEMS = builder.comment("Players can hide items").define("canhideitems", true);
        this.CAN_CHANGE_POS_AND_ROT = builder.comment("Players can change the position and rotation of the displayed items").define("can_change_pos_and_rot", true);
        this.CAN_CHANGE_ATTACHMENT = builder.comment("Players can change the attachment of the slots").define("can_change_attachment", true);
        this.slot_attachment = builder.comment("Body part attachment to a slot").define("attachment", (Object)"1-body,2-body,3-rleg,4-lleg,5-rleg,6-lleg,7-body,8-body,9-rleg,shield-body,banner-head");
        this.slotMover = builder.comment("Which active slot and equipment should move the item model away").define("slot_mover", (Object)"none,chest;z;+_none,chest,1;z;+_none,legs;x;-_none,legs;x;+_none,legs,3;x;-_none,legs,4;x;+_none,chest,legs,1;z;+_none,shield;z;+_none,legs,3,5;x;-_none;z;-_none;z;-");
        this.whitelist = builder.comment("Whitelists item that are normally not visible").define("whitelist", (Object)"empty,totem_of_undying");
        this.blacklist = builder.comment("Blacklists item that are normally visible").define("blacklist", (Object)"empty");
        this.FORCE_BLACKLIST = builder.comment("Force server blacklist to players").define("serverblacklist", false);
        this.FORCE_WHITELIST = builder.comment("Force server whitelist to players").define("serverwhitelist", false);
        this.initPositionsRotations(builder, this.positions, this.rotations, 0, 0, 0, 0, 0, 0, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, 1, 35, 35, 0, 0, 0, 90);
        this.initPositionsRotations(builder, this.positions, this.rotations, 2, 1, -20, 12, 0, -90, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, 3, 31, -20, 12, 0, -90, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, 4, 1, -24, 0, 0, -90, -30);
        this.initPositionsRotations(builder, this.positions, this.rotations, 5, 31, -24, 0, 0, -90, -30);
        this.initPositionsRotations(builder, this.positions, this.rotations, 6, -13, 34, -1, 0, 0, -35);
        this.initPositionsRotations(builder, this.positions, this.rotations, 7, 25, 20, 12, 0, 0, 45);
        this.initPositionsRotations(builder, this.positions, this.rotations, 8, 1, -14, 20, 0, -90, 20);
        this.initPositionsRotations(builder, this.positions, this.rotations, 9, 0, 0, 0, 0, 0, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, 10, 0, 0, 0, 0, 0, 0);
        builder.pop();
    }

    public void initPositionsRotations(ForgeConfigSpec.Builder builder, ForgeConfigSpec.IntValue[] pos, ForgeConfigSpec.IntValue[] rot, int i, int xpos, int ypos, int zpos, int xrot, int yrot, int zrot) {
        builder.push("positions_rotations").comment("Position and rotation settings");
        pos[i * 3] = builder.comment("x position" + String.valueOf(i * 3)).defineInRange("x_position" + String.valueOf(i * 3), xpos, Integer.MIN_VALUE, Integer.MAX_VALUE);
        pos[i * 3 + 1] = builder.comment("y position" + String.valueOf(i * 3 + 1)).defineInRange("y_position" + String.valueOf(i * 3 + 1), ypos, Integer.MIN_VALUE, Integer.MAX_VALUE);
        pos[i * 3 + 2] = builder.comment("z position" + String.valueOf(i * 3 + 2)).defineInRange("z_position" + String.valueOf(i * 3 + 2), zpos, Integer.MIN_VALUE, Integer.MAX_VALUE);
        rot[i * 3] = builder.comment("x rotation" + String.valueOf(i * 3)).defineInRange("x_rotation" + String.valueOf(i * 3), xrot, Integer.MIN_VALUE, Integer.MAX_VALUE);
        rot[i * 3 + 1] = builder.comment("y rotation" + String.valueOf(i * 3 + 1)).defineInRange("y_rotation" + String.valueOf(i * 3 + 1), yrot, Integer.MIN_VALUE, Integer.MAX_VALUE);
        rot[i * 3 + 2] = builder.comment("z rotation" + String.valueOf(i * 3 + 2)).defineInRange("z_rotationn" + String.valueOf(i * 3 + 2), zrot, Integer.MIN_VALUE, Integer.MAX_VALUE);
        builder.pop();
    }
}

