/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.utils;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.gory_moon.player_mobs.Configs;

public class ItemManager {
    public static final ItemManager INSTANCE = new ItemManager();
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<WeightedEntry.Wrapper<ResourceLocation>> weightedMainItems = new CopyOnWriteArrayList<WeightedEntry.Wrapper<ResourceLocation>>();
    private final List<WeightedEntry.Wrapper<ResourceLocation>> weightedOffItems = new CopyOnWriteArrayList<WeightedEntry.Wrapper<ResourceLocation>>();

    private ItemManager() {
    }

    public void configLoad() {
        this.weightedMainItems.clear();
        this.weightedOffItems.clear();
        this.weightedMainItems.addAll(this.parseItems(Configs.COMMON.mainItems));
        this.weightedOffItems.addAll(this.parseItems(Configs.COMMON.offhandItems));
    }

    private List<WeightedEntry.Wrapper<ResourceLocation>> parseItems(ForgeConfigSpec.ConfigValue<List<? extends String>> items) {
        return ((List)items.get()).stream().map(item -> {
            ResourceLocation location;
            String[] parts = item.split("-");
            int weight = 1;
            if (parts.length == 2) {
                try {
                    weight = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {
                    LOGGER.error(String.format("Failed to parse item weight: %s", parts[1]), (Throwable)e);
                }
            }
            if ((location = ResourceLocation.m_135820_((String)parts[0])) == null || !ForgeRegistries.ITEMS.containsKey(location)) {
                LOGGER.error(String.format("Failed to parse item id: %s", parts[0]));
                return null;
            }
            return WeightedEntry.m_146290_((Object)location, (int)weight);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ItemStack getRandomMainHand(Random rand) {
        return this.getRandomItem(this.weightedMainItems, rand);
    }

    public ItemStack getRandomOffHand(Random rand) {
        return this.getRandomItem(this.weightedOffItems, rand);
    }

    private ItemStack getRandomItem(List<WeightedEntry.Wrapper<ResourceLocation>> items, Random rand) {
        if (items.size() <= 0) {
            return ItemStack.f_41583_;
        }
        return WeightedRandom.m_146317_((Random)rand, items).map(resourceLocationWrapper -> new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue((ResourceLocation)resourceLocationWrapper.m_146310_()))).orElse(ItemStack.f_41583_);
    }
}

