/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.utils;

import com.mojang.authlib.GameProfile;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.gory_moon.player_mobs.Configs;
import se.gory_moon.player_mobs.entity.PlayerMobEntity;

@Mod.EventBusSubscriber(modid="player_mobs")
public class DeathHandler {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        ItemStack stack;
        int looting;
        ItemStack drop;
        Entity trueSource;
        DamageSource source;
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof Player && entity.m_20193_().m_46469_().m_46207_(GameRules.f_46133_) && (source = event.getSource()) instanceof EntityDamageSource && (trueSource = source.m_7639_()) instanceof Player && !(drop = DeathHandler.getDrop(entity, source, looting = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44982_, (ItemStack)(stack = ((Player)trueSource).m_21211_())))).m_41619_()) {
            ((Player)entity).m_36176_(drop, true);
        }
    }

    @SubscribeEvent
    public static void onLivingDrop(LivingDropsEvent event) {
        ItemStack drop;
        LivingEntity entity = event.getEntityLiving();
        if ((entity instanceof Player || entity instanceof PlayerMobEntity) && !(drop = DeathHandler.getDrop(entity, event.getSource(), event.getLootingLevel())).m_41619_()) {
            event.getDrops().add(new ItemEntity(entity.m_20193_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), drop));
        }
    }

    private static ItemStack getDrop(LivingEntity entity, DamageSource source, int looting) {
        if (entity.m_20193_().m_5776_() || entity.m_21223_() > 0.0f) {
            return ItemStack.f_41583_;
        }
        if (entity.m_6162_()) {
            return ItemStack.f_41583_;
        }
        double baseChance = entity instanceof PlayerMobEntity ? (Double)Configs.COMMON.mobHeadDropChance.get() : (Double)Configs.COMMON.playerHeadDropChance.get();
        if (baseChance <= 0.0) {
            return ItemStack.f_41583_;
        }
        if (DeathHandler.poweredCreeper(source) || DeathHandler.randomDrop(entity.m_20193_().m_5822_(), baseChance, looting)) {
            GameProfile profile;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42680_);
            GameProfile gameProfile = profile = entity instanceof PlayerMobEntity ? ((PlayerMobEntity)entity).getProfile() : ((Player)entity).m_36316_();
            if (entity instanceof PlayerMobEntity) {
                PlayerMobEntity playerMob = (PlayerMobEntity)entity;
                String skinName = playerMob.getUsername().getSkinName();
                String displayName = playerMob.getUsername().getDisplayName();
                Component customName = playerMob.m_7770_();
                if (customName != null) {
                    displayName = customName;
                }
                if (!skinName.equals(displayName)) {
                    stack.m_41714_((Component)new TranslatableComponent("block.minecraft.player_head.named", new Object[]{displayName}));
                }
            }
            if (profile != null) {
                stack.m_41784_().m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)profile));
            }
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private static boolean poweredCreeper(DamageSource source) {
        Entity entity;
        if (source.m_19372_() && source instanceof EntityDamageSource && (entity = source.m_7639_()) instanceof Creeper) {
            return ((Creeper)entity).m_7090_();
        }
        return false;
    }

    private static boolean randomDrop(Random rand, double baseChance, int looting) {
        return rand.nextDouble() <= Math.max(0.0, baseChance * (double)Math.max(looting + 1, 1));
    }
}

