/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.repack.registrate.providers;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.IForgeRegistryEntry;
import se.gory_moon.player_mobs.repack.registrate.AbstractRegistrate;
import se.gory_moon.player_mobs.repack.registrate.providers.ProviderType;
import se.gory_moon.player_mobs.repack.registrate.providers.RegistrateProvider;
import se.gory_moon.player_mobs.repack.registrate.util.DataIngredient;
import se.gory_moon.player_mobs.repack.registrate.util.nullness.NonNullSupplier;

public class RegistrateRecipeProvider
extends RecipeProvider
implements RegistrateProvider,
Consumer<FinishedRecipe> {
    private final AbstractRegistrate<?> owner;
    @Nullable
    private Consumer<FinishedRecipe> callback;
    public static final int DEFAULT_SMELT_TIME = 200;
    public static final int DEFAULT_BLAST_TIME = 100;
    public static final int DEFAULT_SMOKE_TIME = 100;
    public static final int DEFAULT_CAMPFIRE_TIME = 600;
    private static final String SMELTING_NAME = "smelting";
    private static final ImmutableMap<SimpleCookingSerializer<?>, String> COOKING_TYPE_NAMES = ImmutableMap.builder().put((Object)RecipeSerializer.f_44091_, (Object)"smelting").put((Object)RecipeSerializer.f_44092_, (Object)"blasting").put((Object)RecipeSerializer.f_44093_, (Object)"smoking").put((Object)RecipeSerializer.f_44094_, (Object)"campfire").build();

    public RegistrateRecipeProvider(AbstractRegistrate<?> owner, DataGenerator generatorIn) {
        super(generatorIn);
        this.owner = owner;
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void accept(@Nullable FinishedRecipe t) {
        if (this.callback == null) {
            throw new IllegalStateException("Cannot accept recipes outside of a call to registerRecipes");
        }
        this.callback.accept(t);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.callback = consumer;
        this.owner.genData(ProviderType.RECIPE, this);
        this.callback = null;
    }

    public ResourceLocation safeId(ResourceLocation id) {
        return new ResourceLocation(this.owner.getModid(), this.safeName(id));
    }

    public ResourceLocation safeId(DataIngredient source) {
        return this.safeId(source.getId());
    }

    public ResourceLocation safeId(IForgeRegistryEntry<?> registryEntry) {
        return this.safeId(registryEntry.getRegistryName());
    }

    public String safeName(ResourceLocation id) {
        return id.m_135815_().replace('/', '_');
    }

    public String safeName(DataIngredient source) {
        return this.safeName(source.getId());
    }

    public String safeName(IForgeRegistryEntry<?> registryEntry) {
        return this.safeName(registryEntry.getRegistryName());
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void cooking(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime, SimpleCookingSerializer<?> serializer) {
        this.cooking(source, result, experience, cookingTime, (String)COOKING_TYPE_NAMES.get(serializer), serializer);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void cooking(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime, String typeName, SimpleCookingSerializer<?> serializer) {
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)source, (ItemLike)((ItemLike)result.get()), (float)experience, (int)cookingTime, serializer).m_142284_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_176500_((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName(source) + "_" + typeName);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void smelting(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.smelting(source, result, experience, 200);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void smelting(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, RecipeSerializer.f_44091_);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void blasting(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.blasting(source, result, experience, 100);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void blasting(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, RecipeSerializer.f_44092_);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void smoking(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.smoking(source, result, experience, 100);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void smoking(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, RecipeSerializer.f_44093_);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void campfire(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.campfire(source, result, experience, 600);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void campfire(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, RecipeSerializer.f_44094_);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void stonecutting(DataIngredient source, Supplier<? extends T> result) {
        this.stonecutting(source, result, 1);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void stonecutting(DataIngredient source, Supplier<? extends T> result, int resultAmount) {
        SingleItemRecipeBuilder.m_126316_((Ingredient)source, (ItemLike)((ItemLike)result.get()), (int)resultAmount).m_142284_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_176500_((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName(source) + "_stonecutting");
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void smeltingAndBlasting(DataIngredient source, Supplier<? extends T> result, float xp) {
        this.smelting(source, result, xp);
        this.blasting(source, result, xp);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void food(DataIngredient source, Supplier<? extends T> result, float xp) {
        this.smelting(source, result, xp);
        this.smoking(source, result, xp);
        this.campfire(source, result, xp);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void square(DataIngredient source, Supplier<? extends T> output, boolean small) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126124_(Character.valueOf('X'), (Ingredient)source);
        if (small) {
            builder.m_126130_("XX").m_126130_("XX");
        } else {
            builder.m_126130_("XXX").m_126130_("XXX").m_126130_("XXX");
        }
        builder.m_142284_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_142700_((Consumer)this, this.safeId((IForgeRegistryEntry)output.get()));
    }

    @Deprecated
    public <T extends ItemLike & IForgeRegistryEntry<?>> void storage(DataIngredient source, NonNullSupplier<? extends T> output) {
        this.square(source, output, false);
        this.singleItemUnfinished(source, output, 1, 9).m_176500_((Consumer)this, this.safeId(source) + "_from_" + this.safeName((IForgeRegistryEntry)output.get()));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void storage(NonNullSupplier<? extends T> source, NonNullSupplier<? extends T> output) {
        this.storage(DataIngredient.items(source, new NonNullSupplier[0]), source, DataIngredient.items(output, new NonNullSupplier[0]), output);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void storage(DataIngredient sourceIngredient, NonNullSupplier<? extends T> source, DataIngredient outputIngredient, NonNullSupplier<? extends T> output) {
        this.square(sourceIngredient, output, false);
        this.singleItemUnfinished(outputIngredient, source, 1, 9).m_176500_((Consumer)this, this.safeId(sourceIngredient) + "_from_" + this.safeName((IForgeRegistryEntry)output.get()));
    }

    @CheckReturnValue
    public <T extends ItemLike & IForgeRegistryEntry<?>> ShapelessRecipeBuilder singleItemUnfinished(DataIngredient source, Supplier<? extends T> result, int required, int amount) {
        return ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)result.get()), (int)amount).m_126186_((Ingredient)source, required).m_142284_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void singleItem(DataIngredient source, Supplier<? extends T> result, int required, int amount) {
        this.singleItemUnfinished(source, result, required, amount).m_142700_((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void planks(DataIngredient source, Supplier<? extends T> result) {
        this.singleItemUnfinished(source, result, 1, 4).m_142409_("planks").m_142700_((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void stairs(DataIngredient source, Supplier<? extends T> result, @Nullable String group, boolean stone) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)4).m_126130_("X  ").m_126130_("XX ").m_126130_("XXX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_142409_(group).m_142284_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_142700_((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
        if (stone) {
            this.stonecutting(source, result);
        }
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void slab(DataIngredient source, Supplier<? extends T> result, @Nullable String group, boolean stone) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)6).m_126130_("XXX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_142409_(group).m_142284_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_142700_((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
        if (stone) {
            this.stonecutting(source, result, 2);
        }
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void fence(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("W#W").m_126130_("W#W").m_126124_(Character.valueOf('W'), (Ingredient)source).m_126121_(Character.valueOf('#'), (Tag)Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_142700_((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void fenceGate(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("#W#").m_126130_("#W#").m_126124_(Character.valueOf('W'), (Ingredient)source).m_126121_(Character.valueOf('#'), (Tag)Tags.Items.RODS_WOODEN).m_142409_(group).m_142284_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_142700_((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void wall(DataIngredient source, Supplier<? extends T> result) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)6).m_126130_("XXX").m_126130_("XXX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_142284_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_142700_((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
        this.stonecutting(source, result);
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void door(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("XX").m_126130_("XX").m_126130_("XX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_142409_(group).m_142284_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_142700_((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends ItemLike & IForgeRegistryEntry<?>> void trapDoor(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)2).m_126130_("XXX").m_126130_("XXX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_142409_(group).m_142284_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_142700_((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public void m_126013_(HashCache p_126014_, JsonObject p_126015_, Path p_126016_) {
        super.m_126013_(p_126014_, p_126015_, p_126016_);
    }

    public static EnterBlockTrigger.TriggerInstance insideOf(Block p_125980_) {
        return RecipeProvider.m_125979_((Block)p_125980_);
    }

    public static InventoryChangeTrigger.TriggerInstance has(ItemLike p_125978_) {
        return RecipeProvider.m_125977_((ItemLike)p_125978_);
    }

    public static InventoryChangeTrigger.TriggerInstance has(Tag<Item> p_125976_) {
        return RecipeProvider.m_125975_(p_125976_);
    }

    public static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... p_126012_) {
        return RecipeProvider.m_126011_((ItemPredicate[])p_126012_);
    }
}

