/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.repack.registrate.builders;

import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.RegistryObject;
import se.gory_moon.player_mobs.repack.registrate.AbstractRegistrate;
import se.gory_moon.player_mobs.repack.registrate.builders.AbstractBuilder;
import se.gory_moon.player_mobs.repack.registrate.builders.BuilderCallback;
import se.gory_moon.player_mobs.repack.registrate.util.entry.MenuEntry;
import se.gory_moon.player_mobs.repack.registrate.util.entry.RegistryEntry;
import se.gory_moon.player_mobs.repack.registrate.util.nullness.NonNullSupplier;
import se.gory_moon.player_mobs.repack.registrate.util.nullness.NonnullType;

public class MenuBuilder<T extends AbstractContainerMenu, S extends Screen, P>
extends AbstractBuilder<MenuType<?>, MenuType<T>, P, MenuBuilder<T, S, P>> {
    private final ForgeMenuFactory<T> factory;
    private final NonNullSupplier<ScreenFactory<T, S>> screenFactory;

    public MenuBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, MenuFactory<T> factory, NonNullSupplier<ScreenFactory<T, S>> screenFactory) {
        this(owner, parent, name, callback, (MenuType<T> type, int windowId, Inventory inv, FriendlyByteBuf $) -> factory.create(type, windowId, inv), screenFactory);
    }

    public MenuBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ForgeMenuFactory<T> factory, NonNullSupplier<ScreenFactory<T, S>> screenFactory) {
        super(owner, parent, name, callback, MenuType.class);
        this.factory = factory;
        this.screenFactory = screenFactory;
    }

    @Override
    @NonnullType
    protected MenuType<T> createEntry() {
        ForgeMenuFactory factory = this.factory;
        NonNullSupplier supplier = this.asSupplier();
        MenuType ret = IForgeMenuType.create((windowId, inv, buf) -> factory.create((MenuType)supplier.get(), windowId, inv, buf));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ScreenFactory screenFactory = this.screenFactory.get();
            MenuScreens.m_96206_((MenuType)ret, (type, inv, displayName) -> screenFactory.create(type, inv, displayName));
        });
        return ret;
    }

    @Override
    protected RegistryEntry<MenuType<T>> createEntryWrapper(RegistryObject<MenuType<T>> delegate) {
        return new MenuEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public MenuEntry<T> register() {
        return (MenuEntry)super.register();
    }

    public static interface MenuFactory<T extends AbstractContainerMenu> {
        public T create(MenuType<T> var1, int var2, Inventory var3);
    }

    public static interface ForgeMenuFactory<T extends AbstractContainerMenu> {
        public T create(MenuType<T> var1, int var2, Inventory var3, @Nullable FriendlyByteBuf var4);
    }

    public static interface ScreenFactory<M extends AbstractContainerMenu, T extends Screen> {
        public T create(M var1, Inventory var2, Component var3);
    }
}

