/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import se.gory_moon.player_mobs.Configs;
import se.gory_moon.player_mobs.entity.EntityRegistry;
import se.gory_moon.player_mobs.sound.SoundRegistry;
import se.gory_moon.player_mobs.utils.ItemManager;
import se.gory_moon.player_mobs.utils.NameManager;
import se.gory_moon.player_mobs.utils.PlayerName;
import se.gory_moon.player_mobs.utils.ProfileUpdater;

public class PlayerMobEntity
extends Monster
implements RangedAttackMob,
CrossbowAttackMob {
    @Nullable
    private GameProfile profile;
    @Nullable
    private ResourceLocation skin;
    @Nullable
    private ResourceLocation cape;
    private boolean skinAvailable;
    private boolean capeAvailable;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;
    private static final UUID BABY_SPEED_BOOST_ID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier BABY_SPEED_BOOST = new AttributeModifier(BABY_SPEED_BOOST_ID, "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Boolean> IS_CHILD = SynchedEntityData.m_135353_(PlayerMobEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> NAME = SynchedEntityData.m_135353_(PlayerMobEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(PlayerMobEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean canBreakDoors;
    private final BreakDoorGoal breakDoorGoal = new BreakDoorGoal((Mob)this, difficulty -> difficulty == Difficulty.HARD);
    private final RangedBowAttackGoal<PlayerMobEntity> bowAttackGoal = new RangedBowAttackGoal((Monster)this, 1.0, 20, 15.0f);
    private final RangedCrossbowAttackGoal<PlayerMobEntity> crossbowAttackGoal = new RangedCrossbowAttackGoal((Monster)this, 1.0, 15.0f);

    public PlayerMobEntity(Level worldIn) {
        this((EntityType<? extends Monster>)((EntityType)EntityRegistry.PLAYER_MOB_ENTITY.get()), worldIn);
    }

    public PlayerMobEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.setCombatTask();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 35.0).m_22266_(Attributes.f_22282_).m_22268_(Attributes.f_22281_, 3.5).m_22268_(Attributes.f_22279_, 0.24);
    }

    private boolean targetTwin(LivingEntity livingEntity) {
        return (Boolean)Configs.COMMON.attackTwin.get() != false || !(livingEntity instanceof Player) || !livingEntity.m_7755_().getString().equals(this.getUsername().getDisplayName());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        if (((Boolean)Configs.COMMON.openDoors.get()).booleanValue() && this.f_19853_.m_46791_().m_19028_() >= ((Difficulty)Configs.COMMON.openDoorsDifficulty.get()).m_19028_()) {
            this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        }
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{ZombifiedPiglin.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::targetTwin));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(NAME, (Object)"");
        this.m_20088_().m_135372_(IS_CHILD, (Object)false);
        this.m_20088_().m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    public void m_6083_() {
        super.m_6083_();
        Entity entity = this.m_20202_();
        if (entity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)entity;
            this.f_20883_ = mob.f_20883_;
        }
    }

    protected void m_6851_(DifficultyInstance pDifficulty) {
        block8: {
            block7: {
                super.m_6851_(pDifficulty);
                boolean force = (Boolean)Configs.COMMON.forceSpawnItem.get();
                if (force) break block7;
                float f = this.f_19796_.nextFloat();
                float f2 = this.f_19853_.m_46791_() == Difficulty.HARD ? 0.5f : 0.1f;
                if (!(f < f2)) break block8;
            }
            ItemStack stack = ItemManager.INSTANCE.getRandomMainHand(this.f_19796_);
            this.m_8061_(EquipmentSlot.MAINHAND, stack);
            if (this.f_19853_.m_46791_().m_19028_() >= ((Difficulty)Configs.COMMON.offhandDifficultyLimit.get()).m_19028_() && this.f_19796_.nextDouble() > (Double)Configs.COMMON.offhandSpawnChance.get()) {
                if (stack.m_41720_() instanceof ProjectileWeaponItem && ((Boolean)Configs.COMMON.allowTippedArrows.get()).booleanValue()) {
                    ArrayList potions = new ArrayList(ForgeRegistries.POTIONS.getKeys());
                    potions.removeAll(Configs.COMMON.tippedArrowBlocklist);
                    if (potions.size() > 0) {
                        Potion potion = (Potion)ForgeRegistries.POTIONS.getValue((ResourceLocation)potions.get(this.f_19796_.nextInt(potions.size())));
                        this.m_8061_(EquipmentSlot.OFFHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)potion));
                    }
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemManager.INSTANCE.getRandomOffHand(this.f_19796_));
                    this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("Shield Bonus", this.f_19796_.nextDouble() * 3.0 + 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
                }
            }
        }
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
        super.m_8061_(slotIn, stack);
        if (!this.f_19853_.f_46443_) {
            this.setCombatTask();
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (IS_CHILD.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    protected int m_6552_(Player player) {
        if (this.m_6162_()) {
            this.f_21364_ = (int)((float)this.f_21364_ * 2.5f);
        }
        return super.m_6552_(player);
    }

    public float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? 0.93f : 1.62f;
    }

    public boolean m_6109_() {
        return false;
    }

    public boolean m_21255_() {
        return false;
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.45;
    }

    public boolean m_7252_(ItemStack stack) {
        return (stack.m_41720_() != Items.f_42521_ || !this.m_6162_() || !this.m_20159_()) && super.m_7252_(stack);
    }

    public void m_8119_() {
        super.m_8119_();
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double x = this.m_20185_() - this.xCloak;
        double y = this.m_20186_() - this.yCloak;
        double z = this.m_20189_() - this.zCloak;
        double maxCapeAngle = 10.0;
        if (x > maxCapeAngle) {
            this.xCloakO = this.xCloak = this.m_20185_();
        }
        if (z > maxCapeAngle) {
            this.zCloakO = this.zCloak = this.m_20189_();
        }
        if (y > maxCapeAngle) {
            this.yCloakO = this.yCloak = this.m_20186_();
        }
        if (x < -maxCapeAngle) {
            this.xCloakO = this.xCloak = this.m_20185_();
        }
        if (z < -maxCapeAngle) {
            this.zCloakO = this.zCloak = this.m_20189_();
        }
        if (y < -maxCapeAngle) {
            this.yCloakO = this.yCloak = this.m_20186_();
        }
        this.xCloak += x * 0.25;
        this.zCloak += z * 0.25;
        this.yCloak += y * 0.25;
    }

    public boolean m_7327_(Entity entityIn) {
        boolean result = super.m_7327_(entityIn);
        if (result) {
            this.m_6674_(InteractionHand.MAIN_HAND);
        }
        return result;
    }

    public boolean m_6162_() {
        return (Boolean)this.m_20088_().m_135370_(IS_CHILD);
    }

    public void m_6863_(boolean isChild) {
        super.m_6863_(isChild);
        this.m_20088_().m_135381_(IS_CHILD, (Object)isChild);
        if (!this.f_19853_.f_46443_) {
            AttributeInstance attribute = this.m_21051_(Attributes.f_22279_);
            attribute.m_22130_(BABY_SPEED_BOOST);
            if (isChild) {
                attribute.m_22118_(BABY_SPEED_BOOST);
            }
        }
    }

    protected void m_5502_(Player player, Mob child) {
        if (child instanceof PlayerMobEntity) {
            ((PlayerMobEntity)child).setUsername(this.getUsername());
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(world, difficulty, reason, spawnData, dataTag);
        this.m_6851_(difficulty);
        this.m_6850_(difficulty);
        if (!this.hasUsername()) {
            this.setUsername(NameManager.INSTANCE.getRandomName());
        }
        this.setCombatTask();
        float additionalDifficulty = difficulty.m_19057_();
        this.m_21553_((double)this.f_19796_.nextFloat() < (Double)Configs.COMMON.pickupItemsChance.get() * (double)additionalDifficulty);
        this.setCanBreakDoors(this.f_19796_.nextFloat() < additionalDifficulty * 0.1f);
        double rangeBonus = this.f_19796_.nextDouble() * 1.5 * (double)additionalDifficulty;
        if (rangeBonus > 1.0) {
            this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("Range Bonus", rangeBonus, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.f_19796_.nextFloat() < additionalDifficulty * 0.05f) {
            this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("Health Bonus", this.f_19796_.nextDouble() * 3.0 + 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.f_19796_.nextFloat() < additionalDifficulty * 0.15f) {
            this.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier("Damage Bonus", this.f_19796_.nextDouble() + 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.f_19796_.nextFloat() < additionalDifficulty * 0.2f) {
            this.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier("Speed Bonus", this.f_19796_.nextDouble() * 2.0 * 0.24 + 0.01, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.f_19796_.nextDouble() < (Double)Configs.COMMON.babySpawnChance.get()) {
            this.m_6863_(true);
        }
        return spawnData;
    }

    public void setCombatTask() {
        if (!this.f_19853_.f_46443_) {
            this.f_21345_.m_25363_(this.bowAttackGoal);
            this.f_21345_.m_25363_(this.crossbowAttackGoal);
            ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, this::canFireProjectileWeapon));
            if (itemstack.m_41720_() instanceof CrossbowItem) {
                this.f_21345_.m_25352_(2, this.crossbowAttackGoal);
            } else if (itemstack.m_41720_() instanceof BowItem) {
                this.bowAttackGoal.m_25797_(this.f_19853_.m_46791_() != Difficulty.HARD ? 20 : 40);
                this.f_21345_.m_25352_(2, this.bowAttackGoal);
            }
        }
    }

    public void setCanBreakDoors(boolean enabled) {
        if (GoalUtils.m_26894_((Mob)this)) {
            if (this.canBreakDoors != enabled) {
                this.canBreakDoors = enabled;
                ((GroundPathNavigation)this.m_21573_()).m_26477_(enabled);
                if (enabled) {
                    this.f_21345_.m_25352_(1, (Goal)this.breakDoorGoal);
                } else {
                    this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    public boolean canFireProjectileWeapon(Item item) {
        ProjectileWeaponItem weaponItem;
        return item instanceof ProjectileWeaponItem && this.m_5886_(weaponItem = (ProjectileWeaponItem)item);
    }

    public boolean m_5886_(ProjectileWeaponItem item) {
        return item instanceof BowItem || item instanceof CrossbowItem;
    }

    public void m_5811_(LivingEntity target, ItemStack crossbow, Projectile projectile, float angle) {
        this.m_32322_((LivingEntity)this, target, projectile, angle, 1.6f);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean pIsCharging) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)pIsCharging);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        ItemStack weaponStack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, this::canFireProjectileWeapon));
        if (weaponStack.m_41720_() instanceof CrossbowItem) {
            this.m_32336_((LivingEntity)this, 1.6f);
        } else {
            ItemStack itemstack = this.m_6298_(weaponStack);
            AbstractArrow mobArrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemstack, (float)pDistanceFactor);
            if (this.m_21205_().m_41720_() instanceof BowItem) {
                mobArrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(mobArrow);
            }
            double x = pTarget.m_20185_() - this.m_20185_();
            double y = pTarget.m_20227_(0.3333333333333333) - mobArrow.m_20186_();
            double z = pTarget.m_20189_() - this.m_20189_();
            double d3 = Math.sqrt(x * x + z * z);
            mobArrow.m_6686_(x, y + d3 * (double)0.2f, z, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
            this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
            this.f_19853_.m_7967_((Entity)mobArrow);
        }
    }

    public void m_7380_(CompoundTag compound) {
        String username;
        super.m_7380_(compound);
        if (this.m_7770_() != null && this.m_7770_().getString().isEmpty()) {
            compound.m_128473_("CustomName");
        }
        if (!StringUtil.m_14408_((String)(username = this.getUsername().getCombinedNames()))) {
            compound.m_128359_("Username", username);
        }
        compound.m_128379_("CanBreakDoors", this.canBreakDoors);
        compound.m_128379_("IsBaby", this.m_6162_());
        if (this.profile != null && this.profile.isComplete()) {
            compound.m_128365_("Profile", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.profile));
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        String username = compound.m_128461_("Username");
        if (!StringUtil.m_14408_((String)username)) {
            this.setUsername(username);
        } else {
            this.setUsername(NameManager.INSTANCE.getRandomName());
        }
        this.m_6863_(compound.m_128471_("IsBaby"));
        this.setCanBreakDoors(compound.m_128471_("CanBreakDoors"));
        if (compound.m_128425_("Profile", 10)) {
            this.profile = NbtUtils.m_129228_((CompoundTag)compound.m_128469_("Profile"));
        }
        this.setCombatTask();
    }

    public Component m_7770_() {
        Component customName = super.m_7770_();
        String displayName = this.getUsername().getDisplayName();
        return customName != null && !customName.getString().isEmpty() ? customName : (!StringUtil.m_14408_((String)displayName) ? new TextComponent(displayName) : null);
    }

    public boolean m_8077_() {
        return super.m_8077_() || !StringUtil.m_14408_((String)this.getUsername().getDisplayName());
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    protected SoundEvent m_7515_() {
        return SoundRegistry.PLAYER_MOB_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundRegistry.PLAYER_MOB_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return SoundRegistry.PLAYER_MOB_DEATH.get();
    }

    @Nullable
    public GameProfile getProfile() {
        if (this.profile == null && this.hasUsername()) {
            this.profile = new GameProfile(null, this.getUsername().getSkinName());
            ProfileUpdater.updateProfile(this);
        }
        return this.profile;
    }

    public void setProfile(@Nullable GameProfile profile) {
        this.profile = profile;
    }

    public boolean hasUsername() {
        return !StringUtil.m_14408_((String)((String)this.m_20088_().m_135370_(NAME)));
    }

    public PlayerName getUsername() {
        if (!this.hasUsername() && !this.f_19853_.m_5776_()) {
            this.setUsername(NameManager.INSTANCE.getRandomName());
        }
        return new PlayerName((String)this.m_20088_().m_135370_(NAME));
    }

    public void setUsername(String username) {
        Optional<PlayerName> name;
        PlayerName playerName = new PlayerName(username);
        if (playerName.noDisplayName() && (name = NameManager.INSTANCE.findName(username)).isPresent()) {
            playerName = name.get();
        }
        NameManager.INSTANCE.useName(playerName);
        this.setUsername(playerName);
    }

    public void setUsername(PlayerName name) {
        PlayerName oldName = this.hasUsername() ? this.getUsername() : null;
        this.m_20088_().m_135381_(NAME, (Object)name.getCombinedNames());
        if ("Herobrine".equals(name.getDisplayName())) {
            this.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier("Herobrine Damage Bonus", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            this.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier("Herobrine Speed Bonus", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (!Objects.equals(oldName, name)) {
            this.setProfile(null);
            this.getProfile();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public SkinManager.SkinTextureCallback getSkinCallback() {
        return (type, location, profileTexture) -> {
            switch (type) {
                case SKIN: {
                    this.skin = location;
                    this.skinAvailable = true;
                    break;
                }
                case CAPE: {
                    this.cape = location;
                    this.capeAvailable = true;
                }
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isTextureAvailable(MinecraftProfileTexture.Type type) {
        if (type == MinecraftProfileTexture.Type.SKIN) {
            return this.skinAvailable;
        }
        return this.capeAvailable;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture(MinecraftProfileTexture.Type type) {
        if (type == MinecraftProfileTexture.Type.SKIN) {
            return this.skin;
        }
        return this.cape;
    }
}

