/*
 * Decompiled with CFR 0.152.
 */
package reascer.efdg.skill;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SpecialAttackSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class EarthquakeSkill
extends SpecialAttackSkill {
    private static final UUID EVENT_UUID = UUID.fromString("b19d1eb4-fefa-11ec-b939-0242ac12000");
    private static final SkillDataManager.SkillDataKey<Integer> TENACIT = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    protected final StaticAnimation attackAnimation;

    public static Builder createBuilder(ResourceLocation resourceLocation) {
        return new Builder(resourceLocation).setCategory(SkillCategories.WEAPON_SPECIAL_ATTACK).setResource(Skill.Resource.SPECIAL_GAUAGE);
    }

    public EarthquakeSkill(Builder builder) {
        super((Skill.Builder)builder);
        this.attackAnimation = builder.attackAnimation;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getDataManager().registerData(TENACIT);
        container.getDataManager().setData(TENACIT, (Object)0);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue(TENACIT) > 0) {
                ((ExtendedDamageSource)event.getDamageSource()).setStunType(ExtendedDamageSource.StunType.NONE);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        executer.playAnimationSynchronized(this.attackAnimation, 0.0f);
        executer.getSkill(this.category).getDataManager().setDataSync(TENACIT, (Object)30, (ServerPlayer)executer.getOriginal());
        super.executeOnServer(executer, args);
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Swing:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(2), "Slam :");
        return list;
    }

    public SpecialAttackSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if ((Integer)container.getDataManager().getDataValue(TENACIT) > 0 && !container.getExecuter().isLogicalClient()) {
            container.getDataManager().setDataSync(TENACIT, (Object)((Integer)container.getDataManager().getDataValue(TENACIT) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
        }
    }

    public static class Builder
    extends Skill.Builder<EarthquakeSkill> {
        protected StaticAnimation attackAnimation;

        public Builder(ResourceLocation resourceLocation) {
            super(resourceLocation);
        }

        public Builder setCategory(SkillCategories category) {
            this.category = category;
            return this;
        }

        public Builder setConsumption(float consumption) {
            this.consumption = consumption;
            return this;
        }

        public Builder setMaxDuration(int maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public Builder setMaxStack(int maxStack) {
            this.maxStack = maxStack;
            return this;
        }

        public Builder setRequiredXp(int requiredXp) {
            this.requiredXp = requiredXp;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setAnimations(StaticAnimation attackAnimation) {
            this.attackAnimation = attackAnimation;
            return this;
        }
    }
}

