/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr.loader;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.coderbot.iris.Iris;
import net.coderbot.iris.mixin.texture.AnimatedTextureAccessor;
import net.coderbot.iris.mixin.texture.AnimationMetadataSectionAccessor;
import net.coderbot.iris.mixin.texture.FrameInfoAccessor;
import net.coderbot.iris.mixin.texture.TextureAtlasAccessor;
import net.coderbot.iris.mixin.texture.TextureAtlasSpriteAccessor;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.mipmap.ChannelMipmapGenerator;
import net.coderbot.iris.texture.mipmap.CustomMipmapGenerator;
import net.coderbot.iris.texture.mipmap.LinearBlendFunction;
import net.coderbot.iris.texture.pbr.PBRAtlasTexture;
import net.coderbot.iris.texture.pbr.PBRSpriteHolder;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.TextureAtlasSpriteExtension;
import net.coderbot.iris.texture.pbr.loader.PBRTextureLoader;
import net.coderbot.iris.texture.util.ImageManipulationUtil;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class AtlasPBRLoader
implements PBRTextureLoader<TextureAtlas> {
    public static final ChannelMipmapGenerator LINEAR_MIPMAP_GENERATOR = new ChannelMipmapGenerator(LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE);

    @Override
    public void load(TextureAtlas atlas, ResourceManager resourceManager, PBRTextureLoader.PBRTextureConsumer pbrTextureConsumer) {
        TextureInfoCache.TextureInfo textureInfo = TextureInfoCache.INSTANCE.getInfo(atlas.m_117963_());
        int atlasWidth = textureInfo.getWidth();
        int atlasHeight = textureInfo.getHeight();
        int mipLevel = AtlasPBRLoader.fetchAtlasMipLevel(atlas);
        PBRAtlasTexture normalAtlas = null;
        PBRAtlasTexture specularAtlas = null;
        for (TextureAtlasSprite sprite : ((TextureAtlasAccessor)atlas).getTexturesByName().values()) {
            PBRSpriteHolder pbrSpriteHolder;
            if (sprite instanceof MissingTextureAtlasSprite) continue;
            TextureAtlasSprite normalSprite = this.createPBRSprite(sprite, resourceManager, atlas, atlasWidth, atlasHeight, mipLevel, PBRType.NORMAL);
            TextureAtlasSprite specularSprite = this.createPBRSprite(sprite, resourceManager, atlas, atlasWidth, atlasHeight, mipLevel, PBRType.SPECULAR);
            if (normalSprite != null) {
                if (normalAtlas == null) {
                    normalAtlas = new PBRAtlasTexture(atlas, PBRType.NORMAL);
                }
                normalAtlas.addSprite(normalSprite);
                pbrSpriteHolder = ((TextureAtlasSpriteExtension)sprite).getOrCreatePBRHolder();
                pbrSpriteHolder.setNormalSprite(normalSprite);
            }
            if (specularSprite == null) continue;
            if (specularAtlas == null) {
                specularAtlas = new PBRAtlasTexture(atlas, PBRType.SPECULAR);
            }
            specularAtlas.addSprite(specularSprite);
            pbrSpriteHolder = ((TextureAtlasSpriteExtension)sprite).getOrCreatePBRHolder();
            pbrSpriteHolder.setSpecularSprite(specularSprite);
        }
        if (normalAtlas != null && normalAtlas.tryUpload(atlasWidth, atlasHeight, mipLevel)) {
            pbrTextureConsumer.acceptNormalTexture(normalAtlas);
        }
        if (specularAtlas != null && specularAtlas.tryUpload(atlasWidth, atlasHeight, mipLevel)) {
            pbrTextureConsumer.acceptSpecularTexture(specularAtlas);
        }
    }

    protected static int fetchAtlasMipLevel(TextureAtlas atlas) {
        TextureAtlasSprite missingSprite = atlas.m_118316_(MissingTextureAtlasSprite.m_118071_());
        return ((TextureAtlasSpriteAccessor)missingSprite).getMainImage().length - 1;
    }

    @Nullable
    protected TextureAtlasSprite createPBRSprite(TextureAtlasSprite sprite, ResourceManager resourceManager, TextureAtlas atlas, int atlasWidth, int atlasHeight, int mipLevel, PBRType pbrType) {
        ResourceLocation spriteName = sprite.m_118413_();
        ResourceLocation imageLocation = ((TextureAtlasAccessor)atlas).callGetResourceLocation(spriteName);
        ResourceLocation pbrImageLocation = pbrType.appendToFileLocation(imageLocation);
        PBRTextureAtlasSprite pbrSprite = null;
        try (Resource resource2 = resourceManager.m_142591_(pbrImageLocation);){
            NativeImage nativeImage = NativeImage.m_85058_((InputStream)resource2.m_6679_());
            AnimationMetadataSection animationMetadata = (AnimationMetadataSection)resource2.m_5507_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_);
            if (animationMetadata == null) {
                animationMetadata = AnimationMetadataSection.f_119012_;
            }
            Pair frameSize = animationMetadata.m_7117_(nativeImage.m_84982_(), nativeImage.m_85084_());
            int frameWidth = (Integer)frameSize.getFirst();
            int frameHeight = (Integer)frameSize.getSecond();
            int targetFrameWidth = sprite.m_118405_();
            int targetFrameHeight = sprite.m_118408_();
            if (frameWidth != targetFrameWidth || frameHeight != targetFrameHeight) {
                int imageWidth = nativeImage.m_84982_();
                int imageHeight = nativeImage.m_85084_();
                int targetImageWidth = imageWidth / frameWidth * targetFrameWidth;
                int targetImageHeight = imageHeight / frameHeight * targetFrameHeight;
                NativeImage scaledImage = targetImageWidth % imageWidth == 0 && targetImageHeight % imageHeight == 0 ? ImageManipulationUtil.scaleNearestNeighbor(nativeImage, targetImageWidth, targetImageHeight) : ImageManipulationUtil.scaleBilinear(nativeImage, targetImageWidth, targetImageHeight);
                nativeImage.close();
                nativeImage = scaledImage;
                frameWidth = targetFrameWidth;
                frameHeight = targetFrameHeight;
                if (animationMetadata != AnimationMetadataSection.f_119012_) {
                    AnimationMetadataSectionAccessor animationAccessor = (AnimationMetadataSectionAccessor)animationMetadata;
                    int internalFrameWidth = animationAccessor.getFrameWidth();
                    int internalFrameHeight = animationAccessor.getFrameHeight();
                    if (internalFrameWidth != -1) {
                        animationAccessor.setFrameWidth(frameWidth);
                    }
                    if (internalFrameHeight != -1) {
                        animationAccessor.setFrameHeight(frameHeight);
                    }
                }
            }
            ResourceLocation pbrSpriteName = new ResourceLocation(spriteName.m_135827_(), spriteName.m_135815_() + pbrType.getSuffix());
            PBRTextureAtlasSpriteInfo pbrSpriteInfo = new PBRTextureAtlasSpriteInfo(pbrSpriteName, frameWidth, frameHeight, animationMetadata, pbrType);
            int x = ((TextureAtlasSpriteAccessor)sprite).getX();
            int y = ((TextureAtlasSpriteAccessor)sprite).getY();
            pbrSprite = new PBRTextureAtlasSprite(atlas, pbrSpriteInfo, mipLevel, atlasWidth, atlasHeight, x, y, nativeImage);
            this.syncAnimation(sprite, pbrSprite);
        }
        catch (FileNotFoundException resource2) {
        }
        catch (RuntimeException e) {
            Iris.logger.error("Unable to parse metadata from {} : {}", pbrImageLocation, e);
        }
        catch (IOException e) {
            Iris.logger.error("Unable to load {} : {}", pbrImageLocation, e);
        }
        return pbrSprite;
    }

    protected void syncAnimation(TextureAtlasSprite source, TextureAtlasSprite target) {
        int time;
        Tickable sourceTicker = source.m_174746_();
        Tickable targetTicker = target.m_174746_();
        if (!(sourceTicker instanceof AnimatedTextureAccessor) || !(targetTicker instanceof AnimatedTextureAccessor)) {
            return;
        }
        AnimatedTextureAccessor sourceAccessor = (AnimatedTextureAccessor)sourceTicker;
        int ticks = 0;
        for (int f = 0; f < sourceAccessor.getFrame(); ++f) {
            ticks += ((FrameInfoAccessor)sourceAccessor.getFrames().get(f)).getTime();
        }
        AnimatedTextureAccessor targetAccessor = (AnimatedTextureAccessor)targetTicker;
        List<Object> targetFrames = targetAccessor.getFrames();
        int cycleTime = 0;
        int frameCount = targetFrames.size();
        for (int f = 0; f < frameCount; ++f) {
            cycleTime += ((FrameInfoAccessor)targetFrames.get(f)).getTime();
        }
        ticks %= cycleTime;
        int targetFrame = 0;
        while (ticks >= (time = ((FrameInfoAccessor)targetFrames.get(targetFrame)).getTime())) {
            ++targetFrame;
            ticks -= time;
        }
        targetAccessor.setFrame(targetFrame);
        targetAccessor.setSubFrame(ticks + sourceAccessor.getSubFrame());
    }

    protected static class PBRTextureAtlasSpriteInfo
    extends TextureAtlasSprite.Info {
        protected final PBRType pbrType;

        public PBRTextureAtlasSpriteInfo(ResourceLocation name, int width, int height, AnimationMetadataSection metadata, PBRType pbrType) {
            super(name, width, height, metadata);
            this.pbrType = pbrType;
        }
    }

    public static class PBRTextureAtlasSprite
    extends TextureAtlasSprite
    implements CustomMipmapGenerator.Provider {
        protected PBRTextureAtlasSprite(TextureAtlas atlas, TextureAtlasSprite.Info info, int mipLevel, int atlasWidth, int atlasHeight, int x, int y, NativeImage nativeImage) {
            super(atlas, info, mipLevel, atlasWidth, atlasHeight, x, y, nativeImage);
        }

        @Override
        public CustomMipmapGenerator getMipmapGenerator(TextureAtlasSprite.Info info, int atlasWidth, int atlasHeight) {
            if (info instanceof PBRTextureAtlasSpriteInfo) {
                CustomMipmapGenerator generator;
                PBRType pbrType = ((PBRTextureAtlasSpriteInfo)info).pbrType;
                TextureFormat format = TextureFormatLoader.getFormat();
                if (format != null && (generator = format.getMipmapGenerator(pbrType)) != null) {
                    return generator;
                }
            }
            return LINEAR_MIPMAP_GENERATOR;
        }
    }
}

