/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestFunction;
import net.coderbot.iris.gl.blending.BlendMode;
import net.coderbot.iris.gl.blending.BlendModeFunction;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.blending.BufferBlendInformation;
import net.coderbot.iris.gl.texture.TextureScaleOverride;
import net.coderbot.iris.shaderpack.CloudSetting;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.OrderBackedProperties;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.preprocessor.PropertiesPreprocessor;
import net.coderbot.iris.shaderpack.texture.TextureStage;

public class ShaderProperties {
    private CloudSetting cloudSetting = CloudSetting.DEFAULT;
    private OptionalBoolean oldHandLight = OptionalBoolean.DEFAULT;
    private OptionalBoolean dynamicHandLight = OptionalBoolean.DEFAULT;
    private OptionalBoolean oldLighting = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowTerrain = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowTranslucent = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowEntities = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowPlayer = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowBlockEntities = OptionalBoolean.DEFAULT;
    private OptionalBoolean underwaterOverlay = OptionalBoolean.DEFAULT;
    private OptionalBoolean sun = OptionalBoolean.DEFAULT;
    private OptionalBoolean moon = OptionalBoolean.DEFAULT;
    private OptionalBoolean vignette = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceSolid = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceCutout = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceCutoutMipped = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceTranslucent = OptionalBoolean.DEFAULT;
    private OptionalBoolean rainDepth = OptionalBoolean.DEFAULT;
    private OptionalBoolean concurrentCompute = OptionalBoolean.DEFAULT;
    private OptionalBoolean beaconBeamDepth = OptionalBoolean.DEFAULT;
    private OptionalBoolean separateAo = OptionalBoolean.DEFAULT;
    private OptionalBoolean frustumCulling = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowCulling = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowEnabled = OptionalBoolean.DEFAULT;
    private OptionalBoolean particlesBeforeDeferred = OptionalBoolean.DEFAULT;
    private OptionalBoolean prepareBeforeShadow = OptionalBoolean.DEFAULT;
    private List<String> sliderOptions = new ArrayList<String>();
    private final Map<String, List<String>> profiles = new LinkedHashMap<String, List<String>>();
    private List<String> mainScreenOptions = null;
    private final Map<String, List<String>> subScreenOptions = new HashMap<String, List<String>>();
    private Integer mainScreenColumnCount = null;
    private final Map<String, Integer> subScreenColumnCount = new HashMap<String, Integer>();
    private final Object2ObjectMap<String, AlphaTest> alphaTestOverrides = new Object2ObjectOpenHashMap();
    private final Object2FloatMap<String> viewportScaleOverrides = new Object2FloatOpenHashMap();
    private final Object2ObjectMap<String, TextureScaleOverride> textureScaleOverrides = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, BlendModeOverride> blendModeOverrides = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, ArrayList<BufferBlendInformation>> bufferBlendOverrides = new Object2ObjectOpenHashMap();
    private final EnumMap<TextureStage, Object2ObjectMap<String, String>> customTextures = new EnumMap(TextureStage.class);
    private final Object2ObjectMap<String, Object2BooleanMap<String>> explicitFlips = new Object2ObjectOpenHashMap();
    private String noiseTexturePath = null;
    private Object2ObjectMap<String, String> conditionallyEnabledPrograms = new Object2ObjectOpenHashMap();
    private List<String> requiredFeatureFlags = new ArrayList<String>();
    private List<String> optionalFeatureFlags = new ArrayList<String>();

    private ShaderProperties() {
    }

    public ShaderProperties(String contents, ShaderPackOptions shaderPackOptions, Iterable<StringPair> environmentDefines) {
        String preprocessedContents = PropertiesPreprocessor.preprocessSource(contents, shaderPackOptions, environmentDefines);
        OrderBackedProperties preprocessed = new OrderBackedProperties();
        OrderBackedProperties original = new OrderBackedProperties();
        try {
            preprocessed.load(new StringReader(preprocessedContents));
            original.load(new StringReader(contents));
        }
        catch (IOException e) {
            Iris.logger.error("Error loading shaders.properties!", e);
        }
        ((Properties)preprocessed).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(keyObject, valueObject) -> {
            String key = (String)keyObject;
            String value = (String)valueObject;
            if ("texture.noise".equals(key)) {
                this.noiseTexturePath = value;
                return;
            }
            if ("clouds".equals(key)) {
                if ("off".equals(value)) {
                    this.cloudSetting = CloudSetting.OFF;
                } else if ("fast".equals(value)) {
                    this.cloudSetting = CloudSetting.FAST;
                } else if ("fancy".equals(value)) {
                    this.cloudSetting = CloudSetting.FANCY;
                } else {
                    Iris.logger.error("Unrecognized clouds setting: " + value);
                }
            }
            ShaderProperties.handleBooleanDirective(key, value, "oldHandLight", bool -> {
                this.oldHandLight = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "dynamicHandLight", bool -> {
                this.dynamicHandLight = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "oldLighting", bool -> {
                this.oldLighting = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowTerrain", bool -> {
                this.shadowTerrain = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowTranslucent", bool -> {
                this.shadowTranslucent = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowEntities", bool -> {
                this.shadowEntities = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowPlayer", bool -> {
                this.shadowPlayer = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowBlockEntities", bool -> {
                this.shadowBlockEntities = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "underwaterOverlay", bool -> {
                this.underwaterOverlay = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "sun", bool -> {
                this.sun = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "moon", bool -> {
                this.moon = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "vignette", bool -> {
                this.vignette = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "backFace.solid", bool -> {
                this.backFaceSolid = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "backFace.cutout", bool -> {
                this.backFaceCutout = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "backFace.cutoutMipped", bool -> {
                this.backFaceCutoutMipped = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "backFace.translucent", bool -> {
                this.backFaceTranslucent = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "rain.depth", bool -> {
                this.rainDepth = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "allowConcurrentCompute", bool -> {
                this.concurrentCompute = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "beacon.beam.depth", bool -> {
                this.beaconBeamDepth = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "separateAo", bool -> {
                this.separateAo = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "frustum.culling", bool -> {
                this.frustumCulling = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadow.culling", bool -> {
                this.shadowCulling = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadow.enabled", bool -> {
                this.shadowEnabled = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "particles.before.deferred", bool -> {
                this.particlesBeforeDeferred = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "prepareBeforeShadow", bool -> {
                this.prepareBeforeShadow = bool;
            });
            ShaderProperties.handlePassDirective("scale.", key, value, pass -> {
                float scale;
                try {
                    scale = Float.parseFloat(value);
                }
                catch (NumberFormatException e) {
                    Iris.logger.error("Unable to parse scale directive for " + pass + ": " + value, e);
                    return;
                }
                this.viewportScaleOverrides.put(pass, scale);
            });
            ShaderProperties.handlePassDirective("size.buffer.", key, value, pass -> {
                String[] parts = value.split(" ");
                if (parts.length != 2) {
                    Iris.logger.error("Unable to parse size.buffer directive for " + pass + ": " + value);
                    return;
                }
                this.textureScaleOverrides.put(pass, (Object)new TextureScaleOverride(parts[0], parts[1]));
            });
            ShaderProperties.handlePassDirective("alphaTest.", key, value, pass -> {
                float reference;
                if ("off".equals(value)) {
                    this.alphaTestOverrides.put(pass, (Object)AlphaTest.ALWAYS);
                    return;
                }
                String[] parts = value.split(" ");
                if (parts.length > 2) {
                    Iris.logger.warn("Weird alpha test directive for " + pass + " contains more parts than we expected: " + value);
                } else if (parts.length < 2) {
                    Iris.logger.error("Invalid alpha test directive for " + pass + ": " + value);
                    return;
                }
                Optional<AlphaTestFunction> function = AlphaTestFunction.fromString(parts[0]);
                if (!function.isPresent()) {
                    Iris.logger.error("Unable to parse alpha test directive for " + pass + ", unknown alpha test function " + parts[0] + ": " + value);
                    return;
                }
                try {
                    reference = Float.parseFloat(parts[1]);
                }
                catch (NumberFormatException e) {
                    Iris.logger.error("Unable to parse alpha test directive for " + pass + ": " + value, e);
                    return;
                }
                this.alphaTestOverrides.put(pass, (Object)new AlphaTest(function.get(), reference));
            });
            ShaderProperties.handlePassDirective("blend.", key, value, pass -> {
                if (pass.contains(".")) {
                    if (!IrisRenderSystem.supportsBufferBlending()) {
                        throw new RuntimeException("Buffer blending is not supported on this platform, however it was attempted to be used!");
                    }
                    String[] parts = pass.split("\\.");
                    int index = PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.indexOf((Object)parts[1]);
                    if (index == -1 && parts[1].startsWith("colortex")) {
                        String id = parts[1].substring("colortex".length());
                        try {
                            index = Integer.parseInt(id);
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException("Failed to parse buffer blend!", e);
                        }
                    }
                    if (index == -1) {
                        throw new RuntimeException("Failed to parse buffer blend! index = " + index);
                    }
                    if ("off".equals(value)) {
                        ((ArrayList)this.bufferBlendOverrides.computeIfAbsent((Object)parts[0], list -> new ArrayList())).add(new BufferBlendInformation(index, null));
                        return;
                    }
                    String[] modeArray = value.split(" ");
                    int[] modes = new int[modeArray.length];
                    int i = 0;
                    for (String modeName : modeArray) {
                        modes[i] = BlendModeFunction.fromString(modeName).get().getGlId();
                        ++i;
                    }
                    ((ArrayList)this.bufferBlendOverrides.computeIfAbsent((Object)parts[0], list -> new ArrayList())).add(new BufferBlendInformation(index, new BlendMode(modes[0], modes[1], modes[2], modes[3])));
                    return;
                }
                if ("off".equals(value)) {
                    this.blendModeOverrides.put(pass, (Object)BlendModeOverride.OFF);
                    return;
                }
                String[] modeArray = value.split(" ");
                int[] modes = new int[modeArray.length];
                int i = 0;
                for (String modeName : modeArray) {
                    modes[i] = BlendModeFunction.fromString(modeName).get().getGlId();
                    ++i;
                }
                this.blendModeOverrides.put(pass, (Object)new BlendModeOverride(new BlendMode(modes[0], modes[1], modes[2], modes[3])));
            });
            ShaderProperties.handleProgramEnabledDirective("program.", key, value, program -> this.conditionallyEnabledPrograms.put(program, (Object)value));
            ShaderProperties.handleTwoArgDirective("texture.", key, value, (stageName, samplerName) -> {
                String[] parts = value.split(" ");
                if (parts.length > 1) {
                    Iris.logger.warn("Custom texture directive for stage " + stageName + ", sampler " + samplerName + " contains more parts than we expected: " + value);
                    return;
                }
                Optional<TextureStage> optionalTextureStage = TextureStage.parse(stageName);
                if (!optionalTextureStage.isPresent()) {
                    Iris.logger.warn("Unknown texture stage \"" + stageName + "\", ignoring custom texture directive for " + key);
                    return;
                }
                TextureStage stage = optionalTextureStage.get();
                this.customTextures.computeIfAbsent(stage, _stage -> new Object2ObjectOpenHashMap()).put(samplerName, (Object)value);
            });
            ShaderProperties.handleTwoArgDirective("flip.", key, value, (pass, buffer) -> ShaderProperties.handleBooleanValue(key, value, shouldFlip -> ((Object2BooleanMap)this.explicitFlips.computeIfAbsent(pass, _pass -> new Object2BooleanOpenHashMap())).put(buffer, shouldFlip)));
            ShaderProperties.handleWhitespacedListDirective(key, value, "iris.features.required", options -> {
                this.requiredFeatureFlags = options;
            });
            ShaderProperties.handleWhitespacedListDirective(key, value, "iris.features.optional", options -> {
                this.optionalFeatureFlags = options;
            });
        }));
        ((Properties)original).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(keyObject, valueObject) -> {
            String key = (String)keyObject;
            String value = (String)valueObject;
            ShaderProperties.handleWhitespacedListDirective(key, value, "sliders", sliders -> {
                this.sliderOptions = sliders;
            });
            ShaderProperties.handlePrefixedWhitespacedListDirective("profile.", key, value, this.profiles::put);
            if (ShaderProperties.handleIntDirective(key, value, "screen.columns", columns -> {
                this.mainScreenColumnCount = columns;
            })) {
                return;
            }
            if (ShaderProperties.handleAffixedIntDirective("screen.", ".columns", key, value, this.subScreenColumnCount::put)) {
                return;
            }
            ShaderProperties.handleWhitespacedListDirective(key, value, "screen", options -> {
                this.mainScreenOptions = options;
            });
            ShaderProperties.handlePrefixedWhitespacedListDirective("screen.", key, value, this.subScreenOptions::put);
        }));
    }

    private static void handleBooleanValue(String key, String value, BooleanConsumer handler) {
        if ("true".equals(value)) {
            handler.accept(true);
        } else if ("false".equals(value)) {
            handler.accept(false);
        } else {
            Iris.logger.warn("Unexpected value for boolean key " + key + " in shaders.properties: got " + value + ", but expected either true or false");
        }
    }

    private static void handleBooleanDirective(String key, String value, String expectedKey, Consumer<OptionalBoolean> handler) {
        if (!expectedKey.equals(key)) {
            return;
        }
        if ("true".equals(value)) {
            handler.accept(OptionalBoolean.TRUE);
        } else if ("false".equals(value)) {
            handler.accept(OptionalBoolean.FALSE);
        } else {
            Iris.logger.warn("Unexpected value for boolean key " + key + " in shaders.properties: got " + value + ", but expected either true or false");
        }
    }

    private static boolean handleIntDirective(String key, String value, String expectedKey, Consumer<Integer> handler) {
        if (!expectedKey.equals(key)) {
            return false;
        }
        try {
            int result = Integer.parseInt(value);
            handler.accept(result);
        }
        catch (NumberFormatException nex) {
            Iris.logger.warn("Unexpected value for integer key " + key + " in shaders.properties: got " + value + ", but expected an integer");
        }
        return true;
    }

    private static boolean handleAffixedIntDirective(String prefix, String suffix, String key, String value, BiConsumer<String, Integer> handler) {
        if (key.startsWith(prefix) && key.endsWith(suffix)) {
            int substrBegin = prefix.length();
            int substrEnd = key.length() - suffix.length();
            if (substrEnd <= substrBegin) {
                return false;
            }
            String affixStrippedKey = key.substring(substrBegin, substrEnd);
            try {
                int result = Integer.parseInt(value);
                handler.accept(affixStrippedKey, result);
            }
            catch (NumberFormatException nex) {
                Iris.logger.warn("Unexpected value for integer key " + key + " in shaders.properties: got " + value + ", but expected an integer");
            }
            return true;
        }
        return false;
    }

    private static void handlePassDirective(String prefix, String key, String value, Consumer<String> handler) {
        if (key.startsWith(prefix)) {
            String pass = key.substring(prefix.length());
            handler.accept(pass);
        }
    }

    private static void handleProgramEnabledDirective(String prefix, String key, String value, Consumer<String> handler) {
        if (key.startsWith(prefix)) {
            String program = key.substring(prefix.length(), key.indexOf(".", prefix.length()));
            handler.accept(program);
        }
    }

    private static void handleWhitespacedListDirective(String key, String value, String expectedKey, Consumer<List<String>> handler) {
        if (!expectedKey.equals(key)) {
            return;
        }
        String[] elements = value.split(" +");
        handler.accept(Arrays.asList(elements));
    }

    private static void handlePrefixedWhitespacedListDirective(String prefix, String key, String value, BiConsumer<String, List<String>> handler) {
        if (key.startsWith(prefix)) {
            String prefixStrippedKey = key.substring(prefix.length());
            String[] elements = value.split(" +");
            handler.accept(prefixStrippedKey, Arrays.asList(elements));
        }
    }

    private static void handleTwoArgDirective(String prefix, String key, String value, BiConsumer<String, String> handler) {
        if (key.startsWith(prefix)) {
            int endOfPassIndex = key.indexOf(".", prefix.length());
            String stage = key.substring(prefix.length(), endOfPassIndex);
            String sampler = key.substring(endOfPassIndex + 1);
            handler.accept(stage, sampler);
        }
    }

    public static ShaderProperties empty() {
        return new ShaderProperties();
    }

    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }

    public OptionalBoolean getOldHandLight() {
        return this.oldHandLight;
    }

    public OptionalBoolean getDynamicHandLight() {
        return this.dynamicHandLight;
    }

    public OptionalBoolean getOldLighting() {
        return this.oldLighting;
    }

    public OptionalBoolean getShadowTerrain() {
        return this.shadowTerrain;
    }

    public OptionalBoolean getShadowTranslucent() {
        return this.shadowTranslucent;
    }

    public OptionalBoolean getShadowEntities() {
        return this.shadowEntities;
    }

    public OptionalBoolean getShadowPlayer() {
        return this.shadowPlayer;
    }

    public OptionalBoolean getShadowBlockEntities() {
        return this.shadowBlockEntities;
    }

    public OptionalBoolean getUnderwaterOverlay() {
        return this.underwaterOverlay;
    }

    public OptionalBoolean getSun() {
        return this.sun;
    }

    public OptionalBoolean getMoon() {
        return this.moon;
    }

    public OptionalBoolean getVignette() {
        return this.vignette;
    }

    public OptionalBoolean getBackFaceSolid() {
        return this.backFaceSolid;
    }

    public OptionalBoolean getBackFaceCutout() {
        return this.backFaceCutout;
    }

    public OptionalBoolean getBackFaceCutoutMipped() {
        return this.backFaceCutoutMipped;
    }

    public OptionalBoolean getBackFaceTranslucent() {
        return this.backFaceTranslucent;
    }

    public OptionalBoolean getRainDepth() {
        return this.rainDepth;
    }

    public OptionalBoolean getBeaconBeamDepth() {
        return this.beaconBeamDepth;
    }

    public OptionalBoolean getSeparateAo() {
        return this.separateAo;
    }

    public OptionalBoolean getFrustumCulling() {
        return this.frustumCulling;
    }

    public OptionalBoolean getShadowCulling() {
        return this.shadowCulling;
    }

    public Object2ObjectMap<String, AlphaTest> getAlphaTestOverrides() {
        return this.alphaTestOverrides;
    }

    public OptionalBoolean getShadowEnabled() {
        return this.shadowEnabled;
    }

    public OptionalBoolean getParticlesBeforeDeferred() {
        return this.particlesBeforeDeferred;
    }

    public OptionalBoolean getConcurrentCompute() {
        return this.concurrentCompute;
    }

    public OptionalBoolean getPrepareBeforeShadow() {
        return this.prepareBeforeShadow;
    }

    public Object2FloatMap<String> getViewportScaleOverrides() {
        return this.viewportScaleOverrides;
    }

    public Object2ObjectMap<String, TextureScaleOverride> getTextureScaleOverrides() {
        return this.textureScaleOverrides;
    }

    public Object2ObjectMap<String, BlendModeOverride> getBlendModeOverrides() {
        return this.blendModeOverrides;
    }

    public Object2ObjectMap<String, ArrayList<BufferBlendInformation>> getBufferBlendOverrides() {
        return this.bufferBlendOverrides;
    }

    public EnumMap<TextureStage, Object2ObjectMap<String, String>> getCustomTextures() {
        return this.customTextures;
    }

    public Optional<String> getNoiseTexturePath() {
        return Optional.ofNullable(this.noiseTexturePath);
    }

    public Object2ObjectMap<String, String> getConditionallyEnabledPrograms() {
        return this.conditionallyEnabledPrograms;
    }

    public List<String> getSliderOptions() {
        return this.sliderOptions;
    }

    public Map<String, List<String>> getProfiles() {
        return this.profiles;
    }

    public Optional<List<String>> getMainScreenOptions() {
        return Optional.ofNullable(this.mainScreenOptions);
    }

    public Map<String, List<String>> getSubScreenOptions() {
        return this.subScreenOptions;
    }

    public Optional<Integer> getMainScreenColumnCount() {
        return Optional.ofNullable(this.mainScreenColumnCount);
    }

    public Map<String, Integer> getSubScreenColumnCount() {
        return this.subScreenColumnCount;
    }

    public Object2ObjectMap<String, Object2BooleanMap<String>> getExplicitFlips() {
        return this.explicitFlips;
    }

    public List<String> getRequiredFeatureFlags() {
        return this.requiredFeatureFlags;
    }

    public List<String> getOptionalFeatureFlags() {
        return this.optionalFeatureFlags;
    }
}

