/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.Profile;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.Version;
import io.github.douira.glsl_transformer.ast.node.VersionStatement;
import io.github.douira.glsl_transformer.ast.print.PrintType;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.transform.EnumASTTransformer;
import io.github.douira.glsl_transformer.cst.core.SemanticException;
import io.github.douira.glsl_transformer.cst.token_filter.ChannelFilter;
import io.github.douira.glsl_transformer.cst.token_filter.TokenChannel;
import io.github.douira.glsl_transformer.cst.token_filter.TokenFilter;
import io.github.douira.glsl_transformer.util.LRUCache;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.transform.AttributeParameters;
import net.coderbot.iris.pipeline.transform.AttributeTransformer;
import net.coderbot.iris.pipeline.transform.CommonTransformer;
import net.coderbot.iris.pipeline.transform.CompatibilityTransformer;
import net.coderbot.iris.pipeline.transform.CompositeParameters;
import net.coderbot.iris.pipeline.transform.CompositeTransformer;
import net.coderbot.iris.pipeline.transform.ComputeParameters;
import net.coderbot.iris.pipeline.transform.Parameters;
import net.coderbot.iris.pipeline.transform.Patch;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.SodiumParameters;
import net.coderbot.iris.pipeline.transform.SodiumTransformer;
import net.coderbot.iris.pipeline.transform.VanillaParameters;
import net.coderbot.iris.pipeline.transform.VanillaTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import repack.antlr.v4.runtime.RecognitionException;
import repack.antlr.v4.runtime.Token;

public class TransformPatcher {
    static Logger LOGGER = LogManager.getLogger(TransformPatcher.class);
    private static EnumASTTransformer<Parameters, PatchShaderType> transformer;
    private static final boolean useCache = true;
    private static final Map<CacheKey, Map<PatchShaderType, String>> cache;
    static TokenFilter<Parameters> parseTokenFilter;
    private static final Pattern versionPattern;

    private static Map<PatchShaderType, String> transform(String vertex, String geometry, String fragment, Parameters parameters) {
        if (vertex == null && geometry == null && fragment == null) {
            return null;
        }
        Map result = null;
        CacheKey key = new CacheKey(parameters, vertex, geometry, fragment);
        if (cache.containsKey(key)) {
            result = cache.get(key);
        }
        if (result == null) {
            transformer.setPrintType(PatchedShaderPrinter.prettyPrintShaders ? PrintType.INDENTED : PrintType.SIMPLE);
            EnumMap<PatchShaderType, String> inputs = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
            inputs.put(PatchShaderType.VERTEX, vertex);
            inputs.put(PatchShaderType.GEOMETRY, geometry);
            inputs.put(PatchShaderType.FRAGMENT, fragment);
            if (parameters instanceof SodiumParameters && ((SodiumParameters)parameters).hasCutoutAlpha()) {
                inputs.put(PatchShaderType.FRAGMENT_CUTOUT, fragment);
            }
            result = transformer.transform(inputs, parameters);
            cache.put(key, result);
        }
        return result;
    }

    private static Map<PatchShaderType, String> transformCompute(String compute, Parameters parameters) {
        if (compute == null) {
            return null;
        }
        Map result = null;
        CacheKey key = new CacheKey(parameters, compute);
        if (cache.containsKey(key)) {
            result = cache.get(key);
        }
        if (result == null) {
            transformer.setPrintType(PatchedShaderPrinter.prettyPrintShaders ? PrintType.INDENTED : PrintType.SIMPLE);
            EnumMap<PatchShaderType, String> inputs = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
            inputs.put(PatchShaderType.COMPUTE, compute);
            result = transformer.transform(inputs, parameters);
            cache.put(key, result);
        }
        return result;
    }

    public static Map<PatchShaderType, String> patchAttributes(String vertex, String geometry, String fragment, InputAvailability inputs) {
        return TransformPatcher.transform(vertex, geometry, fragment, new AttributeParameters(Patch.ATTRIBUTES, geometry != null, inputs));
    }

    public static Map<PatchShaderType, String> patchVanilla(String vertex, String geometry, String fragment, AlphaTest alpha, boolean hasChunkOffset, ShaderAttributeInputs inputs) {
        return TransformPatcher.transform(vertex, geometry, fragment, new VanillaParameters(Patch.VANILLA, alpha, hasChunkOffset, inputs, geometry != null));
    }

    public static Map<PatchShaderType, String> patchSodium(String vertex, String geometry, String fragment, AlphaTest cutoutAlpha, AlphaTest defaultAlpha, ShaderAttributeInputs inputs, float positionScale, float positionOffset, float textureScale) {
        return TransformPatcher.transform(vertex, geometry, fragment, new SodiumParameters(Patch.SODIUM, cutoutAlpha, defaultAlpha, inputs, positionScale, positionOffset, textureScale));
    }

    public static Map<PatchShaderType, String> patchComposite(String vertex, String geometry, String fragment) {
        return TransformPatcher.transform(vertex, geometry, fragment, new CompositeParameters(Patch.COMPOSITE));
    }

    public static String patchCompute(String compute) {
        return TransformPatcher.transformCompute(compute, new ComputeParameters(Patch.COMPUTE)).getOrDefault((Object)PatchShaderType.COMPUTE, null);
    }

    static {
        cache = new LRUCache<CacheKey, Map<PatchShaderType, String>>(400);
        parseTokenFilter = new ChannelFilter<Parameters>(TokenChannel.PREPROCESSOR){

            @Override
            public boolean isTokenAllowed(Token token) {
                if (!super.isTokenAllowed(token)) {
                    throw new SemanticException("Unparsed preprocessor directives such as '" + token.getText() + "' may not be present at this stage of shader processing!");
                }
                return true;
            }
        };
        transformer = new EnumASTTransformer<Parameters, PatchShaderType>(PatchShaderType.class){

            @Override
            public TranslationUnit parseTranslationUnit(String input) throws RecognitionException {
                Matcher matcher = versionPattern.matcher(input);
                if (!matcher.find()) {
                    throw new IllegalArgumentException("No #version directive found in source code! See debugging.md for more information.");
                }
                Version version = Version.fromNumber(Integer.parseInt(matcher.group(1)));
                if (version.number >= 200) {
                    version = Version.GLSL33;
                }
                TransformPatcher.transformer.getLexer().version = version;
                return super.parseTranslationUnit(input);
            }
        };
        transformer.setTransformation((trees, parameters) -> {
            for (PatchShaderType type : PatchShaderType.values()) {
                TranslationUnit tree = (TranslationUnit)trees.get((Object)type);
                if (tree == null) continue;
                parameters.type = type;
                Root root = tree.getRoot();
                Optional<Identifier> violation = root.identifierIndex.prefixQueryFlat("iris_").findAny();
                if (!violation.isPresent()) {
                    violation = root.identifierIndex.prefixQueryFlat("irisMain").findAny();
                }
                if (!violation.isPresent()) {
                    violation = root.identifierIndex.prefixQueryFlat("moj_import").findAny();
                }
                violation.ifPresent(id -> {
                    throw new SemanticException("Detected a potential reference to unstable and internal Iris shader interfaces (iris_, irisMain and moj_import). This isn't currently supported. Violation: " + id.getName() + ". See debugging.md for more information.");
                });
                Root.indexBuildSession(tree, () -> {
                    VersionStatement versionStatement = tree.getVersionStatement();
                    if (versionStatement == null) {
                        throw new IllegalStateException("Missing the version statement!");
                    }
                    Profile profile = versionStatement.profile;
                    Version version = versionStatement.version;
                    block0 : switch (parameters.patch) {
                        case ATTRIBUTES: {
                            AttributeTransformer.transform(transformer, tree, root, (AttributeParameters)parameters);
                            break;
                        }
                        case COMPUTE: {
                            versionStatement.profile = Profile.CORE;
                            CommonTransformer.transform(transformer, tree, root, parameters);
                            break;
                        }
                        default: {
                            if (profile == Profile.CORE || version.number >= 150 && profile == null) {
                                if (parameters.type != PatchShaderType.VERTEX) break;
                                throw new IllegalStateException("Vertex shaders with existing core profile found, aborting this part of patching. (Compatibility patches are applied nonetheless) See debugging.md for more information.");
                            }
                            if (version.number >= 330) {
                                if (profile != Profile.COMPATIBILITY) {
                                    throw new IllegalStateException("Expected \"compatibility\" after the GLSL version: #version " + version + " " + profile + ". See debugging.md for more information.");
                                }
                                versionStatement.profile = Profile.CORE;
                            } else {
                                versionStatement.version = Version.GLSL33;
                                versionStatement.profile = Profile.CORE;
                            }
                            switch (parameters.patch) {
                                case COMPOSITE: {
                                    CompositeTransformer.transform(transformer, tree, root, parameters);
                                    break block0;
                                }
                                case SODIUM: {
                                    SodiumParameters sodiumParameters = (SodiumParameters)parameters;
                                    sodiumParameters.setAlphaFor(type);
                                    SodiumTransformer.transform(transformer, tree, root, sodiumParameters);
                                    break block0;
                                }
                                case VANILLA: {
                                    VanillaTransformer.transform(transformer, tree, root, (VanillaParameters)parameters);
                                    break block0;
                                }
                            }
                            throw new UnsupportedOperationException("Unknown patch type: " + parameters.patch);
                        }
                    }
                    CompatibilityTransformer.transformEach(transformer, tree, root, parameters);
                });
            }
            CompatibilityTransformer.transformGrouped(transformer, trees, parameters);
        });
        transformer.setParseTokenFilter(parseTokenFilter);
        versionPattern = Pattern.compile("^.*#version\\s+(\\d+)", 32);
    }

    private static class CacheKey {
        final Parameters parameters;
        final String vertex;
        final String geometry;
        final String fragment;
        final String compute;

        public CacheKey(Parameters parameters, String vertex, String geometry, String fragment) {
            this.parameters = parameters;
            this.vertex = vertex;
            this.geometry = geometry;
            this.fragment = fragment;
            this.compute = null;
        }

        public CacheKey(Parameters parameters, String compute) {
            this.parameters = parameters;
            this.vertex = null;
            this.geometry = null;
            this.fragment = null;
            this.compute = compute;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
            result = 31 * result + (this.vertex == null ? 0 : this.vertex.hashCode());
            result = 31 * result + (this.geometry == null ? 0 : this.geometry.hashCode());
            result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
            result = 31 * result + (this.compute == null ? 0 : this.compute.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
                return false;
            }
            if (this.vertex == null ? other.vertex != null : !this.vertex.equals(other.vertex)) {
                return false;
            }
            if (this.geometry == null ? other.geometry != null : !this.geometry.equals(other.geometry)) {
                return false;
            }
            if (this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment)) {
                return false;
            }
            return !(this.compute == null ? other.compute != null : !this.compute.equals(other.compute));
        }
    }
}

