/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.DivisionExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.MultiplicationExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.MemberAccessExpression;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.match.Matcher;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import java.util.ArrayList;
import java.util.List;
import net.coderbot.iris.pipeline.transform.CommonTransformer;

class SodiumTerrainTransformer {
    private static final Matcher<Expression> glTextureMatrixMultMember = new Matcher<Expression>("(gl_TextureMatrix[1] * ___coord).___suffix", Matcher.expressionPattern, "___");
    private static final Matcher<Expression> glTextureMatrixMultS = new Matcher<Expression>("(gl_TextureMatrix[1] * ___coord).s", Matcher.expressionPattern, "___");
    private static final Matcher<Expression> glTextureMatrixMult = new Matcher<Expression>("gl_TextureMatrix[1] * ___coord", Matcher.expressionPattern, "___");
    private static final Matcher<Expression> xyDivision = new Matcher<Expression>("___coord.xy / 255.0", Matcher.expressionPattern, "___");
    private static final Matcher<Expression> xyDivision240 = new Matcher<Expression>("___coord.xy / 240.0", Matcher.expressionPattern, "___");
    private static final List<Expression> replaceExpressions = new ArrayList<Expression>();
    private static final List<Expression> replaceSExpressions = new ArrayList<Expression>();
    private static final List<Expression> replaceWrapExpressions = new ArrayList<Expression>();

    SodiumTerrainTransformer() {
    }

    private static void processCoord(Root root, String coord) {
        for (Identifier identifier : root.identifierIndex.get(coord)) {
            MemberAccessExpression memberAccess = identifier.getAncestor(MemberAccessExpression.class);
            if (memberAccess != null && glTextureMatrixMultMember.matchesExtract(memberAccess)) {
                String suffix = glTextureMatrixMultMember.getStringDataMatch("suffix");
                if (glTextureMatrixMultMember.getStringDataMatch("coord").equals(coord) && suffix != null && ("st".equals(suffix) || "xy".equals(suffix))) {
                    replaceExpressions.add(memberAccess);
                    return;
                }
            }
            if (memberAccess != null && glTextureMatrixMultS.matchesExtract(memberAccess) && glTextureMatrixMultS.getStringDataMatch("coord").equals(coord)) {
                replaceSExpressions.add(memberAccess);
                return;
            }
            DivisionExpression division = identifier.getAncestor(DivisionExpression.class);
            if (division != null && xyDivision.matchesExtract(division) && xyDivision.getStringDataMatch("coord").equals(coord)) {
                replaceExpressions.add(division);
                return;
            }
            if (division != null && xyDivision240.matchesExtract(division) && xyDivision240.getStringDataMatch("coord").equals(coord)) {
                replaceExpressions.add(division);
                return;
            }
            MultiplicationExpression mult = identifier.getAncestor(MultiplicationExpression.class);
            if (mult == null || !glTextureMatrixMult.matchesExtract(mult) || !glTextureMatrixMult.getStringDataMatch("coord").equals(coord)) continue;
            replaceWrapExpressions.add(mult);
            return;
        }
    }

    public static void replaceLightmapForSodium(String lightmapCoordsExpression, ASTParser t, TranslationUnit tree, Root root) {
        String lightmapCoordsExpressionS = lightmapCoordsExpression + ".s";
        String lightmapCoordsExpressionWrapped = "vec4(" + lightmapCoordsExpression + ", 0.0, 1.0)";
        replaceExpressions.clear();
        replaceSExpressions.clear();
        replaceWrapExpressions.clear();
        SodiumTerrainTransformer.processCoord(root, "gl_MultiTexCoord1");
        SodiumTerrainTransformer.processCoord(root, "gl_MultiTexCoord2");
        Root.replaceExpressionsConcurrent(t, replaceExpressions, lightmapCoordsExpression);
        Root.replaceExpressionsConcurrent(t, replaceSExpressions, lightmapCoordsExpressionS);
        Root.replaceExpressionsConcurrent(t, replaceWrapExpressions, lightmapCoordsExpressionWrapped);
        replaceExpressions.clear();
        replaceSExpressions.clear();
        replaceWrapExpressions.clear();
        root.replaceExpressionMatches(t, CommonTransformer.glTextureMatrix1, "iris_LightmapTextureMatrix");
        root.replaceReferenceExpressions(t, "gl_MultiTexCoord1", "vec4(" + lightmapCoordsExpression + " * 256.0 - 8.0, 0.0, 1.0)");
        root.replaceReferenceExpressions(t, "gl_MultiTexCoord2", "vec4(" + lightmapCoordsExpression + " * 256.0 - 8.0, 0.0, 1.0)");
        if (root.identifierIndex.has("iris_LightmapTextureMatrix")) {
            tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_LightmapTextureMatrix;");
        }
    }
}

