/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.transform.Parameters;
import net.coderbot.iris.pipeline.transform.Patch;
import net.coderbot.iris.pipeline.transform.PatchShaderType;

public class SodiumParameters
extends Parameters {
    private final AlphaTest cutoutAlpha;
    private final AlphaTest defaultAlpha;
    public final ShaderAttributeInputs inputs;
    public final float positionScale;
    public final float positionOffset;
    public final float textureScale;
    public AlphaTest alpha;

    public SodiumParameters(Patch patch, AlphaTest cutoutAlpha, AlphaTest defaultAlpha, ShaderAttributeInputs inputs, float positionScale, float positionOffset, float textureScale) {
        super(patch);
        this.cutoutAlpha = cutoutAlpha;
        this.defaultAlpha = defaultAlpha;
        this.inputs = inputs;
        this.positionScale = positionScale;
        this.positionOffset = positionOffset;
        this.textureScale = textureScale;
        this.alpha = defaultAlpha;
    }

    public void setAlphaFor(PatchShaderType type) {
        this.alpha = type == PatchShaderType.FRAGMENT_CUTOUT ? this.cutoutAlpha : this.defaultAlpha;
    }

    public boolean hasCutoutAlpha() {
        return this.cutoutAlpha != null;
    }

    @Override
    public AlphaTest getAlphaTest() {
        return this.alpha;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.defaultAlpha == null ? 0 : this.defaultAlpha.hashCode());
        result = 31 * result + (this.cutoutAlpha == null ? 0 : this.cutoutAlpha.hashCode());
        result = 31 * result + (this.inputs == null ? 0 : this.inputs.hashCode());
        result = 31 * result + Float.floatToIntBits(this.positionOffset);
        result = 31 * result + Float.floatToIntBits(this.positionScale);
        result = 31 * result + Float.floatToIntBits(this.textureScale);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SodiumParameters other = (SodiumParameters)obj;
        if (this.defaultAlpha == null ? other.defaultAlpha != null : !this.defaultAlpha.equals(other.defaultAlpha)) {
            return false;
        }
        if (this.cutoutAlpha == null ? other.cutoutAlpha != null : !this.cutoutAlpha.equals(other.cutoutAlpha)) {
            return false;
        }
        if (this.inputs == null ? other.inputs != null : !this.inputs.equals(other.inputs)) {
            return false;
        }
        if (Float.floatToIntBits(this.positionOffset) != Float.floatToIntBits(other.positionOffset)) {
            return false;
        }
        if (Float.floatToIntBits(this.positionScale) != Float.floatToIntBits(other.positionScale)) {
            return false;
        }
        return Float.floatToIntBits(this.textureScale) == Float.floatToIntBits(other.textureScale);
    }
}

