/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.node.declaration.DeclarationMember;
import io.github.douira.glsl_transformer.ast.node.declaration.TypeAndInitDeclaration;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.expression.LiteralExpression;
import io.github.douira.glsl_transformer.ast.node.expression.ReferenceExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.ArrayAccessExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.FunctionCallExpression;
import io.github.douira.glsl_transformer.ast.node.external_declaration.DeclarationExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.StorageQualifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinFixedTypeSpecifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.TypeSpecifier;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.match.AutoHintedMatcher;
import io.github.douira.glsl_transformer.ast.query.match.Matcher;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import io.github.douira.glsl_transformer.ast.transform.Template;
import io.github.douira.glsl_transformer.util.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.transform.Parameters;

public class CommonTransformer {
    public static final AutoHintedMatcher<Expression> glTextureMatrix0 = new AutoHintedMatcher<Expression>("gl_TextureMatrix[0]", Matcher.expressionPattern);
    public static final AutoHintedMatcher<Expression> glTextureMatrix1 = new AutoHintedMatcher<Expression>("gl_TextureMatrix[1]", Matcher.expressionPattern);
    public static final AutoHintedMatcher<ExternalDeclaration> sampler = new AutoHintedMatcher<ExternalDeclaration>("uniform Type name;", Matcher.externalDeclarationPattern, "__"){
        {
            this.markClassedPredicateWildcard("type", ((ExternalDeclaration)this.pattern).getRoot().identifierIndex.getOne("Type").getAncestor(TypeSpecifier.class), BuiltinFixedTypeSpecifier.class, specifier -> specifier.type.kind == BuiltinFixedTypeSpecifier.BuiltinType.TypeKind.SAMPLER);
            this.markClassWildcard("name*", ((ExternalDeclaration)this.pattern).getRoot().identifierIndex.getOne("name").getAncestor(DeclarationMember.class));
        }
    };
    private static final AutoHintedMatcher<Expression> glFragDataI = new AutoHintedMatcher<Expression>("gl_FragData[index]", Matcher.expressionPattern){
        {
            this.markClassedPredicateWildcard("index", ((Expression)this.pattern).getRoot().identifierIndex.getOne("index").getAncestor(ReferenceExpression.class), LiteralExpression.class, literalExpression -> literalExpression.isInteger() && literalExpression.getInteger() >= 0L);
        }
    };
    private static final Template<ExternalDeclaration> fragDataDeclaration = Template.withExternalDeclaration("layout (location = __index) out vec4 __name;");
    private static final List<Expression> replaceExpressions;
    private static final List<Long> replaceIndexes;

    private static void renameFunctionCall(Root root, String oldName, String newName) {
        root.process(root.identifierIndex.getStream(oldName).filter(id -> id.getParent() instanceof FunctionCallExpression), id -> id.setName(newName));
    }

    private static void renameAndWrapShadow(ASTParser t, Root root, String oldName, String innerName) {
        root.process(root.identifierIndex.getStream(oldName).filter(id -> id.getParent() instanceof FunctionCallExpression), id -> {
            FunctionCallExpression functionCall = (FunctionCallExpression)id.getParent();
            functionCall.getFunctionName().setName(innerName);
            FunctionCallExpression wrapper = (FunctionCallExpression)t.parseExpression((ASTNode)id, "vec4()");
            functionCall.replaceBy(wrapper);
            wrapper.getParameters().add(functionCall);
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void transform(ASTParser t, TranslationUnit tree, Root root, Parameters parameters) {
        root.rename("gl_FogFragCoord", "iris_FogFragCoord");
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "out float iris_FogFragCoord;");
        } else if (parameters.type.glShaderType == ShaderType.FRAGMENT) {
            tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "in float iris_FogFragCoord;");
        }
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "vec4 iris_FrontColor;");
            root.rename("gl_FrontColor", "iris_FrontColor");
        }
        if (parameters.type.glShaderType == ShaderType.FRAGMENT) {
            void var5_7;
            if (root.identifierIndex.has("gl_FragColor")) {
                Iris.logger.warn("[Patcher] gl_FragColor is not supported yet, please use gl_FragData! Assuming that the shaderpack author intended to use gl_FragData[0]...");
                root.replaceReferenceExpressions(t, "gl_FragColor", "gl_FragData[0]");
            }
            replaceExpressions.clear();
            replaceIndexes.clear();
            HashSet replaceIndexesSet = new HashSet();
            for (Identifier id2 : root.identifierIndex.get("gl_FragData")) {
                ArrayAccessExpression accessExpression = id2.getAncestor(ArrayAccessExpression.class);
                if (accessExpression == null || !glFragDataI.matchesExtract(accessExpression)) continue;
                replaceExpressions.add(accessExpression);
                long index = glFragDataI.getNodeMatch("index", LiteralExpression.class).getInteger();
                replaceIndexes.add(index);
                replaceIndexesSet.add(index);
            }
            boolean bl = false;
            while (var5_7 < replaceExpressions.size()) {
                replaceExpressions.get((int)var5_7).replaceByAndDelete(new ReferenceExpression(new Identifier("iris_FragData" + replaceIndexes.get((int)var5_7))));
                ++var5_7;
            }
            Iterator iterator = replaceIndexesSet.iterator();
            while (iterator.hasNext()) {
                long index = (Long)iterator.next();
                tree.injectNode(ASTInjectionPoint.BEFORE_DECLARATIONS, fragDataDeclaration.getInstanceFor((ASTNode)tree, new LiteralExpression(Type.INT32, index), new Identifier("iris_FragData" + index)));
            }
            replaceExpressions.clear();
            replaceIndexes.clear();
            if (parameters.getAlphaTest() != AlphaTest.ALWAYS && replaceIndexesSet.contains(0L)) {
                tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform float iris_currentAlphaTest;");
                tree.appendMain(t, parameters.getAlphaTest().toExpression("iris_FragData0.a", "iris_currentAlphaTest", "\t"));
            }
        }
        if (parameters.type.glShaderType == ShaderType.VERTEX || parameters.type.glShaderType == ShaderType.FRAGMENT) {
            for (StorageQualifier storageQualifier : root.nodeIndex.get(StorageQualifier.class)) {
                if (storageQualifier.storageType == StorageQualifier.StorageType.ATTRIBUTE) {
                    storageQualifier.storageType = StorageQualifier.StorageType.IN;
                    continue;
                }
                if (storageQualifier.storageType != StorageQualifier.StorageType.VARYING) continue;
                storageQualifier.storageType = parameters.type.glShaderType == ShaderType.VERTEX ? StorageQualifier.StorageType.OUT : StorageQualifier.StorageType.IN;
            }
        }
        RenameTargetResult gcolorResult = CommonTransformer.getGtextureRenameTargets("gcolor", root);
        RenameTargetResult renameTargetResult = CommonTransformer.getGtextureRenameTargets("texture", root);
        DeclarationMember samplerDeclarationMember = null;
        Stream<Identifier> targets = Stream.empty();
        if (gcolorResult != null) {
            samplerDeclarationMember = gcolorResult.samplerDeclarationMember;
            targets = Stream.concat(targets, gcolorResult.targets);
        }
        if (renameTargetResult != null) {
            if (samplerDeclarationMember == null) {
                samplerDeclarationMember = renameTargetResult.samplerDeclarationMember;
            } else {
                DeclarationMember secondDeclarationMember = renameTargetResult.samplerDeclarationMember;
                if (((TypeAndInitDeclaration)secondDeclarationMember.getParent()).getMembers().size() == 1) {
                    renameTargetResult.samplerDeclaration.detachAndDelete();
                } else {
                    secondDeclarationMember.detachAndDelete();
                }
            }
            targets = Stream.concat(targets, renameTargetResult.targets);
        }
        if (samplerDeclarationMember != null) {
            samplerDeclarationMember.getName().setName("gtexture");
        }
        root.process(targets.filter(id -> !(id.getParent() instanceof FunctionCallExpression)), id -> id.setName("gtexture"));
        root.rename("gl_Fog", "iris_Fog");
        tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform float iris_FogDensity;", "uniform float iris_FogStart;", "uniform float iris_FogEnd;", "uniform vec4 iris_FogColor;", "struct iris_FogParameters {vec4 color;float density;float start;float end;float scale;};", "iris_FogParameters iris_Fog = iris_FogParameters(iris_FogColor, iris_FogDensity, iris_FogStart, iris_FogEnd, 1.0 / (iris_FogEnd - iris_FogStart));");
        CommonTransformer.renameFunctionCall(root, "texture2D", "texture");
        CommonTransformer.renameFunctionCall(root, "texture3D", "texture");
        CommonTransformer.renameFunctionCall(root, "texture2DLod", "textureLod");
        CommonTransformer.renameFunctionCall(root, "texture3DLod", "textureLod");
        CommonTransformer.renameFunctionCall(root, "texture2DGrad", "textureGrad");
        CommonTransformer.renameFunctionCall(root, "texture2DGradARB", "textureGrad");
        CommonTransformer.renameFunctionCall(root, "texture3DGrad", "textureGrad");
        CommonTransformer.renameFunctionCall(root, "texelFetch2D", "texelFetch");
        CommonTransformer.renameFunctionCall(root, "texelFetch3D", "texelFetch");
        CommonTransformer.renameFunctionCall(root, "textureSize2D", "textureSize");
        CommonTransformer.renameAndWrapShadow(t, root, "shadow2D", "texture");
        CommonTransformer.renameAndWrapShadow(t, root, "shadow2DLod", "textureLod");
    }

    private static RenameTargetResult getGtextureRenameTargets(String name, Root root) {
        ArrayList<Identifier> gtextureTargets = new ArrayList<Identifier>();
        DeclarationExternalDeclaration samplerDeclaration = null;
        DeclarationMember samplerDeclarationMember = null;
        for (Identifier id : root.identifierIndex.get(name)) {
            DeclarationExternalDeclaration externalDeclaration;
            gtextureTargets.add(id);
            if (samplerDeclaration != null || (externalDeclaration = (DeclarationExternalDeclaration)id.getAncestor(3, 0, DeclarationExternalDeclaration.class::isInstance)) == null) continue;
            if (sampler.matchesExtract(externalDeclaration)) {
                boolean foundNameMatch = false;
                for (DeclarationMember member : sampler.getNodeMatch("name*", DeclarationMember.class).getAncestor(TypeAndInitDeclaration.class).getMembers()) {
                    if (!member.getName().getName().equals(name)) continue;
                    foundNameMatch = true;
                }
                if (!foundNameMatch) {
                    return null;
                }
                samplerDeclaration = externalDeclaration;
                samplerDeclarationMember = id.getAncestor(DeclarationMember.class);
                gtextureTargets.remove(gtextureTargets.size() - 1);
                continue;
            }
            return null;
        }
        if (samplerDeclaration == null) {
            return null;
        }
        return new RenameTargetResult(samplerDeclaration, samplerDeclarationMember, gtextureTargets.stream());
    }

    public static void applyIntelHd4000Workaround(Root root) {
        root.rename("ftransform", "iris_ftransform");
    }

    public static void replaceGlMultiTexCoordBounded(ASTParser t, Root root, int minimum, int maximum) {
        root.replaceReferenceExpressions(t, root.identifierIndex.prefixQueryFlat("gl_MultiTexCoord").filter(id -> {
            int index = Integer.parseInt(id.getName().substring("gl_MultiTexCoord".length()));
            return index >= minimum && index <= maximum;
        }), "vec4(0.0, 0.0, 0.0, 1.0)");
    }

    static {
        fragDataDeclaration.markLocalReplacement("__index", ReferenceExpression.class);
        fragDataDeclaration.markIdentifierReplacement("__name");
        replaceExpressions = new ArrayList<Expression>();
        replaceIndexes = new ArrayList<Long>();
    }

    private static class RenameTargetResult {
        public final DeclarationExternalDeclaration samplerDeclaration;
        public final DeclarationMember samplerDeclarationMember;
        public final Stream<Identifier> targets;

        public RenameTargetResult(DeclarationExternalDeclaration samplerDeclaration, DeclarationMember samplerDeclarationMember, Stream<Identifier> targets) {
            this.samplerDeclaration = samplerDeclaration;
            this.samplerDeclarationMember = samplerDeclarationMember;
            this.targets = targets;
        }
    }
}

