/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import io.github.douira.glsl_transformer.ast.node.Profile;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.match.AutoHintedMatcher;
import io.github.douira.glsl_transformer.ast.query.match.Matcher;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import java.util.stream.Stream;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.transform.AttributeParameters;
import net.coderbot.iris.pipeline.transform.OverlayParameters;
import net.coderbot.iris.pipeline.transform.Parameters;
import net.coderbot.iris.pipeline.transform.PatchShaderType;

class AttributeTransformer {
    private static final AutoHintedMatcher<ExternalDeclaration> uniformVec4EntityColor = new AutoHintedMatcher<ExternalDeclaration>("uniform vec4 entityColor;", Matcher.externalDeclarationPattern);

    AttributeTransformer() {
    }

    public static void transform(ASTParser t, TranslationUnit tree, Root root, AttributeParameters parameters) {
        boolean isCore;
        boolean bl = isCore = tree.getVersionStatement().profile == Profile.CORE || tree.getVersionStatement().profile == null && tree.getVersionStatement().version.number > 140;
        if (isCore) {
            if (parameters.type == PatchShaderType.VERTEX) {
                throw new IllegalStateException("Vertex shaders must be in the compatibility profile to run properly!");
            }
            return;
        }
        if (parameters.inputs.lightmap) {
            root.rename("gl_MultiTexCoord1", "gl_MultiTexCoord2");
        }
        Stream<Object> stream = Stream.empty();
        boolean hasItems = false;
        if (!parameters.inputs.lightmap) {
            stream = Stream.concat(stream, root.identifierIndex.getStream("gl_MultiTexCoord1"));
            stream = Stream.concat(stream, root.identifierIndex.getStream("gl_MultiTexCoord2"));
            hasItems = true;
        }
        if (!parameters.inputs.texture) {
            stream = Stream.concat(stream, root.identifierIndex.getStream("gl_MultiTexCoord0"));
            hasItems = true;
        }
        if (hasItems) {
            root.replaceReferenceExpressions(t, stream, "vec4(240.0, 240.0, 0.0, 1.0)");
        }
        AttributeTransformer.patchTextureMatrices(t, tree, root, parameters.inputs.lightmap);
        if (parameters.inputs.overlay) {
            AttributeTransformer.patchOverlayColor(t, tree, root, parameters);
        }
        AttributeTransformer.patchMultiTexCoord3(t, tree, root, parameters);
    }

    public static void patchMultiTexCoord3(ASTParser t, TranslationUnit tree, Root root, Parameters parameters) {
        if (parameters.type.glShaderType == ShaderType.VERTEX && root.identifierIndex.has("gl_MultiTexCoord3") && !root.identifierIndex.has("mc_midTexCoord")) {
            root.rename("gl_MultiTexCoord3", "mc_midTexCoord");
            tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "attribute vec4 mc_midTexCoord;");
        }
    }

    private static void patchTextureMatrices(ASTParser t, TranslationUnit tree, Root root, boolean hasLightmap) {
        root.rename("gl_TextureMatrix", "iris_TextureMatrix");
        tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "const float iris_ONE_OVER_256 = 0.00390625;", "const float iris_ONE_OVER_32 = iris_ONE_OVER_256 * 8;");
        if (hasLightmap) {
            tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "mat4 iris_LightmapTextureMatrix = gl_TextureMatrix[2];");
        } else {
            tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "mat4 iris_LightmapTextureMatrix =mat4(iris_ONE_OVER_256, 0.0, 0.0, 0.0,     0.0, iris_ONE_OVER_256, 0.0, 0.0,     0.0, 0.0, iris_ONE_OVER_256, 0.0,     iris_ONE_OVER_32, iris_ONE_OVER_32, iris_ONE_OVER_32, iris_ONE_OVER_256);");
        }
        tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "mat4 iris_TextureMatrix[8] = mat4[8](gl_TextureMatrix[0],iris_LightmapTextureMatrix,mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0));");
    }

    public static void patchOverlayColor(ASTParser t, TranslationUnit tree, Root root, OverlayParameters parameters) {
        root.processMatches(t, uniformVec4EntityColor, ASTNode::detachAndDelete);
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform sampler2D iris_overlay;", "out vec4 entityColor;", "out vec4 iris_vertexColor;", "in ivec2 iris_UV1;");
            tree.prependMain(t, "vec4 overlayColor = texelFetch(iris_overlay, iris_UV1, 0);", "entityColor = vec4(overlayColor.rgb, 1.0 - overlayColor.a);", "iris_vertexColor = iris_Color;", "entityColor.rgb *= float(entityColor.a != 0.0);");
        } else if (parameters.type.glShaderType == ShaderType.GEOMETRY) {
            root.replaceReferenceExpressions(t, "entityColor", "entityColor[0]");
            tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "out vec4 entityColorGS;", "in vec4 entityColor[];", "out vec4 iris_vertexColorGS;", "in vec4 iris_vertexColor[];");
            tree.prependMain(t, "entityColorGS = entityColor[0];", "iris_vertexColorGS = iris_vertexColor[0];");
        } else if (parameters.type.glShaderType == ShaderType.FRAGMENT) {
            tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "in vec4 entityColor;", "in vec4 iris_vertexColor;");
            if (parameters.hasGeometry) {
                root.rename("entityColor", "entityColorGS");
                root.rename("iris_vertexColor", "iris_vertexColorGS");
            }
        }
    }
}

