/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader.fallback;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.List;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jetbrains.annotations.Nullable;

public class FallbackShader
extends ShaderInstance {
    private final NewWorldRenderingPipeline parent;
    private final BlendModeOverride blendModeOverride;
    private final GlFramebuffer writingToBeforeTranslucent;
    private final GlFramebuffer writingToAfterTranslucent;
    @Nullable
    private final Uniform FOG_DENSITY;
    @Nullable
    private final Uniform FOG_IS_EXP2;
    private final int gtexture;
    private final int overlay;
    private final int lightmap;

    public FallbackShader(ResourceProvider resourceFactory, String string, VertexFormat vertexFormat, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, BlendModeOverride blendModeOverride, float alphaValue, NewWorldRenderingPipeline parent) throws IOException {
        super(resourceFactory, string, vertexFormat);
        this.parent = parent;
        this.blendModeOverride = blendModeOverride;
        this.writingToBeforeTranslucent = writingToBeforeTranslucent;
        this.writingToAfterTranslucent = writingToAfterTranslucent;
        this.FOG_DENSITY = this.m_173348_("FogDensity");
        this.FOG_IS_EXP2 = this.m_173348_("FogIsExp2");
        this.gtexture = GlStateManager.m_84345_((int)this.m_142658_(), (CharSequence)"gtexture");
        this.overlay = GlStateManager.m_84345_((int)this.m_142658_(), (CharSequence)"overlay");
        this.lightmap = GlStateManager.m_84345_((int)this.m_142658_(), (CharSequence)"lightmap");
        Uniform ALPHA_TEST_VALUE = this.m_173348_("AlphaTestValue");
        if (ALPHA_TEST_VALUE != null) {
            ALPHA_TEST_VALUE.m_5985_(alphaValue);
        }
    }

    public void m_173362_() {
        super.m_173362_();
        if (this.blendModeOverride != null) {
            BlendModeOverride.restore();
        }
        Minecraft.m_91087_().m_91385_().m_83947_(false);
    }

    public void m_173363_() {
        if (this.FOG_DENSITY != null && this.FOG_IS_EXP2 != null) {
            float fogDensity = CapturedRenderingState.INSTANCE.getFogDensity();
            if ((double)fogDensity >= 0.0) {
                this.FOG_DENSITY.m_5985_(fogDensity);
                this.FOG_IS_EXP2.m_142617_(1);
            } else {
                this.FOG_DENSITY.m_5985_(0.0f);
                this.FOG_IS_EXP2.m_142617_(0);
            }
        }
        IrisRenderSystem.bindTextureToUnit(0, RenderSystem.m_157203_((int)0));
        IrisRenderSystem.bindTextureToUnit(1, RenderSystem.m_157203_((int)1));
        IrisRenderSystem.bindTextureToUnit(2, RenderSystem.m_157203_((int)2));
        ProgramManager.m_85578_((int)this.m_142658_());
        List uniformList = this.f_173331_;
        for (Uniform uniform : uniformList) {
            this.uploadIfNotNull(uniform);
        }
        GlStateManager.m_84467_((int)this.gtexture, (int)0);
        GlStateManager.m_84467_((int)this.overlay, (int)1);
        GlStateManager.m_84467_((int)this.lightmap, (int)2);
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        if (this.parent.isBeforeTranslucent) {
            this.writingToBeforeTranslucent.bind();
        } else {
            this.writingToAfterTranslucent.bind();
        }
    }

    private void uploadIfNotNull(Uniform uniform) {
        if (uniform != null) {
            uniform.m_85633_();
        }
    }
}

