/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderLoader;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.blending.BufferBlendOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.AlphaTests;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.builtin.BuiltinReplacementUniforms;
import net.minecraft.resources.ResourceLocation;

public class SodiumTerrainPipeline {
    Optional<String> terrainVertex;
    Optional<String> terrainGeometry;
    Optional<String> terrainFragment;
    Optional<String> terrainCutoutFragment;
    GlFramebuffer terrainFramebuffer;
    BlendModeOverride terrainBlendOverride;
    List<BufferBlendOverride> terrainBufferOverrides;
    Optional<AlphaTest> terrainCutoutAlpha;
    Optional<String> translucentVertex;
    Optional<String> translucentGeometry;
    Optional<String> translucentFragment;
    GlFramebuffer translucentFramebuffer;
    BlendModeOverride translucentBlendOverride;
    List<BufferBlendOverride> translucentBufferOverrides;
    Optional<AlphaTest> translucentAlpha;
    Optional<String> shadowVertex;
    Optional<String> shadowGeometry;
    Optional<String> shadowFragment;
    Optional<String> shadowCutoutFragment;
    GlFramebuffer shadowFramebuffer;
    BlendModeOverride shadowBlendOverride = BlendModeOverride.OFF;
    List<BufferBlendOverride> shadowBufferOverrides;
    Optional<AlphaTest> shadowAlpha;
    ProgramSet programSet;
    private final WorldRenderingPipeline parent;
    private final IntFunction<ProgramSamplers> createTerrainSamplers;
    private final IntFunction<ProgramSamplers> createShadowSamplers;
    private final IntFunction<ProgramImages> createTerrainImages;
    private final IntFunction<ProgramImages> createShadowImages;
    private static final Supplier<Optional<AlphaTest>> terrainCutoutDefault = () -> Optional.of(AlphaTests.ONE_TENTH_ALPHA);
    private static final Supplier<Optional<AlphaTest>> translucentDefault = () -> Optional.of(AlphaTest.ALWAYS);
    private static final Supplier<Optional<AlphaTest>> shadowDefault = () -> Optional.of(AlphaTests.NON_ZERO_ALPHA);

    public SodiumTerrainPipeline(WorldRenderingPipeline parent, ProgramSet programSet, IntFunction<ProgramSamplers> createTerrainSamplers, IntFunction<ProgramSamplers> createShadowSamplers, IntFunction<ProgramImages> createTerrainImages, IntFunction<ProgramImages> createShadowImages, RenderTargets targets, ImmutableSet<Integer> flippedAfterPrepare, ImmutableSet<Integer> flippedAfterTranslucent, GlFramebuffer shadowFramebuffer) {
        this.parent = Objects.requireNonNull(parent);
        Optional<ProgramSource> terrainSource = SodiumTerrainPipeline.first(programSet.getGbuffersTerrain(), programSet.getGbuffersTexturedLit(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> translucentSource = SodiumTerrainPipeline.first(programSet.getGbuffersWater(), terrainSource);
        this.programSet = programSet;
        this.shadowFramebuffer = shadowFramebuffer;
        terrainSource.ifPresent(sources -> {
            this.terrainFramebuffer = targets.createGbufferFramebuffer(flippedAfterPrepare, sources.getDirectives().getDrawBuffers());
        });
        translucentSource.ifPresent(sources -> {
            this.translucentFramebuffer = targets.createGbufferFramebuffer(flippedAfterTranslucent, sources.getDirectives().getDrawBuffers());
        });
        if (this.terrainFramebuffer == null) {
            this.terrainFramebuffer = targets.createGbufferFramebuffer(flippedAfterPrepare, new int[]{0});
        }
        if (this.translucentFramebuffer == null) {
            this.translucentFramebuffer = targets.createGbufferFramebuffer(flippedAfterTranslucent, new int[]{0});
        }
        this.createTerrainSamplers = createTerrainSamplers;
        this.createShadowSamplers = createShadowSamplers;
        this.createTerrainImages = createTerrainImages;
        this.createShadowImages = createShadowImages;
    }

    public void patchShaders(ChunkVertexType vertexType) {
        ShaderAttributeInputs inputs = new ShaderAttributeInputs(true, true, false, true, true);
        Optional<ProgramSource> terrainSource = SodiumTerrainPipeline.first(this.programSet.getGbuffersTerrain(), this.programSet.getGbuffersTexturedLit(), this.programSet.getGbuffersTextured(), this.programSet.getGbuffersBasic());
        Optional<ProgramSource> translucentSource = SodiumTerrainPipeline.first(this.programSet.getGbuffersWater(), terrainSource);
        terrainSource.ifPresentOrElse(sources -> {
            this.terrainBlendOverride = sources.getDirectives().getBlendModeOverride().orElse(ProgramId.Terrain.getBlendModeOverride());
            this.terrainBufferOverrides = new ArrayList<BufferBlendOverride>();
            sources.getDirectives().getBufferBlendOverrides().forEach(information -> {
                int index = Ints.indexOf((int[])sources.getDirectives().getDrawBuffers(), (int)information.getIndex());
                if (index > -1) {
                    this.terrainBufferOverrides.add(new BufferBlendOverride(index, information.getBlendMode()));
                }
            });
            this.terrainCutoutAlpha = sources.getDirectives().getAlphaTestOverride().or(terrainCutoutDefault);
            Map<PatchShaderType, String> transformed = TransformPatcher.patchSodium(sources.getVertexSource().orElse(null), sources.getGeometrySource().orElse(null), sources.getFragmentSource().orElse(null), this.terrainCutoutAlpha.get(), AlphaTest.ALWAYS, inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
            this.terrainVertex = Optional.ofNullable(transformed.get((Object)PatchShaderType.VERTEX));
            this.terrainGeometry = Optional.ofNullable(transformed.get((Object)PatchShaderType.GEOMETRY));
            this.terrainCutoutFragment = Optional.ofNullable(transformed.get((Object)PatchShaderType.FRAGMENT_CUTOUT));
            this.terrainFragment = Optional.ofNullable(transformed.get((Object)PatchShaderType.FRAGMENT));
            PatchedShaderPrinter.debugPatchedShaders(sources.getName() + "_sodium", this.terrainVertex.orElse(null), this.terrainGeometry.orElse(null), this.terrainFragment.orElse(null));
            PatchedShaderPrinter.debugPatchedShaders(sources.getName() + "_sodium_cutout", null, null, this.terrainCutoutFragment.orElse(null));
        }, () -> {
            this.terrainBlendOverride = null;
            this.terrainBufferOverrides = Collections.emptyList();
            this.terrainCutoutAlpha = terrainCutoutDefault.get();
            this.terrainVertex = Optional.empty();
            this.terrainGeometry = Optional.empty();
            this.terrainCutoutFragment = Optional.empty();
            this.terrainFragment = Optional.empty();
        });
        translucentSource.ifPresentOrElse(sources -> {
            this.translucentBlendOverride = sources.getDirectives().getBlendModeOverride().orElse(ProgramId.Water.getBlendModeOverride());
            this.translucentBufferOverrides = new ArrayList<BufferBlendOverride>();
            sources.getDirectives().getBufferBlendOverrides().forEach(information -> {
                int index = Ints.indexOf((int[])sources.getDirectives().getDrawBuffers(), (int)information.getIndex());
                if (index > -1) {
                    this.translucentBufferOverrides.add(new BufferBlendOverride(index, information.getBlendMode()));
                }
            });
            this.translucentAlpha = sources.getDirectives().getAlphaTestOverride().or(translucentDefault);
            Map<PatchShaderType, String> transformed = TransformPatcher.patchSodium(sources.getVertexSource().orElse(null), sources.getGeometrySource().orElse(null), sources.getFragmentSource().orElse(null), null, this.translucentAlpha.get(), inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
            this.translucentVertex = Optional.ofNullable(transformed.get((Object)PatchShaderType.VERTEX));
            this.translucentGeometry = Optional.ofNullable(transformed.get((Object)PatchShaderType.GEOMETRY));
            this.translucentFragment = Optional.ofNullable(transformed.get((Object)PatchShaderType.FRAGMENT));
            PatchedShaderPrinter.debugPatchedShaders(sources.getName() + "_sodium", this.translucentVertex.orElse(null), this.translucentGeometry.orElse(null), this.translucentFragment.orElse(null));
        }, () -> {
            this.translucentBlendOverride = null;
            this.translucentBufferOverrides = Collections.emptyList();
            this.translucentAlpha = translucentDefault.get();
            this.translucentVertex = Optional.empty();
            this.translucentGeometry = Optional.empty();
            this.translucentFragment = Optional.empty();
        });
        this.programSet.getShadow().ifPresentOrElse(sources -> {
            this.shadowBlendOverride = sources.getDirectives().getBlendModeOverride().orElse(ProgramId.Shadow.getBlendModeOverride());
            this.shadowBufferOverrides = new ArrayList<BufferBlendOverride>();
            sources.getDirectives().getBufferBlendOverrides().forEach(information -> {
                int index = Ints.indexOf((int[])sources.getDirectives().getDrawBuffers(), (int)information.getIndex());
                if (index > -1) {
                    this.shadowBufferOverrides.add(new BufferBlendOverride(index, information.getBlendMode()));
                }
            });
            this.shadowAlpha = sources.getDirectives().getAlphaTestOverride().or(shadowDefault);
            Map<PatchShaderType, String> transformed = TransformPatcher.patchSodium(sources.getVertexSource().orElse(null), sources.getGeometrySource().orElse(null), sources.getFragmentSource().orElse(null), this.shadowAlpha.get(), AlphaTest.ALWAYS, inputs, vertexType.getPositionScale(), vertexType.getPositionOffset(), vertexType.getTextureScale());
            this.shadowVertex = Optional.ofNullable(transformed.get((Object)PatchShaderType.VERTEX));
            this.shadowGeometry = Optional.ofNullable(transformed.get((Object)PatchShaderType.GEOMETRY));
            this.shadowCutoutFragment = Optional.ofNullable(transformed.get((Object)PatchShaderType.FRAGMENT_CUTOUT));
            this.shadowFragment = Optional.ofNullable(transformed.get((Object)PatchShaderType.FRAGMENT));
            PatchedShaderPrinter.debugPatchedShaders(sources.getName() + "_sodium", this.shadowVertex.orElse(null), this.shadowGeometry.orElse(null), this.shadowFragment.orElse(null));
            PatchedShaderPrinter.debugPatchedShaders(sources.getName() + "_sodium_cutout", null, null, this.shadowCutoutFragment.orElse(null));
        }, () -> {
            this.shadowBlendOverride = null;
            this.shadowBufferOverrides = Collections.emptyList();
            this.shadowAlpha = shadowDefault.get();
            this.shadowVertex = Optional.empty();
            this.shadowGeometry = Optional.empty();
            this.shadowCutoutFragment = Optional.empty();
            this.shadowFragment = Optional.empty();
        });
    }

    public Optional<String> getTerrainVertexShaderSource() {
        return this.terrainVertex;
    }

    public Optional<String> getTerrainGeometryShaderSource() {
        return this.terrainGeometry;
    }

    public Optional<String> getTerrainFragmentShaderSource() {
        return this.terrainFragment;
    }

    public Optional<String> getTerrainCutoutFragmentShaderSource() {
        return this.terrainCutoutFragment;
    }

    public GlFramebuffer getTerrainFramebuffer() {
        return this.terrainFramebuffer;
    }

    public BlendModeOverride getTerrainBlendOverride() {
        return this.terrainBlendOverride;
    }

    public List<BufferBlendOverride> getTerrainBufferOverrides() {
        return this.terrainBufferOverrides;
    }

    public Optional<AlphaTest> getTerrainCutoutAlpha() {
        return this.terrainCutoutAlpha;
    }

    public Optional<String> getTranslucentVertexShaderSource() {
        return this.translucentVertex;
    }

    public Optional<String> getTranslucentGeometryShaderSource() {
        return this.translucentGeometry;
    }

    public Optional<String> getTranslucentFragmentShaderSource() {
        return this.translucentFragment;
    }

    public GlFramebuffer getTranslucentFramebuffer() {
        return this.translucentFramebuffer;
    }

    public BlendModeOverride getTranslucentBlendOverride() {
        return this.translucentBlendOverride;
    }

    public List<BufferBlendOverride> getTranslucentBufferOverrides() {
        return this.translucentBufferOverrides;
    }

    public Optional<AlphaTest> getTranslucentAlpha() {
        return this.translucentAlpha;
    }

    public Optional<String> getShadowVertexShaderSource() {
        return this.shadowVertex;
    }

    public Optional<String> getShadowGeometryShaderSource() {
        return this.shadowGeometry;
    }

    public Optional<String> getShadowFragmentShaderSource() {
        return this.shadowFragment;
    }

    public Optional<String> getShadowCutoutFragmentShaderSource() {
        return this.shadowCutoutFragment;
    }

    public GlFramebuffer getShadowFramebuffer() {
        return this.shadowFramebuffer;
    }

    public BlendModeOverride getShadowBlendOverride() {
        return this.shadowBlendOverride;
    }

    public List<BufferBlendOverride> getShadowBufferOverrides() {
        return this.shadowBufferOverrides;
    }

    public Optional<AlphaTest> getShadowAlpha() {
        return this.shadowAlpha;
    }

    public ProgramUniforms initUniforms(int programId) {
        ProgramUniforms.Builder uniforms = ProgramUniforms.builder("<sodium shaders>", programId);
        CommonUniforms.addCommonUniforms(uniforms, this.programSet.getPack().getIdMap(), this.programSet.getPackDirectives(), this.parent.getFrameUpdateNotifier(), FogMode.PER_VERTEX);
        BuiltinReplacementUniforms.addBuiltinReplacementUniforms(uniforms);
        return uniforms.buildUniforms();
    }

    public boolean hasShadowPass() {
        return this.createShadowSamplers != null;
    }

    public ProgramSamplers initTerrainSamplers(int programId) {
        return this.createTerrainSamplers.apply(programId);
    }

    public ProgramSamplers initShadowSamplers(int programId) {
        return this.createShadowSamplers.apply(programId);
    }

    public ProgramImages initTerrainImages(int programId) {
        return this.createTerrainImages.apply(programId);
    }

    public ProgramImages initShadowImages(int programId) {
        return this.createShadowImages.apply(programId);
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... candidates) {
        for (Optional<T> candidate : candidates) {
            if (!candidate.isPresent()) continue;
            return candidate;
        }
        return Optional.empty();
    }

    public static String parseSodiumImport(String shader) {
        Pattern IMPORT_PATTERN = Pattern.compile("#import <(?<namespace>.*):(?<path>.*)>");
        Matcher matcher = IMPORT_PATTERN.matcher(shader);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Malformed import statement (expected format: " + IMPORT_PATTERN + ")");
        }
        String namespace = matcher.group("namespace");
        String path = matcher.group("path");
        ResourceLocation identifier = new ResourceLocation(namespace, path);
        return ShaderLoader.getShaderSource((ResourceLocation)identifier);
    }
}

