/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.IntSupplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.mixin.LightTextureAccessor;
import net.coderbot.iris.rendertarget.NativeImageBackedCustomTexture;
import net.coderbot.iris.rendertarget.NativeImageBackedNoiseTexture;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.texture.CustomTextureData;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.pbr.PBRTextureHolder;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.coderbot.iris.texture.pbr.PBRType;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class CustomTextureManager {
    private final EnumMap<TextureStage, Object2ObjectMap<String, IntSupplier>> customTextureIdMap = new EnumMap(TextureStage.class);
    private final IntSupplier noise;
    private final List<AbstractTexture> ownedTextures = new ArrayList<AbstractTexture>();

    public CustomTextureManager(PackDirectives packDirectives, EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> customTextureDataMap, Optional<CustomTextureData> customNoiseTextureData) {
        customTextureDataMap.forEach((textureStage, customTextureStageDataMap) -> {
            Object2ObjectOpenHashMap customTextureIds = new Object2ObjectOpenHashMap();
            customTextureStageDataMap.forEach((arg_0, arg_1) -> this.lambda$new$0((Object2ObjectMap)customTextureIds, textureStage, arg_0, arg_1));
            this.customTextureIdMap.put((TextureStage)((Object)textureStage), (Object2ObjectMap<String, IntSupplier>)customTextureIds);
        });
        this.noise = customNoiseTextureData.flatMap(textureData -> {
            try {
                return Optional.of(this.createCustomTexture((CustomTextureData)textureData));
            }
            catch (IOException | ResourceLocationException e) {
                Iris.logger.error("Unable to parse the image data for the custom noise texture", e);
                return Optional.empty();
            }
        }).orElseGet(() -> {
            int noiseTextureResolution = packDirectives.getNoiseTextureResolution();
            NativeImageBackedNoiseTexture texture = new NativeImageBackedNoiseTexture(noiseTextureResolution);
            this.ownedTextures.add((AbstractTexture)texture);
            return () -> ((AbstractTexture)texture).m_117963_();
        });
    }

    private IntSupplier createCustomTexture(CustomTextureData textureData) throws IOException, ResourceLocationException {
        if (textureData instanceof CustomTextureData.PngData) {
            NativeImageBackedCustomTexture texture = new NativeImageBackedCustomTexture((CustomTextureData.PngData)textureData);
            this.ownedTextures.add((AbstractTexture)texture);
            return () -> ((AbstractTexture)texture).m_117963_();
        }
        if (textureData instanceof CustomTextureData.LightmapMarker) {
            return () -> ((LightTextureAccessor)Minecraft.m_91087_().f_91063_.m_109154_()).getLightTexture().m_117963_();
        }
        if (textureData instanceof CustomTextureData.ResourceData) {
            CustomTextureData.ResourceData resourceData = (CustomTextureData.ResourceData)textureData;
            String namespace = resourceData.getNamespace();
            Object location = resourceData.getLocation();
            int extensionIndex = FilenameUtils.indexOfExtension((String)location);
            Object withoutExtension = extensionIndex != -1 ? ((String)location).substring(0, extensionIndex) : location;
            PBRType pbrType = PBRType.fromFileLocation((String)withoutExtension);
            TextureManager textureManager = Minecraft.m_91087_().m_91097_();
            if (pbrType == null) {
                ResourceLocation textureLocation = new ResourceLocation(namespace, (String)location);
                return () -> {
                    AbstractTexture texture = textureManager.m_118506_(textureLocation);
                    return texture != null ? texture.m_117963_() : MissingTextureAtlasSprite.m_118080_().m_117963_();
                };
            }
            location = ((String)location).substring(0, extensionIndex - pbrType.getSuffix().length()) + ((String)location).substring(extensionIndex);
            ResourceLocation textureLocation = new ResourceLocation(namespace, (String)location);
            return () -> {
                AbstractTexture texture = textureManager.m_118506_(textureLocation);
                if (texture != null) {
                    int id = texture.m_117963_();
                    PBRTextureHolder pbrHolder = PBRTextureManager.INSTANCE.getOrLoadHolder(id);
                    AbstractTexture pbrTexture = switch (pbrType) {
                        case PBRType.NORMAL -> pbrHolder.getNormalTexture();
                        case PBRType.SPECULAR -> pbrHolder.getSpecularTexture();
                        default -> throw new Error("Unknown PBRType '" + pbrType + "'");
                    };
                    TextureFormat textureFormat = TextureFormatLoader.getFormat();
                    if (textureFormat != null) {
                        int previousBinding = RenderSystem.m_157205_((int)GlStateManagerAccessor.getActiveTexture());
                        GlStateManager.m_84544_((int)pbrTexture.m_117963_());
                        textureFormat.setupTextureParameters(pbrType, pbrTexture);
                        GlStateManager.m_84544_((int)previousBinding);
                    }
                    return pbrTexture.m_117963_();
                }
                return MissingTextureAtlasSprite.m_118080_().m_117963_();
            };
        }
        throw new IllegalArgumentException("Unable to handle custom texture data " + textureData);
    }

    public EnumMap<TextureStage, Object2ObjectMap<String, IntSupplier>> getCustomTextureIdMap() {
        return this.customTextureIdMap;
    }

    public Object2ObjectMap<String, IntSupplier> getCustomTextureIdMap(TextureStage stage) {
        return this.customTextureIdMap.getOrDefault((Object)stage, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap());
    }

    public IntSupplier getNoiseTexture() {
        return this.noise;
    }

    public void destroy() {
        this.ownedTextures.forEach(AbstractTexture::close);
    }

    private /* synthetic */ void lambda$new$0(Object2ObjectMap customTextureIds, TextureStage textureStage, String samplerName, CustomTextureData textureData) {
        try {
            customTextureIds.put((Object)samplerName, (Object)this.createCustomTexture(textureData));
        }
        catch (IOException | ResourceLocationException e) {
            Iris.logger.error("Unable to parse the image data for the custom texture on stage " + textureStage + ", sampler " + samplerName, e);
        }
    }
}

