/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.program;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.ProgramManager;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.vendored.joml.Vector2f;
import net.coderbot.iris.vendored.joml.Vector3i;

public final class ComputeProgram
extends GlResource {
    private final ProgramUniforms uniforms;
    private final ProgramSamplers samplers;
    private final ProgramImages images;
    private Vector3i absoluteWorkGroups;
    private Vector2f relativeWorkGroups;
    private int[] localSize = new int[3];
    private float cachedWidth;
    private float cachedHeight;
    private Vector3i cachedWorkGroups;

    ComputeProgram(int program, ProgramUniforms uniforms, ProgramSamplers samplers, ProgramImages images) {
        super(program);
        IrisRenderSystem.getProgramiv(program, 33383, this.localSize);
        this.uniforms = uniforms;
        this.samplers = samplers;
        this.images = images;
    }

    public void setWorkGroupInfo(Vector2f relativeWorkGroups, Vector3i absoluteWorkGroups) {
        this.relativeWorkGroups = relativeWorkGroups;
        this.absoluteWorkGroups = absoluteWorkGroups;
    }

    public Vector3i getWorkGroups(float width, float height) {
        if (this.cachedWidth != width || this.cachedHeight != height || this.cachedWorkGroups == null) {
            this.cachedWidth = width;
            this.cachedHeight = height;
            this.cachedWorkGroups = this.absoluteWorkGroups != null ? this.absoluteWorkGroups : (this.relativeWorkGroups != null ? new Vector3i((int)Math.ceil(Math.ceil(width * this.relativeWorkGroups.x) / (double)this.localSize[0]), (int)Math.ceil(Math.ceil(height * this.relativeWorkGroups.y) / (double)this.localSize[1]), 1) : new Vector3i((int)Math.ceil(width / (float)this.localSize[0]), (int)Math.ceil(height / (float)this.localSize[1]), 1));
        }
        return this.cachedWorkGroups;
    }

    public void dispatch(float width, float height) {
        ProgramManager.m_85578_((int)this.getGlId());
        this.uniforms.update();
        this.samplers.update();
        this.images.update();
        if (!Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::allowConcurrentCompute).orElse(false).booleanValue()) {
            IrisRenderSystem.memoryBarrier(40);
        }
        IrisRenderSystem.dispatchCompute(this.getWorkGroups(width, height));
    }

    public static void unbind() {
        ProgramUniforms.clearActiveUniforms();
        ProgramManager.m_85578_((int)0);
    }

    @Override
    public void destroyInternal() {
        GlStateManager.m_84484_((int)this.getGlId());
    }

    @Deprecated
    public int getProgramId() {
        return this.getGlId();
    }

    public int getActiveImages() {
        return this.images.getActiveImages();
    }
}

