/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.texture.TextureInfoCache;

public class GlFramebuffer
extends GlResource {
    private final Int2IntMap attachments = new Int2IntArrayMap();
    private final int maxDrawBuffers = GlStateManager.m_84092_((int)34852);
    private final int maxColorAttachments = GlStateManager.m_84092_((int)36063);
    private boolean hasDepthAttachment = false;

    public GlFramebuffer() {
        super(IrisRenderSystem.createFramebuffer());
    }

    public void addDepthAttachment(int texture) {
        int internalFormat = TextureInfoCache.INSTANCE.getInfo(texture).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(internalFormat);
        int fb = this.getGlId();
        if (depthBufferFormat.isCombinedStencil()) {
            IrisRenderSystem.framebufferTexture2D(fb, 36160, 33306, 3553, texture, 0);
        } else {
            IrisRenderSystem.framebufferTexture2D(fb, 36160, 36096, 3553, texture, 0);
        }
        this.hasDepthAttachment = true;
    }

    public void addColorAttachment(int index, int texture) {
        int fb = this.getGlId();
        IrisRenderSystem.framebufferTexture2D(fb, 36160, 36064 + index, 3553, texture, 0);
        this.attachments.put(index, texture);
    }

    public void noDrawBuffers() {
        IrisRenderSystem.drawBuffers(this.getGlId(), new int[]{0});
    }

    public void drawBuffers(int[] buffers) {
        int[] glBuffers = new int[buffers.length];
        int index = 0;
        if (buffers.length > this.maxDrawBuffers) {
            throw new IllegalArgumentException("Cannot write to more than " + this.maxDrawBuffers + " draw buffers on this GPU");
        }
        for (int buffer : buffers) {
            if (buffer >= this.maxColorAttachments) {
                throw new IllegalArgumentException("Only " + this.maxColorAttachments + " color attachments are supported on this GPU, but an attempt was made to write to a color attachment with index " + buffer);
            }
            glBuffers[index++] = 36064 + buffer;
        }
        IrisRenderSystem.drawBuffers(this.getGlId(), glBuffers);
    }

    public void readBuffer(int buffer) {
        IrisRenderSystem.readBuffer(this.getGlId(), 36064 + buffer);
    }

    public int getColorAttachment(int index) {
        return this.attachments.get(index);
    }

    public boolean hasDepthAttachment() {
        return this.hasDepthAttachment;
    }

    public void bind() {
        GlStateManager.m_84486_((int)36160, (int)this.getGlId());
    }

    public void bindAsReadBuffer() {
        GlStateManager.m_84486_((int)36008, (int)this.getGlId());
    }

    public void bindAsDrawBuffer() {
        GlStateManager.m_84486_((int)36009, (int)this.getGlId());
    }

    @Override
    protected void destroyInternal() {
        GlStateManager.m_84502_((int)this.getGlId());
    }

    public boolean isComplete() {
        this.bind();
        int status = GlStateManager.m_84508_((int)36160);
        return status == 36053;
    }

    public int getId() {
        return this.getGlId();
    }
}

