/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Matrix4f;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.vendored.joml.Vector3i;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.ARBDrawBuffersBlend;
import org.lwjgl.opengl.EXTShaderImageLoadStore;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL42C;
import org.lwjgl.opengl.GL45C;

public class IrisRenderSystem {
    private static Matrix4f backupProjection;
    private static DSAAccess dsaState;
    private static boolean hasMultibind;
    private static boolean supportsCompute;

    public static void initRenderer() {
        if (GL.getCapabilities().OpenGL45) {
            dsaState = new DSACore();
            Iris.logger.info("OpenGL 4.5 detected, enabling DSA.");
        } else if (GL.getCapabilities().GL_ARB_direct_state_access) {
            dsaState = new DSAARB();
            Iris.logger.info("ARB_direct_state_access detected, enabling DSA.");
        } else {
            dsaState = new DSAUnsupported();
            Iris.logger.info("DSA support not detected.");
        }
        hasMultibind = GL.getCapabilities().OpenGL45 || GL.getCapabilities().GL_ARB_multi_bind;
        supportsCompute = GL.getCapabilities().glDispatchCompute != 0L;
    }

    public static void getIntegerv(int pname, int[] params) {
        RenderSystem.m_187555_();
        GL32C.glGetIntegerv((int)pname, (int[])params);
    }

    public static void getFloatv(int pname, float[] params) {
        RenderSystem.m_187555_();
        GL32C.glGetFloatv((int)pname, (float[])params);
    }

    public static void generateMipmaps(int texture, int mipmapTarget) {
        RenderSystem.m_187555_();
        dsaState.generateMipmaps(texture, mipmapTarget);
    }

    public static void bindAttributeLocation(int program, int index, CharSequence name) {
        RenderSystem.m_187555_();
        GL32C.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
    }

    public static void texImage2D(int texture, int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable ByteBuffer pixels) {
        RenderSystem.m_187555_();
        GlStateManager.m_84544_((int)texture);
        GL32C.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static void uniformMatrix4fv(int location, boolean transpose, FloatBuffer matrix) {
        RenderSystem.m_187555_();
        GL32C.glUniformMatrix4fv((int)location, (boolean)transpose, (FloatBuffer)matrix);
    }

    public static void copyTexImage2D(int target, int level, int internalFormat, int x, int y, int width, int height, int border) {
        RenderSystem.m_187555_();
        GL32C.glCopyTexImage2D((int)target, (int)level, (int)internalFormat, (int)x, (int)y, (int)width, (int)height, (int)border);
    }

    public static void uniform1f(int location, float v0) {
        RenderSystem.m_187555_();
        GL32C.glUniform1f((int)location, (float)v0);
    }

    public static void uniform2f(int location, float v0, float v1) {
        RenderSystem.m_187555_();
        GL32C.glUniform2f((int)location, (float)v0, (float)v1);
    }

    public static void uniform2i(int location, int v0, int v1) {
        RenderSystem.m_187555_();
        GL32C.glUniform2i((int)location, (int)v0, (int)v1);
    }

    public static void uniform3f(int location, float v0, float v1, float v2) {
        RenderSystem.m_187555_();
        GL32C.glUniform3f((int)location, (float)v0, (float)v1, (float)v2);
    }

    public static void uniform4f(int location, float v0, float v1, float v2, float v3) {
        RenderSystem.m_187555_();
        GL32C.glUniform4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
    }

    public static void uniform4i(int location, int v0, int v1, int v2, int v3) {
        RenderSystem.m_187555_();
        GL32C.glUniform4i((int)location, (int)v0, (int)v1, (int)v2, (int)v3);
    }

    public static void texParameteriv(int texture, int target, int pname, int[] params) {
        RenderSystem.m_187555_();
        dsaState.texParameteriv(texture, target, pname, params);
    }

    public static void texParameterivDirect(int target, int pname, int[] params) {
        RenderSystem.m_187555_();
        GL32C.glTexParameteriv((int)target, (int)pname, (int[])params);
    }

    public static void copyTexSubImage2D(int destTexture, int target, int i, int i1, int i2, int i3, int i4, int width, int height) {
        dsaState.copyTexSubImage2D(destTexture, target, i, i1, i2, i3, i4, width, height);
    }

    public static void texParameteri(int texture, int target, int pname, int param) {
        RenderSystem.m_187555_();
        dsaState.texParameteri(texture, target, pname, param);
    }

    public static void texParameterf(int texture, int target, int pname, float param) {
        RenderSystem.m_187555_();
        dsaState.texParameterf(texture, target, pname, param);
    }

    public static String getProgramInfoLog(int program) {
        RenderSystem.m_187555_();
        return GL32C.glGetProgramInfoLog((int)program);
    }

    public static String getShaderInfoLog(int shader) {
        RenderSystem.m_187555_();
        return GL32C.glGetShaderInfoLog((int)shader);
    }

    public static void drawBuffers(int framebuffer, int[] buffers) {
        RenderSystem.m_187555_();
        dsaState.drawBuffers(framebuffer, buffers);
    }

    public static void readBuffer(int framebuffer, int buffer) {
        RenderSystem.m_187555_();
        dsaState.readBuffer(framebuffer, buffer);
    }

    public static String getActiveUniform(int program, int index, int size, IntBuffer type, IntBuffer name) {
        RenderSystem.m_187555_();
        return GL32C.glGetActiveUniform((int)program, (int)index, (int)size, (IntBuffer)type, (IntBuffer)name);
    }

    public static void readPixels(int x, int y, int width, int height, int format, int type, float[] pixels) {
        RenderSystem.m_187555_();
        GL32C.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (float[])pixels);
    }

    public static void bufferData(int target, float[] data, int usage) {
        RenderSystem.m_187555_();
        GL32C.glBufferData((int)target, (float[])data, (int)usage);
    }

    public static int bufferStorage(int target, float[] data, int usage) {
        RenderSystem.m_187555_();
        return dsaState.bufferStorage(target, data, usage);
    }

    public static void vertexAttrib4f(int index, float v0, float v1, float v2, float v3) {
        RenderSystem.m_187555_();
        GL32C.glVertexAttrib4f((int)index, (float)v0, (float)v1, (float)v2, (float)v3);
    }

    public static void detachShader(int program, int shader) {
        RenderSystem.m_187555_();
        GL32C.glDetachShader((int)program, (int)shader);
    }

    public static void framebufferTexture2D(int fb, int fbtarget, int attachment, int target, int texture, int levels) {
        dsaState.framebufferTexture2D(fb, fbtarget, attachment, target, texture, levels);
    }

    public static int getTexParameteri(int texture, int target, int pname) {
        RenderSystem.m_187555_();
        return dsaState.getTexParameteri(texture, target, pname);
    }

    public static void bindImageTexture(int unit, int texture, int level, boolean layered, int layer, int access, int format) {
        RenderSystem.m_187555_();
        if (GL.getCapabilities().OpenGL42) {
            GL42C.glBindImageTexture((int)unit, (int)texture, (int)level, (boolean)layered, (int)layer, (int)access, (int)format);
        } else {
            EXTShaderImageLoadStore.glBindImageTextureEXT((int)unit, (int)texture, (int)level, (boolean)layered, (int)layer, (int)access, (int)format);
        }
    }

    public static int getMaxImageUnits() {
        if (GL.getCapabilities().OpenGL42) {
            return GlStateManager.m_84092_((int)36664);
        }
        if (GL.getCapabilities().GL_EXT_shader_image_load_store) {
            return GlStateManager.m_84092_((int)36664);
        }
        return 0;
    }

    public static void getProgramiv(int program, int value, int[] storage) {
        GL32C.glGetProgramiv((int)program, (int)value, (int[])storage);
    }

    public static void dispatchCompute(int workX, int workY, int workZ) {
        GL45C.glDispatchCompute((int)workX, (int)workY, (int)workZ);
    }

    public static void dispatchCompute(Vector3i workGroups) {
        GL45C.glDispatchCompute((int)workGroups.x, (int)workGroups.y, (int)workGroups.z);
    }

    public static void memoryBarrier(int barriers) {
        RenderSystem.m_187555_();
        if (supportsCompute) {
            GL45C.glMemoryBarrier((int)barriers);
        }
    }

    public static boolean supportsBufferBlending() {
        return GL.getCapabilities().GL_ARB_draw_buffers_blend || GL.getCapabilities().OpenGL40;
    }

    public static void disableBufferBlend(int buffer) {
        RenderSystem.m_187555_();
        GL32C.glDisablei((int)3042, (int)buffer);
    }

    public static void enableBufferBlend(int buffer) {
        RenderSystem.m_187555_();
        GL32C.glEnablei((int)3042, (int)buffer);
    }

    public static void blendFuncSeparatei(int buffer, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        RenderSystem.m_187555_();
        ARBDrawBuffersBlend.glBlendFuncSeparateiARB((int)buffer, (int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
    }

    public static void bindTextureToUnit(int unit, int texture) {
        dsaState.bindTextureToUnit(unit, texture);
    }

    public static int getUniformBlockIndex(int program, String uniformBlockName) {
        RenderSystem.m_187555_();
        return GL32C.glGetUniformBlockIndex((int)program, (CharSequence)uniformBlockName);
    }

    public static void uniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding) {
        RenderSystem.m_187555_();
        GL32C.glUniformBlockBinding((int)program, (int)uniformBlockIndex, (int)uniformBlockBinding);
    }

    public static void setShadowProjection(Matrix4f shadowProjection) {
        backupProjection = RenderSystem.m_157192_();
        RenderSystem.m_157425_((Matrix4f)shadowProjection);
    }

    public static void restorePlayerProjection() {
        RenderSystem.m_157425_((Matrix4f)backupProjection);
        backupProjection = null;
    }

    public static void blitFramebuffer(int source, int dest, int offsetX, int offsetY, int width, int height, int offsetX2, int offsetY2, int width2, int height2, int bufferChoice, int filter) {
        dsaState.blitFramebuffer(source, dest, offsetX, offsetY, width, height, offsetX2, offsetY2, width2, height2, bufferChoice, filter);
    }

    public static int createFramebuffer() {
        return dsaState.createFramebuffer();
    }

    public static int createTexture(int target) {
        return dsaState.createTexture(target);
    }

    public static boolean supportsCompute() {
        return supportsCompute;
    }

    public static class DSACore
    extends DSAARB {
    }

    public static interface DSAAccess {
        public void generateMipmaps(int var1, int var2);

        public void texParameteri(int var1, int var2, int var3, int var4);

        public void texParameterf(int var1, int var2, int var3, float var4);

        public void texParameteriv(int var1, int var2, int var3, int[] var4);

        public void readBuffer(int var1, int var2);

        public void drawBuffers(int var1, int[] var2);

        public int getTexParameteri(int var1, int var2, int var3);

        public void copyTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

        public void bindTextureToUnit(int var1, int var2);

        public int bufferStorage(int var1, float[] var2, int var3);

        public void blitFramebuffer(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

        public void framebufferTexture2D(int var1, int var2, int var3, int var4, int var5, int var6);

        public int createFramebuffer();

        public int createTexture(int var1);
    }

    public static class DSAARB
    extends DSAUnsupported {
        @Override
        public void generateMipmaps(int texture, int target) {
            ARBDirectStateAccess.glGenerateTextureMipmap((int)texture);
        }

        @Override
        public void texParameteri(int texture, int target, int pname, int param) {
            ARBDirectStateAccess.glTextureParameteri((int)texture, (int)pname, (int)param);
        }

        @Override
        public void texParameterf(int texture, int target, int pname, float param) {
            ARBDirectStateAccess.glTextureParameterf((int)texture, (int)pname, (float)param);
        }

        @Override
        public void texParameteriv(int texture, int target, int pname, int[] params) {
            ARBDirectStateAccess.glTextureParameteriv((int)texture, (int)pname, (int[])params);
        }

        @Override
        public void readBuffer(int framebuffer, int buffer) {
            ARBDirectStateAccess.glNamedFramebufferReadBuffer((int)framebuffer, (int)buffer);
        }

        @Override
        public void drawBuffers(int framebuffer, int[] buffers) {
            ARBDirectStateAccess.glNamedFramebufferDrawBuffers((int)framebuffer, (int[])buffers);
        }

        @Override
        public int getTexParameteri(int texture, int target, int pname) {
            return ARBDirectStateAccess.glGetTextureParameteri((int)texture, (int)pname);
        }

        @Override
        public void copyTexSubImage2D(int destTexture, int target, int i, int i1, int i2, int i3, int i4, int width, int height) {
            ARBDirectStateAccess.glCopyTextureSubImage2D((int)destTexture, (int)i, (int)i1, (int)i2, (int)i3, (int)i4, (int)width, (int)height);
        }

        @Override
        public void bindTextureToUnit(int unit, int texture) {
            ARBDirectStateAccess.glBindTextureUnit((int)unit, (int)texture);
            GlStateManagerAccessor.getTEXTURES()[unit].f_84801_ = texture;
        }

        @Override
        public int bufferStorage(int target, float[] data, int usage) {
            int buffer = GL45C.glCreateBuffers();
            GL45C.glNamedBufferData((int)buffer, (float[])data, (int)usage);
            return buffer;
        }

        @Override
        public void blitFramebuffer(int source, int dest, int offsetX, int offsetY, int width, int height, int offsetX2, int offsetY2, int width2, int height2, int bufferChoice, int filter) {
            ARBDirectStateAccess.glBlitNamedFramebuffer((int)source, (int)dest, (int)offsetX, (int)offsetY, (int)width, (int)height, (int)offsetX2, (int)offsetY2, (int)width2, (int)height2, (int)bufferChoice, (int)filter);
        }

        @Override
        public void framebufferTexture2D(int fb, int fbtarget, int attachment, int target, int texture, int levels) {
            ARBDirectStateAccess.glNamedFramebufferTexture((int)fb, (int)attachment, (int)texture, (int)levels);
        }

        @Override
        public int createFramebuffer() {
            return ARBDirectStateAccess.glCreateFramebuffers();
        }

        @Override
        public int createTexture(int target) {
            return ARBDirectStateAccess.glCreateTextures((int)target);
        }
    }

    public static class DSAUnsupported
    implements DSAAccess {
        @Override
        public void generateMipmaps(int texture, int target) {
            GlStateManager.m_84544_((int)texture);
            GL32C.glGenerateMipmap((int)target);
        }

        @Override
        public void texParameteri(int texture, int target, int pname, int param) {
            GlStateManager.m_84544_((int)texture);
            GL32C.glTexParameteri((int)target, (int)pname, (int)param);
        }

        @Override
        public void texParameterf(int texture, int target, int pname, float param) {
            GlStateManager.m_84544_((int)texture);
            GL32C.glTexParameterf((int)target, (int)pname, (float)param);
        }

        @Override
        public void texParameteriv(int texture, int target, int pname, int[] params) {
            GlStateManager.m_84544_((int)texture);
            GL32C.glTexParameteriv((int)target, (int)pname, (int[])params);
        }

        @Override
        public void readBuffer(int framebuffer, int buffer) {
            GlStateManager.m_84486_((int)36160, (int)framebuffer);
            GL32C.glReadBuffer((int)buffer);
        }

        @Override
        public void drawBuffers(int framebuffer, int[] buffers) {
            GlStateManager.m_84486_((int)36160, (int)framebuffer);
            GL32C.glDrawBuffers((int[])buffers);
        }

        @Override
        public int getTexParameteri(int texture, int target, int pname) {
            GlStateManager.m_84544_((int)texture);
            return GL32C.glGetTexParameteri((int)target, (int)pname);
        }

        @Override
        public void copyTexSubImage2D(int destTexture, int target, int i, int i1, int i2, int i3, int i4, int width, int height) {
            int previous = RenderSystem.m_157205_((int)GlStateManagerAccessor.getActiveTexture());
            GlStateManager.m_84544_((int)destTexture);
            GL32C.glCopyTexSubImage2D((int)target, (int)i, (int)i1, (int)i2, (int)i3, (int)i4, (int)width, (int)height);
            GlStateManager.m_84544_((int)previous);
        }

        @Override
        public void bindTextureToUnit(int unit, int texture) {
            int activeTexture = GlStateManager.m_157058_();
            GlStateManager.m_84538_((int)(33984 + unit));
            GlStateManager.m_84544_((int)texture);
            GlStateManager.m_84538_((int)activeTexture);
        }

        @Override
        public int bufferStorage(int target, float[] data, int usage) {
            int buffer = GlStateManager.m_84537_();
            GlStateManager.m_84480_((int)target, (int)buffer);
            IrisRenderSystem.bufferData(target, data, usage);
            GlStateManager.m_84480_((int)target, (int)0);
            return buffer;
        }

        @Override
        public void blitFramebuffer(int source, int dest, int offsetX, int offsetY, int width, int height, int offsetX2, int offsetY2, int width2, int height2, int bufferChoice, int filter) {
            GlStateManager.m_84486_((int)36008, (int)source);
            GlStateManager.m_84486_((int)36009, (int)dest);
            GL32C.glBlitFramebuffer((int)offsetX, (int)offsetY, (int)width, (int)height, (int)offsetX2, (int)offsetY2, (int)width2, (int)height2, (int)bufferChoice, (int)filter);
        }

        @Override
        public void framebufferTexture2D(int fb, int fbtarget, int attachment, int target, int texture, int levels) {
            GlStateManager.m_84486_((int)fbtarget, (int)fb);
            GL32C.glFramebufferTexture2D((int)fbtarget, (int)attachment, (int)target, (int)texture, (int)levels);
        }

        @Override
        public int createFramebuffer() {
            int framebuffer = GlStateManager.m_84543_();
            GlStateManager.m_84486_((int)36160, (int)framebuffer);
            return framebuffer;
        }

        @Override
        public int createTexture(int target) {
            int texture = GlStateManager.m_84111_();
            GlStateManager.m_84544_((int)texture);
            return texture;
        }
    }
}

