/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterNio;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import net.coderbot.iris.compat.sodium.impl.block_context.BlockContextHolder;
import net.coderbot.iris.compat.sodium.impl.block_context.ContextAwareVertexWriter;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPModelVertexType;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.NormalHelper;

public class XHFPModelVertexBufferWriterNio
extends VertexBufferWriterNio
implements ModelVertexSink,
ContextAwareVertexWriter {
    private final QuadViewTerrain.QuadViewTerrainNio quad = new QuadViewTerrain.QuadViewTerrainNio();
    private final Vector3f normal = new Vector3f();
    private BlockContextHolder contextHolder;
    private int vertexCount;
    private float uSum;
    private float vSum;

    public XHFPModelVertexBufferWriterNio(VertexBufferView backingBuffer) {
        super(backingBuffer, (BufferVertexType)IrisModelVertexFormats.MODEL_VERTEX_XHFP);
    }

    @Override
    public void copyQuadAndFlipNormal() {
        this.ensureCapacity(4);
        ByteBuffer src = this.byteBuffer.duplicate();
        ByteBuffer dst = this.byteBuffer.duplicate();
        src.position(this.byteBuffer.position() + this.writeOffset - 176);
        src.limit(src.position() + 176);
        dst.position(this.byteBuffer.position() + this.writeOffset);
        dst.limit(dst.position() + 176);
        dst.put(src);
        int packedNormal = this.byteBuffer.getInt(this.writeOffset + 32);
        int inverted = NormalHelper.invertPackedNormal(packedNormal);
        this.byteBuffer.putInt(this.writeOffset + 32, inverted);
        this.byteBuffer.putInt(this.writeOffset + 32 + 44, inverted);
        this.byteBuffer.putInt(this.writeOffset + 32 + 88, inverted);
        this.byteBuffer.putInt(this.writeOffset + 32 + 132, inverted);
        for (int i = 0; i < 4; ++i) {
            this.advance();
        }
        this.flush();
    }

    public void writeVertex(float posX, float posY, float posZ, int color, float u, float v, int light, int chunkId) {
        this.uSum += u;
        this.vSum += v;
        short materialId = this.contextHolder.blockId;
        short renderType = this.contextHolder.renderType;
        this.writeQuadInternal(posX, posY, posZ, color, u, v, light, materialId, renderType, chunkId, ExtendedDataHelper.computeMidBlock(posX, posY, posZ, this.contextHolder.localPosX, this.contextHolder.localPosY, this.contextHolder.localPosZ));
    }

    private void writeQuadInternal(float posX, float posY, float posZ, int color, float u, float v, int light, short materialId, short renderType, int chunkId, int packedMidBlock) {
        int i = this.writeOffset;
        ++this.vertexCount;
        ByteBuffer buffer = this.byteBuffer;
        buffer.putShort(i + 0, XHFPModelVertexType.encodePosition(posX));
        buffer.putShort(i + 2, XHFPModelVertexType.encodePosition(posY));
        buffer.putShort(i + 4, XHFPModelVertexType.encodePosition(posZ));
        buffer.putShort(i + 6, (short)chunkId);
        buffer.putInt(i + 8, color);
        buffer.putShort(i + 12, XHFPModelVertexType.encodeBlockTexture(u));
        buffer.putShort(i + 14, XHFPModelVertexType.encodeBlockTexture(v));
        buffer.putInt(i + 16, XHFPModelVertexType.encodeLightMapTexCoord(light));
        buffer.putShort(i + 36, materialId);
        buffer.putShort(i + 38, renderType);
        buffer.putInt(i + 40, packedMidBlock);
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum *= 0.25f;
            this.vSum *= 0.25f;
            buffer.putFloat(i + 20, this.uSum);
            buffer.putFloat(i + 20 - 44, this.uSum);
            buffer.putFloat(i + 20 - 88, this.uSum);
            buffer.putFloat(i + 20 - 132, this.uSum);
            buffer.putFloat(i + 24, this.vSum);
            buffer.putFloat(i + 24 - 44, this.vSum);
            buffer.putFloat(i + 24 - 88, this.vSum);
            buffer.putFloat(i + 24 - 132, this.vSum);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.quad.setup(buffer, i, 44);
            NormalHelper.computeFaceNormal(this.normal, this.quad);
            int packedNormal = NormalHelper.packNormal(this.normal, 0.0f);
            buffer.putInt(i + 32, packedNormal);
            buffer.putInt(i + 32 - 44, packedNormal);
            buffer.putInt(i + 32 - 88, packedNormal);
            buffer.putInt(i + 32 - 132, packedNormal);
            int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            buffer.putInt(i + 28, tangent);
            buffer.putInt(i + 28 - 44, tangent);
            buffer.putInt(i + 28 - 88, tangent);
            buffer.putInt(i + 28 - 132, tangent);
        }
        this.advance();
    }

    @Override
    public void iris$setContextHolder(BlockContextHolder holder) {
        this.contextHolder = holder;
    }
}

