/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.block_rendering;

import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockRenderingSettings {
    public static final BlockRenderingSettings INSTANCE = new BlockRenderingSettings();
    private boolean reloadRequired = false;
    private Object2IntMap<BlockState> blockStateIds = null;
    private Map<Block, RenderType> blockTypeIds = null;
    private Object2IntFunction<NamespacedId> entityIds;
    private float ambientOcclusionLevel = 1.0f;
    private boolean disableDirectionalShading = false;
    private boolean useSeparateAo = false;
    private boolean useExtendedVertexFormat = false;

    public boolean isReloadRequired() {
        return this.reloadRequired;
    }

    public void clearReloadRequired() {
        this.reloadRequired = false;
    }

    @Nullable
    public Object2IntMap<BlockState> getBlockStateIds() {
        return this.blockStateIds;
    }

    @Nullable
    public Map<Block, RenderType> getBlockTypeIds() {
        return this.blockTypeIds;
    }

    @Nullable
    public Object2IntFunction<NamespacedId> getEntityIds() {
        return this.entityIds;
    }

    public void setBlockStateIds(Object2IntMap<BlockState> blockStateIds) {
        if (this.blockStateIds != null && this.blockStateIds.equals(blockStateIds)) {
            return;
        }
        this.reloadRequired = true;
        this.blockStateIds = blockStateIds;
    }

    public void setBlockTypeIds(Map<Block, RenderType> blockTypeIds) {
        if (this.blockTypeIds != null && this.blockTypeIds.equals(blockTypeIds)) {
            return;
        }
        this.reloadRequired = true;
        this.blockTypeIds = blockTypeIds;
    }

    public void setEntityIds(Object2IntFunction<NamespacedId> entityIds) {
        this.entityIds = entityIds;
    }

    public float getAmbientOcclusionLevel() {
        return this.ambientOcclusionLevel;
    }

    public void setAmbientOcclusionLevel(float ambientOcclusionLevel) {
        if (ambientOcclusionLevel == this.ambientOcclusionLevel) {
            return;
        }
        this.reloadRequired = true;
        this.ambientOcclusionLevel = ambientOcclusionLevel;
    }

    public boolean shouldDisableDirectionalShading() {
        return this.disableDirectionalShading;
    }

    public void setDisableDirectionalShading(boolean disableDirectionalShading) {
        if (disableDirectionalShading == this.disableDirectionalShading) {
            return;
        }
        this.reloadRequired = true;
        this.disableDirectionalShading = disableDirectionalShading;
    }

    public boolean shouldUseSeparateAo() {
        return this.useSeparateAo;
    }

    public void setUseSeparateAo(boolean useSeparateAo) {
        if (useSeparateAo == this.useSeparateAo) {
            return;
        }
        this.reloadRequired = true;
        this.useSeparateAo = useSeparateAo;
    }

    public boolean shouldUseExtendedVertexFormat() {
        return this.useExtendedVertexFormat;
    }

    public void setUseExtendedVertexFormat(boolean useExtendedVertexFormat) {
        if (useExtendedVertexFormat == this.useExtendedVertexFormat) {
            return;
        }
        this.reloadRequired = true;
        this.useExtendedVertexFormat = useExtendedVertexFormat;
    }
}

