/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.batchedentityrendering.impl;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.coderbot.batchedentityrendering.impl.BufferBuilderExt;
import net.coderbot.batchedentityrendering.impl.BufferSegment;
import net.coderbot.batchedentityrendering.impl.MemoryTrackingBuffer;
import net.coderbot.batchedentityrendering.impl.RenderTypeUtil;
import net.coderbot.batchedentityrendering.mixin.RenderTypeAccessor;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public class SegmentedBufferBuilder
implements MultiBufferSource,
MemoryTrackingBuffer {
    private final BufferBuilder buffer = new BufferBuilder(524288);
    private final List<RenderType> usedTypes = new ArrayList<RenderType>(256);
    private RenderType currentType = null;

    public VertexConsumer m_6299_(RenderType renderType) {
        if (!Objects.equals(this.currentType, renderType)) {
            if (this.currentType != null) {
                if (SegmentedBufferBuilder.shouldSortOnUpload(this.currentType)) {
                    this.buffer.m_166771_(0.0f, 0.0f, 0.0f);
                }
                this.buffer.m_85721_();
                this.usedTypes.add(this.currentType);
            }
            this.buffer.m_166779_(renderType.m_173186_(), renderType.m_110508_());
            this.currentType = renderType;
        }
        if (RenderTypeUtil.isTriangleStripDrawMode(this.currentType)) {
            ((BufferBuilderExt)this.buffer).splitStrip();
        }
        return this.buffer;
    }

    public List<BufferSegment> getSegments() {
        if (this.currentType == null) {
            return Collections.emptyList();
        }
        this.usedTypes.add(this.currentType);
        if (SegmentedBufferBuilder.shouldSortOnUpload(this.currentType)) {
            this.buffer.m_166771_(0.0f, 0.0f, 0.0f);
        }
        this.buffer.m_85721_();
        this.currentType = null;
        ArrayList<BufferSegment> segments = new ArrayList<BufferSegment>(this.usedTypes.size());
        for (RenderType type : this.usedTypes) {
            Pair pair = this.buffer.m_85728_();
            BufferBuilder.DrawState parameters = (BufferBuilder.DrawState)pair.getFirst();
            ByteBuffer slice = (ByteBuffer)pair.getSecond();
            segments.add(new BufferSegment(slice, parameters, type));
        }
        this.usedTypes.clear();
        return segments;
    }

    private static boolean shouldSortOnUpload(RenderType type) {
        return ((RenderTypeAccessor)type).shouldSortOnUpload();
    }

    @Override
    public int getAllocatedSize() {
        return ((MemoryTrackingBuffer)this.buffer).getAllocatedSize();
    }

    @Override
    public int getUsedSize() {
        return ((MemoryTrackingBuffer)this.buffer).getUsedSize();
    }

    @Override
    public void freeAndDeleteBuffer() {
        ((MemoryTrackingBuffer)this.buffer).freeAndDeleteBuffer();
    }
}

