/*
 * Decompiled with CFR 0.152.
 */
package llamalad7.mixinextras.sugar.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import llamalad7.mixinextras.sugar.Local;
import llamalad7.mixinextras.sugar.impl.SugarApplicationException;
import llamalad7.mixinextras.sugar.impl.SugarApplicator;
import llamalad7.mixinextras.sugar.impl.SugarWrapper;
import llamalad7.mixinextras.utils.ASMUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;

class SugarInjector {
    private static final String SUGAR_PACKAGE = Type.getDescriptor(Local.class).substring(0, Type.getDescriptor(Local.class).lastIndexOf(47) + 1);
    private static final Set<String> PREPARED_MIXINS = new HashSet<String>();
    private final InjectionInfo injectionInfo;
    private final IMixinInfo mixin;
    private Map<Target, List<InjectionNodes.InjectionNode>> targets;
    private String desugaredHandlerDesc;
    private final MethodNode handler;
    private final List<Type> sugarParams = new ArrayList<Type>();
    private final List<List<AnnotationNode>> sugarParamAnnotations = new ArrayList<List<AnnotationNode>>();
    private final List<SugarApplicator> applicators = new ArrayList<SugarApplicator>();
    private final List<SugarApplicationException> exceptions = new ArrayList<SugarApplicationException>();

    SugarInjector(InjectionInfo injectionInfo, IMixinInfo mixin, MethodNode handler) {
        this.injectionInfo = injectionInfo;
        this.mixin = mixin;
        this.handler = handler;
    }

    void setTargets(Map<Target, List<InjectionNodes.InjectionNode>> targets) {
        this.targets = targets;
    }

    static void prepareMixin(IMixinInfo mixinInfo, ClassNode mixinNode) {
        if (PREPARED_MIXINS.contains(mixinInfo.getClassName())) {
            return;
        }
        for (MethodNode method : mixinNode.methods) {
            if (!SugarInjector.hasSugar(method)) continue;
            SugarInjector.wrapInjectorAnnotation(mixinInfo, method);
        }
        PREPARED_MIXINS.add(mixinInfo.getClassName());
    }

    private static boolean hasSugar(MethodNode method) {
        List[] annotations = method.invisibleParameterAnnotations;
        if (annotations == null) {
            return false;
        }
        for (List paramAnnotations : annotations) {
            if (paramAnnotations == null) continue;
            for (AnnotationNode annotation : paramAnnotations) {
                if (!annotation.desc.startsWith(SUGAR_PACKAGE)) continue;
                return true;
            }
        }
        return false;
    }

    private static void wrapInjectorAnnotation(IMixinInfo mixin, MethodNode method) {
        AnnotationNode injectorAnnotation = InjectionInfo.getInjectorAnnotation((IMixinInfo)mixin, (MethodNode)method);
        if (injectorAnnotation == null) {
            return;
        }
        AnnotationNode wrapped = new AnnotationNode(Type.getDescriptor(SugarWrapper.class));
        wrapped.visit("original", (Object)injectorAnnotation);
        method.visibleAnnotations.remove(injectorAnnotation);
        method.visibleAnnotations.add(wrapped);
    }

    void stripSugar() {
        ArrayList<Type> params = new ArrayList<Type>();
        ArrayList<List> invisibleAnnotations = new ArrayList<List>();
        boolean foundSugar = false;
        int i = 0;
        for (Type type : Type.getArgumentTypes((String)this.handler.desc)) {
            List annotations = this.handler.invisibleParameterAnnotations[i];
            if (annotations == null || annotations.stream().noneMatch(it -> it != null && it.desc.startsWith(SUGAR_PACKAGE))) {
                if (foundSugar) {
                    throw new IllegalStateException(String.format("Found non-trailing sugared parameters on %s", this.handler.name + this.handler.desc));
                }
                params.add(type);
                invisibleAnnotations.add(annotations);
            } else {
                foundSugar = true;
                this.sugarParams.add(type);
                this.sugarParamAnnotations.add(annotations);
            }
            ++i;
        }
        this.handler.invisibleParameterAnnotations = invisibleAnnotations.toArray(new List[0]);
        this.desugaredHandlerDesc = this.handler.desc = Type.getMethodDescriptor((Type)Type.getReturnType((String)this.handler.desc), (Type[])params.toArray(new Type[0]));
    }

    void prepareSugar() {
        for (Pair<Type, AnnotationNode> sugar : this.findSugars()) {
            this.applicators.add(SugarApplicator.create(this.injectionInfo, (Type)sugar.getLeft(), (AnnotationNode)sugar.getRight()));
        }
        for (SugarApplicator applicator : this.applicators) {
            for (Map.Entry<Target, List<InjectionNodes.InjectionNode>> entry : this.targets.entrySet()) {
                Target target = entry.getKey();
                ListIterator<InjectionNodes.InjectionNode> it = entry.getValue().listIterator();
                while (it.hasNext()) {
                    InjectionNodes.InjectionNode node = it.next();
                    try {
                        applicator.validate(target, node);
                    }
                    catch (SugarApplicationException e) {
                        this.exceptions.add(new SugarApplicationException(String.format("Failed to validate sugar %s on method %s from mixin %s in target method %s at instruction %s", ASMUtils.annotationToString(applicator.sugar), this.handler.name + this.handler.desc, this.mixin, target, node), (Throwable)((Object)e)));
                        it.remove();
                    }
                }
            }
        }
    }

    void applySugar() {
        this.reSugar();
        for (Target target : this.targets.keySet()) {
            for (MethodInsnNode targetInsn : this.findHandlerCalls(target)) {
                InjectionNodes.InjectionNode node = target.addInjectionNode((AbstractInsnNode)targetInsn);
                try {
                    for (SugarApplicator applicator : this.applicators) {
                        applicator.preInject(target, node);
                    }
                    for (SugarApplicator applicator : this.applicators) {
                        applicator.inject(target, node);
                    }
                }
                catch (Exception e) {
                    throw new SugarApplicationException(String.format("Failed to apply sugar to method %s from mixin %s in target method %s at instruction %s", this.handler.name + this.handler.desc, this.mixin, target, node), e);
                }
                targetInsn.desc = this.handler.desc;
            }
        }
    }

    List<SugarApplicationException> getExceptions() {
        return this.exceptions;
    }

    private void reSugar() {
        ArrayList<Type> paramTypes = new ArrayList<Type>(Arrays.asList(Type.getArgumentTypes((String)this.handler.desc)));
        List paramAnnotations = new ArrayList<List>(Arrays.asList(this.handler.invisibleParameterAnnotations == null ? new List[paramTypes.size()] : this.handler.invisibleParameterAnnotations));
        paramTypes.addAll(this.sugarParams);
        paramAnnotations.addAll(this.sugarParamAnnotations);
        this.handler.desc = Type.getMethodDescriptor((Type)Type.getReturnType((String)this.handler.desc), (Type[])paramTypes.toArray(new Type[0]));
        this.handler.invisibleParameterAnnotations = paramAnnotations.toArray(new List[0]);
    }

    private List<MethodInsnNode> findHandlerCalls(Target target) {
        ArrayList<MethodInsnNode> result = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode insn : target) {
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode call = (MethodInsnNode)insn;
            if (!call.owner.equals(target.classNode.name) || !call.name.equals(this.handler.name) || !call.desc.equals(this.desugaredHandlerDesc)) continue;
            result.add(call);
        }
        return result;
    }

    private List<Pair<Type, AnnotationNode>> findSugars() {
        if (this.handler.invisibleParameterAnnotations == null) {
            return Collections.emptyList();
        }
        ArrayList<Pair<Type, AnnotationNode>> result = new ArrayList<Pair<Type, AnnotationNode>>();
        int i = 0;
        for (List<AnnotationNode> annotationNodes : this.sugarParamAnnotations) {
            AnnotationNode sugar = this.findSugar(annotationNodes);
            if (sugar != null) {
                result.add((Pair<Type, AnnotationNode>)Pair.of((Object)this.sugarParams.get(i), (Object)sugar));
            }
            ++i;
        }
        return result;
    }

    private AnnotationNode findSugar(List<AnnotationNode> annotations) {
        if (annotations == null) {
            return null;
        }
        AnnotationNode result = null;
        for (AnnotationNode annotation : annotations) {
            if (!annotation.desc.startsWith(SUGAR_PACKAGE)) continue;
            if (result != null) {
                throw new IllegalStateException("Found multiple sugars on the same parameter! Got " + annotations.stream().map(ASMUtils::annotationToString).collect(Collectors.joining(" ")));
            }
            result = annotation;
        }
        return result;
    }
}

