/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.cst.transform;

import io.github.douira.glsl_transformer.GLSLLexer;
import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.cst.transform.Node;
import io.github.douira.glsl_transformer.cst.transform.Transformation;
import io.github.douira.glsl_transformer.cst.transform.TransformationPhase;
import io.github.douira.glsl_transformer.cst.transform.lifecycle.LifecycleUser;
import io.github.douira.glsl_transformer.cst.traversal.DynamicParseTreeWalker;
import io.github.douira.glsl_transformer.cst.traversal.ProxyParseTreeListener;
import io.github.douira.glsl_transformer.job_parameter.JobParameters;
import io.github.douira.glsl_transformer.job_parameter.ParameterHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import repack.antlr.v4.runtime.BufferedTokenStream;

public abstract class ExecutionPlanner<T extends JobParameters>
implements ParameterHolder<T> {
    private Map<T, ExecutionPlan> executionPlanCache = new HashMap<T, ExecutionPlan>();
    private Transformation<T> rootTransformation;
    private GLSLParser.TranslationUnitContext rootNode;
    private ProxyParseTreeListener proxyListener;
    private T jobParameters;

    public ExecutionPlanner() {
    }

    public ExecutionPlanner(Transformation<T> rootTransformation) {
        this.rootTransformation = rootTransformation;
    }

    public abstract GLSLParser getParser();

    public abstract GLSLLexer getLexer();

    @Override
    public T getJobParameters() {
        return this.jobParameters;
    }

    @Override
    public void setJobParameters(T jobParameters) {
        this.jobParameters = jobParameters;
    }

    public void withJobParameters(T parameters, Runnable run) {
        this.withJobParameters(parameters, () -> {
            run.run();
            return null;
        });
    }

    public GLSLParser.TranslationUnitContext getRootNode() {
        return this.rootNode;
    }

    public void addConcurrent(LifecycleUser<T> rootDependency) {
        this.getRootTransformation().addRootDependency(rootDependency);
    }

    public Transformation<T> getRootTransformation() {
        if (this.rootTransformation == null) {
            this.rootTransformation = new Transformation();
        }
        return this.rootTransformation;
    }

    public void setRootTransformation(Transformation<T> rootTransformation) {
        this.rootTransformation = rootTransformation;
    }

    void removeCurrentPhaseFromWalk() {
        this.proxyListener.removeCurrentListener();
    }

    private ExecutionPlan getExecutionPlan() {
        Object jobParameters = this.getJobParameters();
        ExecutionPlan plan = this.executionPlanCache.get(jobParameters);
        if (plan == null) {
            plan = new ExecutionPlan();
            plan.planExecution();
            this.executionPlanCache.put(jobParameters, plan);
        }
        return plan;
    }

    public void planExecutionFor(T parameters) {
        this.withJobParameters(parameters, this::getExecutionPlan);
    }

    private void execute(GLSLParser.TranslationUnitContext ctx) {
        ExecutionPlan plan = this.getExecutionPlan();
        this.rootNode = ctx;
        plan.execute(this);
        this.rootNode = null;
    }

    protected void transformTree(GLSLParser.TranslationUnitContext ctx, BufferedTokenStream tokenStream) {
        ctx.makeLocalRoot(tokenStream);
        this.execute(ctx);
    }

    private class ExecutionPlan {
        List<ExecutionLevel<T>> executionLevels;
        Collection<Transformation<T>> transformations;

        private ExecutionPlan() {
        }

        /*
         * WARNING - void declaration
         */
        void planExecution() {
            HashSet transformationSet = new HashSet();
            HashSet dependenciesProcessed = new HashSet();
            HashMap endNodeMap = new HashMap();
            HashMap contentNodeMap = new HashMap();
            LinkedList collectQueue = new LinkedList();
            ExecutionPlanner.this.getRootTransformation().setPlanner(ExecutionPlanner.this);
            ExecutionPlanner.this.getRootTransformation().doGraphSetup();
            LabeledNode rootNode = new LabeledNode();
            collectQueue.add(new CollectEntry(new Node(ExecutionPlanner.this.getRootTransformation()), rootNode));
            while (!collectQueue.isEmpty()) {
                void var10_13;
                CollectEntry queueEntry = (CollectEntry)collectQueue.poll();
                Node node = queueEntry.nodeToProcess();
                LifecycleUser content = node.getContent();
                if (content == null) {
                    LabeledNode labeledNode = Optional.ofNullable((LabeledNode)endNodeMap.get(node)).orElseGet(LabeledNode::new);
                } else {
                    LabeledNode labeledNode = Optional.ofNullable((LabeledNode)contentNodeMap.get(content)).orElseGet(() -> {
                        LabeledNode newNode = new LabeledNode(content);
                        contentNodeMap.put(content, newNode);
                        return newNode;
                    });
                }
                queueEntry.dependent().linkDependency(var10_13);
                if (dependenciesProcessed.contains(node)) continue;
                dependenciesProcessed.add(node);
                if (Transformation.class.isInstance(content)) {
                    Iterator transformation = (Transformation)content;
                    transformationSet.add(transformation);
                    Node node2 = ((Transformation)((Object)transformation)).getEndDepNode();
                    LabeledNode endLabeledNode = Optional.ofNullable((LabeledNode)endNodeMap.get(node2)).orElseGet(() -> {
                        LabeledNode newNode = new LabeledNode();
                        endNodeMap.put(endNode, newNode);
                        return newNode;
                    });
                    for (Node dependency : node.getDependencies()) {
                        collectQueue.add(new CollectEntry(dependency, endLabeledNode));
                    }
                    collectQueue.add(new CollectEntry(((Transformation)((Object)transformation)).getRootDepNode(), var10_13));
                    continue;
                }
                for (Node node3 : node.getDependencies()) {
                    collectQueue.add(new CollectEntry(node3, var10_13));
                }
            }
            this.transformations = new ArrayList();
            this.transformations.addAll(transformationSet);
            for (Transformation transformation : this.transformations) {
                for (Node node : transformation.getContentNodes()) {
                    if (!contentNodeMap.containsKey(node.getContent())) {
                        throw new AssertionError((Object)"There is a transformation with a node that has content that was not found traversing the dependency graph. The dependency graph is not well-formed.");
                    }
                }
                if (!endNodeMap.containsKey(transformation.getEndDepNode())) {
                    throw new AssertionError((Object)"There is a transformation with an unreachable end node. The dependency graph is not well-formed.");
                }
            }
            LinkedList dfsStack = new LinkedList();
            dfsStack.push(new DFSEntry(rootNode, true));
            ArrayList arrayList = new ArrayList();
            while (!dfsStack.isEmpty()) {
                if (dfsStack.size() > dependenciesProcessed.size() * 2) {
                    throw new AssertionError((Object)"The dependency graph could not be satisfied! There is may be a cycle in it or the root and end nodes are messed up. Check for cycles in the graph after construction and after resolving transformations. Also make sure there is a single end and a single (generated) root node.");
                }
                DFSEntry entry = (DFSEntry)dfsStack.pop();
                LabeledNode labeledNode = entry.node();
                if (entry.enter()) {
                    if (labeledNode.dfsFinished) continue;
                    dfsStack.push(new DFSEntry(labeledNode, false));
                    for (LabeledNode labeledNode2 : labeledNode.dependencies) {
                        dfsStack.push(new DFSEntry(labeledNode2, true));
                    }
                    continue;
                }
                labeledNode.dfsFinished = true;
                arrayList.add(labeledNode);
            }
            this.executionLevels = new ArrayList();
            this.executionLevels.add(new ExecutionLevel());
            ((LabeledNode)arrayList.get((int)0)).executionLevelIndex = -1;
            for (LabeledNode labeledNode : arrayList) {
                for (LabeledNode labeledNode3 : labeledNode.dependencies) {
                    if (labeledNode3.executionLevelIndex <= labeledNode.executionLevelIndex) continue;
                    labeledNode.executionLevelIndex = labeledNode3.executionLevelIndex;
                }
                if (!TransformationPhase.class.isInstance(labeledNode.content)) continue;
                TransformationPhase phase = (TransformationPhase)labeledNode.content;
                if (phase.canWalk()) {
                    ++labeledNode.executionLevelIndex;
                    if (this.executionLevels.size() <= labeledNode.executionLevelIndex + 1) {
                        this.executionLevels.add(new ExecutionLevel());
                    }
                    this.executionLevels.get((int)(labeledNode.executionLevelIndex + 1)).walkPhases.add(phase);
                    continue;
                }
                this.executionLevels.get((int)(labeledNode.executionLevelIndex + 1)).nonWalkPhases.add(phase);
            }
        }

        void execute(ExecutionPlanner<T> planner) {
            for (Transformation transformation : this.transformations) {
                transformation.setPlanner(planner);
                transformation.initOnce();
                transformation.triggerJobInternal();
                transformation.resetState();
            }
            for (ExecutionLevel executionLevel : this.executionLevels) {
                ExecutionPlanner.this.proxyListener = new ProxyParseTreeListener();
                for (TransformationPhase walkPhase : executionLevel.walkPhases()) {
                    walkPhase.setPlanner(planner);
                    walkPhase.initOnce();
                    walkPhase.resetState();
                    if (!walkPhase.checkBeforeWalk(ExecutionPlanner.this.rootNode)) continue;
                    ExecutionPlanner.this.proxyListener.add(walkPhase);
                    walkPhase.resetWalkFinishState();
                }
                if (ExecutionPlanner.this.proxyListener.needsWalk()) {
                    DynamicParseTreeWalker.walkTree(ExecutionPlanner.this.proxyListener, ExecutionPlanner.this.rootNode);
                }
                for (TransformationPhase walkPhase : executionLevel.walkPhases()) {
                    walkPhase.runAfterWalk(ExecutionPlanner.this.rootNode);
                }
                for (TransformationPhase nonWalkPhase : executionLevel.nonWalkPhases()) {
                    nonWalkPhase.setPlanner(planner);
                    nonWalkPhase.initOnce();
                    nonWalkPhase.resetState();
                    nonWalkPhase.checkBeforeWalk(ExecutionPlanner.this.rootNode);
                    nonWalkPhase.runAfterWalk(ExecutionPlanner.this.rootNode);
                }
            }
            ExecutionPlanner.this.proxyListener = null;
        }

        static class LabeledNode<S extends JobParameters> {
            final LifecycleUser<S> content;
            Collection<LabeledNode<S>> dependencies = new HashSet<LabeledNode<S>>();
            Collection<LabeledNode<S>> dependents = new HashSet<LabeledNode<S>>();
            int executionLevelIndex = Integer.MIN_VALUE;
            boolean dfsFinished = false;

            LabeledNode(LifecycleUser<S> content) {
                this.content = content;
            }

            LabeledNode() {
                this.content = null;
            }

            void linkDependency(LabeledNode<S> dependency) {
                this.dependencies.add(dependency);
                dependency.dependents.add(this);
            }
        }

        record CollectEntry<S extends JobParameters>(Node<S> nodeToProcess, LabeledNode<S> dependent) {
        }

        record DFSEntry<S extends JobParameters>(LabeledNode<S> node, boolean enter) {
        }

        private record ExecutionLevel<S extends JobParameters>(Collection<TransformationPhase<S>> walkPhases, List<TransformationPhase<S>> nonWalkPhases) {
            public ExecutionLevel() {
                this(new ArrayList<TransformationPhase<S>>(), new ArrayList<TransformationPhase<S>>());
            }
        }
    }
}

