/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.cst.transform;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.util.ExcludeFromJacocoGeneratedReport;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CSTInjectionPoint {
    BEFORE_VERSION,
    BEFORE_EXTENSIONS{

        @Override
        protected boolean checkChildRelevant(Class<?> childClass) {
            return BEFORE_DIRECTIVES.checkChildRelevant(childClass) || childClass == GLSLParser.ExtensionStatementContext.class;
        }
    }
    ,
    BEFORE_DIRECTIVES{

        @Override
        protected boolean checkChildRelevant(Class<?> childClass) {
            return BEFORE_DECLARATIONS.checkChildRelevant(childClass) || childClass == GLSLParser.PragmaStatementContext.class;
        }
    }
    ,
    BEFORE_DECLARATIONS{

        @Override
        protected boolean checkChildRelevant(Class<?> childClass) {
            return BEFORE_FUNCTIONS.checkChildRelevant(childClass) || childClass == GLSLParser.LayoutDefaultsContext.class || GLSLParser.DeclarationContext.class.isAssignableFrom(childClass);
        }
    }
    ,
    BEFORE_FUNCTIONS{

        @Override
        protected boolean checkChildRelevant(Class<?> childClass) {
            return childClass == GLSLParser.FunctionDefinitionContext.class;
        }
    }
    ,
    END;


    @ExcludeFromJacocoGeneratedReport
    protected boolean checkChildRelevant(Class<?> childClass) {
        throw new AssertionError((Object)"A non-special injection point doesn't have a child relevance implementation!");
    }
}

