/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.cst.print;

import io.github.douira.glsl_transformer.cst.node.UnparsableCSTNode;
import io.github.douira.glsl_transformer.cst.print.CachingIntervalSet;
import io.github.douira.glsl_transformer.cst.token_filter.TokenFilter;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import java.util.LinkedList;
import repack.antlr.v4.runtime.BufferedTokenStream;
import repack.antlr.v4.runtime.Token;
import repack.antlr.v4.runtime.misc.Interval;
import repack.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import repack.antlr.v4.runtime.tree.ParseTree;
import repack.antlr.v4.runtime.tree.RuleNode;
import repack.antlr.v4.runtime.tree.TerminalNode;

public class PrintVisitor
extends AbstractParseTreeVisitor<Void> {
    private final LinkedList<Object> printItems = new LinkedList();
    private Interval cachedInterval;
    private ExtendedContext currentRoot;

    private PrintVisitor() {
    }

    private static boolean inInterval(Interval interval, int el) {
        return interval.a <= el && interval.b >= el;
    }

    public static String printTree(BufferedTokenStream rootTokenStream, ExtendedContext tree, TokenFilter<?> tokenFilter) {
        tree.makeLocalRoot(rootTokenStream);
        return new PrintVisitor().visitAndJoin(rootTokenStream, tree, tree.getFullSourceInterval(), tokenFilter);
    }

    public static String printTree(BufferedTokenStream rootTokenStream, ExtendedContext tree) {
        return PrintVisitor.printTree(rootTokenStream, tree, null);
    }

    private String visitAndJoin(BufferedTokenStream rootTokenStream, ExtendedContext rootNode, Interval bounds, TokenFilter<?> tokenFilter) {
        this.currentRoot = rootNode;
        this.visit(rootNode);
        if (tokenFilter != null) {
            tokenFilter.resetState();
        }
        StringBuilder builder = new StringBuilder(512);
        for (Object e : this.printItems) {
            if (e instanceof String) {
                String literal = (String)e;
                builder.append(literal);
                continue;
            }
            if (e instanceof AttributedInterval) {
                AttributedInterval attributedInterval = (AttributedInterval)e;
                Interval interval = attributedInterval.interval();
                ExtendedContext localRoot = attributedInterval.localRoot();
                CachingIntervalSet omissionSet = localRoot.getLocalRootTokenOmissions();
                for (Token token : localRoot.getTokenStream().getTokens(interval.a, interval.b)) {
                    int tokenIndex = token.getTokenIndex();
                    if (token.getType() == -1 || tokenIndex != -1 && (localRoot == rootNode && !PrintVisitor.inInterval(bounds, tokenIndex) || !omissionSet.tokenNotOmitted(token) || tokenFilter != null && !tokenFilter.isTokenAllowed(token))) continue;
                    builder.append(token.getText());
                }
                continue;
            }
            throw new AssertionError((Object)"A wrong type of object was inserted into the printItems! Only String and AttributedInterval are allowed.");
        }
        return builder.toString();
    }

    private void addInterval(int a, int b) {
        Interval interval;
        if (a > b || a < 0 || b < 0) {
            return;
        }
        if (this.cachedInterval != null && a == this.cachedInterval.a && b == this.cachedInterval.b) {
            interval = this.cachedInterval;
        } else {
            this.cachedInterval = interval = Interval.of(a, b);
        }
        this.addInterval(interval);
    }

    private void addInterval(Interval newInterval) {
        AttributedInterval lastPrintInterval;
        Interval lastInterval;
        Object lastPrintItem;
        if (newInterval.length() == 0) {
            return;
        }
        if (!this.printItems.isEmpty() && (lastPrintItem = this.printItems.getLast()) instanceof AttributedInterval && (lastInterval = (lastPrintInterval = (AttributedInterval)lastPrintItem).interval()) != null && this.currentRoot == lastPrintInterval.localRoot() && (!lastInterval.disjoint(newInterval) || lastInterval.adjacent(newInterval))) {
            if (lastInterval.properlyContains(newInterval)) {
                return;
            }
            this.printItems.removeLast();
            newInterval = lastInterval.union(newInterval);
        }
        this.printItems.add(new AttributedInterval(this.currentRoot, newInterval));
    }

    private void addLiteral(String literal) {
        if (literal == null || literal.isEmpty()) {
            return;
        }
        this.printItems.add(literal);
    }

    @Override
    public Void visitChildren(RuleNode node) {
        ExtendedContext context = (ExtendedContext)node.getRuleContext();
        Interval superInterval = context.getLargestSourceInterval();
        boolean lastWasUnparsableASTNode = false;
        int fetchNext = superInterval.a;
        if (context.children != null) {
            int childrenLength = context.children.size();
            for (int i = 0; i < childrenLength; ++i) {
                ExtendedContext childNode;
                ParseTree child = (ParseTree)context.children.get(i);
                if (child instanceof UnparsableCSTNode) {
                    UnparsableCSTNode unparsableCSTNode = (UnparsableCSTNode)child;
                    if (!lastWasUnparsableASTNode && unparsableCSTNode.doNewlineInsertion()) {
                        this.addLiteral("\n");
                        lastWasUnparsableASTNode = true;
                    }
                } else {
                    lastWasUnparsableASTNode = false;
                }
                if (child instanceof ExtendedContext && (childNode = (ExtendedContext)child).isLocalRoot()) {
                    ExtendedContext previousRoot = this.currentRoot;
                    this.currentRoot = childNode;
                    child.accept(this);
                    this.currentRoot = previousRoot;
                    continue;
                }
                Interval childInterval = child.getSourceInterval();
                if (childInterval.length() > 0) {
                    this.addInterval(fetchNext, childInterval.a - 1);
                    child.accept(this);
                    fetchNext = childInterval.b + 1;
                    continue;
                }
                if (childInterval == Interval.INVALID) {
                    int previousChildEnd = i > 0 ? ((ParseTree)context.children.get((int)(i - 1))).getSourceInterval().b : -1;
                    Integer nextOpening = this.currentRoot.getLocalRootOpenings().higher(previousChildEnd);
                    if (nextOpening != null && nextOpening >= fetchNext) {
                        int nextChildStart;
                        int n = nextChildStart = i < childrenLength - 1 ? ((ParseTree)context.children.get((int)(i + 1))).getSourceInterval().a : -1;
                        if (nextChildStart == -1 || nextOpening < nextChildStart) {
                            this.addInterval(fetchNext, nextOpening);
                            fetchNext = nextOpening + 1;
                        }
                    }
                }
                child.accept(this);
            }
        }
        this.addInterval(fetchNext, superInterval.b);
        return null;
    }

    @Override
    public Void visitTerminal(TerminalNode node) {
        this.addInterval(node.getSourceInterval());
        if (node instanceof UnparsableCSTNode) {
            UnparsableCSTNode astNode = (UnparsableCSTNode)node;
            this.addLiteral(astNode.getText());
        }
        return null;
    }

    private record AttributedInterval(ExtendedContext localRoot, Interval interval) {
    }
}

