/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.cst.core;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.cst.core.CachePolicy;
import io.github.douira.glsl_transformer.cst.core.ConfigurableTransformation;
import io.github.douira.glsl_transformer.cst.core.target.HandlerTarget;
import io.github.douira.glsl_transformer.cst.core.target.ParsedReplaceTargetImpl;
import io.github.douira.glsl_transformer.cst.core.target.TerminalReplaceTargetImpl;
import io.github.douira.glsl_transformer.cst.transform.WalkPhase;
import io.github.douira.glsl_transformer.job_parameter.JobParameters;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import io.github.douira.glsl_transformer.tree.TreeMember;
import io.github.douira.glsl_transformer.util.CompatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import repack.antlr.v4.runtime.Token;
import repack.antlr.v4.runtime.tree.TerminalNode;

public class SearchTerminals<T extends JobParameters>
extends ConfigurableTransformation<T> {
    public static final int IDENTIFIER = 257;
    public static final int ANY_TYPE = 0;
    protected Collection<HandlerTarget<T>> targetsDirect = new ArrayList<HandlerTarget<T>>(0);
    private Supplier<Boolean> requireFullMatch = this.once(this::getRequireFullMatch);
    private Supplier<Integer> terminalTokenType = this.once(this::getTerminalTokenType);
    private Supplier<Collection<HandlerTarget<T>>> targets = this.once(this::getTargets);

    public SearchTerminals() {
        this.addEndDependent(new TerminalVisitor().activation(this::isActive));
    }

    @Override
    public SearchTerminals<T> activation(Supplier<Boolean> activation) {
        super.activation((Supplier)activation);
        return this;
    }

    protected boolean findNeedle(String content, HandlerTarget<T> target) {
        String needle = target.getNeedle();
        if (needle == null) {
            return false;
        }
        return this.requireFullMatch() ? content.equals(needle) : content.contains(needle);
    }

    public SearchTerminals<T> addTarget(HandlerTarget<T> target) {
        this.targetsDirect.add(target);
        return this;
    }

    public SearchTerminals<T> addReplacement(String needle, String newContent, Function<GLSLParser, ExtendedContext> parseMethod) {
        this.addTarget(new ParsedReplaceTargetImpl(needle, newContent, parseMethod));
        return this;
    }

    public SearchTerminals<T> addReplacementExpression(String needle, String expressionContent) {
        this.addReplacement(needle, expressionContent, GLSLParser::expression);
        return this;
    }

    public SearchTerminals<T> addReplacementTerminal(String needle, String terminalContent) {
        this.addTarget(new TerminalReplaceTargetImpl(needle, terminalContent));
        return this;
    }

    protected int getTerminalTokenType() {
        return 257;
    }

    protected boolean getRequireFullMatch() {
        return true;
    }

    protected Collection<HandlerTarget<T>> getTargets() {
        if (this.targetsDirect.isEmpty()) {
            throw new IllegalStateException("No targets are set");
        }
        return this.targetsDirect;
    }

    public SearchTerminals<T> terminalTokenType(int terminalTokenType) {
        this.terminalTokenType = this.swapSupplier(this.terminalTokenType, terminalTokenType);
        return this;
    }

    public SearchTerminals<T> requireFullMatch(boolean requireFullMatch) {
        this.requireFullMatch = this.swapSupplier(this.requireFullMatch, requireFullMatch);
        return this;
    }

    public SearchTerminals<T> targets(Collection<HandlerTarget<T>> targets) {
        this.targets = this.swapSupplier(this.targets, targets);
        return this;
    }

    public SearchTerminals<T> singleTarget(HandlerTarget<T> target) {
        return this.targets(CompatUtil.listOf(target));
    }

    public SearchTerminals<T> terminalTokenType(Supplier<Integer> terminalTokenType) {
        this.terminalTokenType = this.swapSupplier(this.terminalTokenType, terminalTokenType);
        return this;
    }

    public SearchTerminals<T> requireFullMatch(Supplier<Boolean> requireFullMatch) {
        this.requireFullMatch = this.swapSupplier(this.requireFullMatch, requireFullMatch);
        return this;
    }

    public SearchTerminals<T> targets(Supplier<Collection<HandlerTarget<T>>> targets) {
        this.targets = this.swapSupplier(this.targets, targets);
        return this;
    }

    public SearchTerminals<T> terminalTokenType(CachePolicy newPolicy) {
        this.terminalTokenType = this.swapPolicy(this.terminalTokenType, newPolicy);
        return this;
    }

    public SearchTerminals<T> requireFullMatch(CachePolicy newPolicy) {
        this.requireFullMatch = this.swapPolicy(this.requireFullMatch, newPolicy);
        return this;
    }

    public SearchTerminals<T> targets(CachePolicy newPolicy) {
        this.targets = this.swapPolicy(this.targets, newPolicy);
        return this;
    }

    protected final int terminalTokenType() {
        return this.terminalTokenType.get();
    }

    protected final boolean requireFullMatch() {
        return this.requireFullMatch.get();
    }

    protected final Collection<HandlerTarget<T>> targets() {
        return this.targets.get();
    }

    private class TerminalVisitor
    extends WalkPhase<T> {
        private TerminalVisitor() {
        }

        @Override
        public void visitTerminal(TerminalNode node) {
            Token token = node.getSymbol();
            if (token == null) {
                return;
            }
            int targetType = SearchTerminals.this.terminalTokenType();
            if (targetType == 0 || targetType == token.getType()) {
                String text = token.getText();
                Collection targets = SearchTerminals.this.targets();
                if (targets == null) {
                    return;
                }
                for (HandlerTarget target : targets) {
                    if (!SearchTerminals.this.findNeedle(text, target)) continue;
                    if (!(node instanceof TreeMember)) {
                        throw new IllegalStateException("All nodes in the parse tree should be a TreeMember except for when they are errors! Then the tree is broken anyways.");
                    }
                    target.setPlanner(this.getPlanner());
                    target.handleResult((TreeMember)((Object)node), text);
                }
            }
        }
    }
}

