/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.query.match;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.query.match.HintedMatcher;
import io.github.douira.glsl_transformer.ast.transform.ASTBuilder;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import java.util.function.BiFunction;
import java.util.function.Function;

public class AutoHintedMatcher<T extends ASTNode>
extends HintedMatcher<T> {
    public <RuleType extends ExtendedContext> AutoHintedMatcher(String input, Function<GLSLParser, RuleType> parseMethod, BiFunction<ASTBuilder, RuleType, T> visitMethod, String wildcardPrefix) {
        super(input, parseMethod, visitMethod, wildcardPrefix, null);
    }

    public AutoHintedMatcher(T pattern, String wildcardPrefix) {
        super(pattern, wildcardPrefix, null);
    }

    public AutoHintedMatcher(T pattern) {
        super(pattern, null);
    }

    public <RuleType extends ExtendedContext> AutoHintedMatcher(String input, Function<GLSLParser, RuleType> parseMethod, BiFunction<ASTBuilder, RuleType, T> visitMethod) {
        super(input, parseMethod, visitMethod, null);
    }

    public AutoHintedMatcher(String input, Function<String, T> patternParser, String wildcardPrefix) {
        super(input, patternParser, wildcardPrefix, null);
    }

    public AutoHintedMatcher(String input, Function<String, T> patternParser) {
        super(input, patternParser, (String)null);
    }

    private void determineHint() {
        this.preparePatternItems();
        String longestHint = null;
        int hintLength = 0;
        for (Object item : this.patternItems) {
            Identifier id;
            String idContent;
            if (!(item instanceof Identifier) || (idContent = (id = (Identifier)item).getName()).length() <= hintLength || this.wildcardPrefix != null && idContent.startsWith(this.wildcardPrefix)) continue;
            longestHint = idContent;
            hintLength = idContent.length();
        }
        if (longestHint == null) {
            throw new IllegalArgumentException("The provided pattern must contain a non-wildcard identifier to use as the hint!");
        }
        this.hint = longestHint;
    }

    @Override
    public String getHint() {
        if (this.hint == null) {
            this.determineHint();
        }
        return super.getHint();
    }
}

